/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;

class DragDropInfo {
    private Component source;
    private int x;
    private int y;

    DragDropInfo() {
    }

    void clear() {
        this.source(null);
    }

    void update(@Nonnull MouseEvent event) {
        int mouseEventId = event.getID();
        if (mouseEventId == 502 || mouseEventId == 503) {
            this.clear();
            return;
        }
        if (mouseEventId == 501) {
            this.source(event.getComponent());
            this.x = event.getX();
            this.y = event.getY();
        }
    }

    @Nullable
    Component source() {
        return this.source;
    }

    void source(@Nullable Component newSource) {
        this.source = newSource;
    }

    boolean isDragging() {
        return this.source != null;
    }

    @Nonnull
    Point origin() {
        return new Point(this.x, this.y);
    }

    void origin(@Nonnull Point origin) {
        this.x = origin.x;
        this.y = origin.y;
    }

    boolean isNativeDragActive() {
        try {
            Class<?> type = Class.forName("sun.awt.dnd.SunDragSourceContextPeer");
            try {
                Reflection.method((String)"checkDragDropInProgress").in(type).invoke(new Object[0]);
                return false;
            }
            catch (ReflectionError e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof InvocationTargetException)) {
                    return false;
                }
                return ((InvocationTargetException)cause).getTargetException() instanceof InvalidDnDOperationException;
            }
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

