/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.JInternalFrameDesktopPaneQuery;

class ParentFinder {
    ParentFinder() {
    }

    @Nullable
    @RunsInCurrentThread
    Container parentOf(@Nonnull Component c) {
        Container p = c.getParent();
        if (p == null && c instanceof JInternalFrame) {
            p = this.parentOf((JInternalFrame)c);
        }
        return p;
    }

    @Nullable
    @RunsInCurrentThread
    private Container parentOf(@Nonnull JInternalFrame internalFrame) {
        return JInternalFrameDesktopPaneQuery.desktopPaneOf(internalFrame);
    }

    @Nullable
    Window windowFor(@Nullable Component c) {
        Component invoker;
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        if (c instanceof MenuElement && (invoker = this.invokerFor(c)) != null) {
            return this.windowFor(invoker);
        }
        return this.windowFor(this.parentOf(c));
    }

    @Nullable
    @RunsInCurrentThread
    Component invokerFor(@Nonnull Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        return this.invokerFor(parent);
    }
}

