/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import javax.annotation.Nonnull;
import javax.swing.JMenuItem;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JMenuItemMatcher;
import org.fest.swing.format.Formatting;

class JMenuItemFinder {
    private final Robot robot;
    private final Container target;

    JMenuItemFinder(@Nonnull Robot robot, @Nonnull Container target) {
        this.robot = robot;
        this.target = target;
    }

    @Nonnull
    JMenuItem menuItemWithPath(String ... path) {
        JMenuItemMatcher m = new JMenuItemMatcher(path);
        Component item = this.robot.finder().find(this.target, m);
        ((ObjectAssert)Assertions.assertThat((Object)item).as(Formatting.format(item))).isInstanceOf(JMenuItem.class);
        return (JMenuItem)item;
    }
}

