/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JScrollPaneDriver
extends JComponentDriver {
    public JScrollPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Nonnull
    @RunsInEDT
    public JScrollBar horizontalScrollBarIn(@Nonnull JScrollPane scrollPane) {
        return JScrollPaneDriver.horizontalScrollBar(scrollPane);
    }

    @Nonnull
    @RunsInEDT
    private static JScrollBar horizontalScrollBar(final @Nonnull JScrollPane scrollPane) {
        JScrollBar result = GuiActionRunner.execute(new GuiQuery<JScrollBar>(){

            @Override
            protected JScrollBar executeInEDT() {
                return scrollPane.getHorizontalScrollBar();
            }
        });
        return (JScrollBar)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    public JScrollBar verticalScrollBarIn(@Nonnull JScrollPane scrollPane) {
        return JScrollPaneDriver.verticalScrollBar(scrollPane);
    }

    @Nonnull
    @RunsInEDT
    private static JScrollBar verticalScrollBar(final @Nonnull JScrollPane scrollPane) {
        JScrollBar result = GuiActionRunner.execute(new GuiQuery<JScrollBar>(){

            @Override
            protected JScrollBar executeInEDT() {
                return scrollPane.getVerticalScrollBar();
            }
        });
        return (JScrollBar)Preconditions.checkNotNull((Object)result);
    }
}

