/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.VersionChecksKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\u00020\u0001:\u0002./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J.\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0018\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u001aH\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J+\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001eJ/\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010!J7\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$JM\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u001c\b\u0002\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002\u00a2\u0006\u0002\u0010)JY\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00142\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00112\u001c\b\u0002\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002\u00a2\u0006\u0002\u0010,JD\u0010-\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u001a\u0010+\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010j\u0004\u0018\u0001`\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/lint/checks/VersionChecks;", "", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;)V", "getApiLevel", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "call", "Lorg/jetbrains/uast/UCallExpression;", "element", "Lorg/jetbrains/uast/UExpression;", "apiLevelLookup", "Lkotlin/Function1;", "Lorg/jetbrains/uast/UElement;", "Lcom/android/tools/lint/checks/ApiLevelLookup;", "isAndedWithConditional", "", "api", "isLowerBound", "before", "isOredWithConditional", "isSdkInt", "Lcom/intellij/psi/PsiElement;", "isUnconditionalReturn", "statement", "isValidFromAnnotation", "(ILcom/intellij/psi/PsiModifierListOwner;Lorg/jetbrains/uast/UCallExpression;)Ljava/lang/Boolean;", "isValidVersionCall", "and", "(IZZLorg/jetbrains/uast/UCallExpression;)Ljava/lang/Boolean;", "method", "Lcom/intellij/psi/PsiMethod;", "(IZZLorg/jetbrains/uast/UElement;Lcom/intellij/psi/PsiMethod;)Ljava/lang/Boolean;", "isVersionCheckConditional", "fromThen", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "(IZZLorg/jetbrains/uast/UBinaryExpression;Lkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "prev", "apiLookup", "(IZLorg/jetbrains/uast/UElement;ZLorg/jetbrains/uast/UElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "isWithinVersionCheckConditional", "Companion", "VersionCheckWithExitFinder", "android.sdktools.lint-checks"})
public final class VersionChecks {
    private final JavaEvaluator evaluator;
    @NotNull
    public static final String SDK_INT = "SDK_INT";
    @NotNull
    public static final String CHECKS_SDK_INT_AT_LEAST_ANNOTATION = "androidx.annotation.ChecksSdkIntAtLeast";
    private static final String GET_BUILD_SDK_INT = "getBuildSdkInt";
    private static final String[] VERSION_METHOD_NAME_PREFIXES;
    private static final String[] VERSION_METHOD_NAME_SUFFIXES;
    public static final Companion Companion;

    private final boolean isUnconditionalReturn(UExpression statement) {
        List expressions;
        int statements;
        if (statement instanceof UBlockExpression && (statements = (expressions = ((UBlockExpression)statement).getExpressions()).size()) > 0) {
            String methodName;
            UExpression last = (UExpression)expressions.get(statements - 1);
            if (last instanceof UReturnExpression || last instanceof UThrowExpression) {
                return true;
            }
            if (last instanceof UCallExpression && (Intrinsics.areEqual((Object)"error", (Object)(methodName = Lint.getMethodName((UCallExpression)((UCallExpression)last)))) || Intrinsics.areEqual((Object)"TODO", (Object)methodName))) {
                return true;
            }
        }
        return statement instanceof UReturnExpression;
    }

    private final boolean isWithinVersionCheckConditional(JavaEvaluator evaluator, UElement element, int api, boolean isLowerBound, Function1<? super UElement, Integer> apiLookup) {
        UElement current = Lint.skipParentheses((UElement)element.getUastParent());
        UElement prev = element;
        while (current != null) {
            if (current instanceof UIfExpression) {
                boolean fromThen;
                Boolean ok;
                UElement ifStatement = current;
                UExpression condition = ((UIfExpression)ifStatement).getCondition();
                if (prev != condition && (ok = this.isVersionCheckConditional(api, isLowerBound, (UElement)condition, fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)ifStatement).getThenExpression()), prev, apiLookup)) != null && ok.booleanValue()) {
                    return true;
                }
            } else {
                if (current instanceof UPolyadicExpression && (this.isAndedWithConditional(current, api, isLowerBound, prev) || this.isOredWithConditional(current, api, isLowerBound, prev))) {
                    return true;
                }
                if (current instanceof USwitchClauseExpressionWithBody) {
                    for (UExpression condition : ((USwitchClauseExpressionWithBody)current).getCaseValues()) {
                        Boolean ok = this.isVersionCheckConditional(api, isLowerBound, (UElement)condition, true, prev, apiLookup);
                        if (ok == null || !ok.booleanValue()) continue;
                        return true;
                    }
                } else if (current instanceof UCallExpression && prev instanceof ULambdaExpression) {
                    UElement call = current;
                    PsiMethod method = ((UCallExpression)call).resolve();
                    if (method != null) {
                        Boolean validFromAnnotation = this.isValidFromAnnotation(api, (PsiModifierListOwner)method, (UCallExpression)call);
                        if (validFromAnnotation != null) {
                            return validFromAnnotation;
                        }
                        Map mapping = evaluator.computeArgumentMapping((UCallExpression)call, method);
                        PsiParameter parameter = (PsiParameter)mapping.get(prev);
                        if (parameter != null) {
                            String parameterName;
                            UMethod uMethod;
                            if ((UMethod)UastFacade.INSTANCE.convertElementWithParent((PsiElement)method, UMethod.class) == null) {
                                return false;
                            }
                            Ref match = new Ref();
                            Intrinsics.checkExpressionValueIsNotNull((Object)parameter.getName(), (String)"parameter.name");
                            uMethod.accept((UastVisitor)new AbstractUastVisitor(parameterName, match){
                                final /* synthetic */ String $parameterName;
                                final /* synthetic */ Ref $match;

                                public boolean visitCallExpression(@NotNull UCallExpression node) {
                                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                                    String callName = Lint.getMethodName((UCallExpression)node);
                                    if (Intrinsics.areEqual((Object)callName, (Object)this.$parameterName)) {
                                        this.$match.set((Object)node);
                                    }
                                    return super.visitCallExpression(node);
                                }
                                {
                                    this.$parameterName = $captured_local_variable$0;
                                    this.$match = $captured_local_variable$1;
                                }
                            });
                            UCallExpression lambdaInvocation = (UCallExpression)match.get();
                            Function1 newApiLookup2 = (Function1)new Function1<UElement, Integer>(this, call){
                                final /* synthetic */ VersionChecks this$0;
                                final /* synthetic */ UElement $call;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final int invoke(@NotNull UElement reference) {
                                    void var2_2;
                                    PsiParameterList parameterList;
                                    PsiElement resolved;
                                    Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                                    int apiLevel = -1;
                                    if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null) {
                                        int index = parameterList.getParameterIndex((PsiParameter)resolved);
                                        List arguments = ((UCallExpression)this.$call).getValueArguments();
                                        if (index != -1 && index < arguments.size()) {
                                            apiLevel = VersionChecks.access$getApiLevel(this.this$0, (UExpression)arguments.get(index), null);
                                        }
                                    }
                                    return (int)var2_2;
                                }
                                {
                                    this.this$0 = versionChecks;
                                    this.$call = uElement;
                                    super(1);
                                }
                            };
                            if (lambdaInvocation != null && this.isWithinVersionCheckConditional(evaluator, (UElement)lambdaInvocation, api, isLowerBound, (Function1<? super UElement, Integer>)newApiLookup2)) {
                                return true;
                            }
                        }
                    }
                } else if (current instanceof UMethod ? !(current.getUastParent() instanceof UAnonymousClass) : current instanceof PsiFile) {
                    return false;
                }
            }
            prev = current;
            current = Lint.skipParentheses((UElement)current.getUastParent());
        }
        return false;
    }

    private final Boolean isVersionCheckConditional(int api, boolean isLowerBound, UElement element, boolean and, UElement prev, Function1<? super UElement, Integer> apiLookup) {
        if (element instanceof UPolyadicExpression) {
            Boolean ok;
            if (element instanceof UBinaryExpression && (ok = this.isVersionCheckConditional(api, isLowerBound, and, (UBinaryExpression)element, apiLookup)) != null) {
                return ok;
            }
            UastBinaryOperator tokenType = ((UPolyadicExpression)element).getOperator();
            if (and && tokenType == UastBinaryOperator.LOGICAL_AND ? this.isAndedWithConditional(element, api, isLowerBound, prev) : !and && tokenType == UastBinaryOperator.LOGICAL_OR && this.isOredWithConditional(element, api, isLowerBound, prev)) {
                return true;
            }
        } else {
            UExpression operand;
            Boolean ok;
            if (element instanceof UCallExpression) {
                return this.isValidVersionCall(api, isLowerBound, and, (UCallExpression)element);
            }
            if (element instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiField) {
                    Boolean ok2;
                    UExpression initializer;
                    PsiElement field = resolved;
                    Boolean validFromAnnotation = VersionChecks.isValidFromAnnotation$default(this, api, (PsiModifierListOwner)field, null, 4, null);
                    if (validFromAnnotation != null) {
                        return validFromAnnotation;
                    }
                    PsiModifierList modifierList = ((PsiField)field).getModifierList();
                    if (modifierList != null && modifierList.hasExplicitModifier("static") && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)field)) != null && (ok2 = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)initializer, and, null, null, 48, null)) != null) {
                        return ok2;
                    }
                } else {
                    UExpression selector;
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                        UExpression uExpression = ((UQualifiedReferenceExpression)element).getSelector();
                        if (uExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                        }
                        UCallExpression call = (UCallExpression)uExpression;
                        return this.isValidVersionCall(api, isLowerBound, and, call);
                    }
                    if (resolved instanceof PsiMethod) {
                        return this.isValidVersionCall(api, isLowerBound, and, element, (PsiMethod)resolved);
                    }
                    if (resolved == null && element instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                        return this.isValidVersionCall(api, isLowerBound, and, (UCallExpression)selector);
                    }
                }
            } else if (element instanceof UUnaryExpression && ((UUnaryExpression)element).getOperator() == UastPrefixOperator.LOGICAL_NOT && (ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)(operand = ((UUnaryExpression)element).getOperand()), !and, null, null, 48, null)) != null) {
                return ok;
            }
        }
        return null;
    }

    static /* synthetic */ Boolean isVersionCheckConditional$default(VersionChecks versionChecks, int n, boolean bl, UElement uElement, boolean bl2, UElement uElement2, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            uElement2 = null;
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return versionChecks.isVersionCheckConditional(n, bl, uElement, bl2, uElement2, (Function1<? super UElement, Integer>)function1);
    }

    private final Boolean isValidFromAnnotation(int api, PsiModifierListOwner owner, UCallExpression call) {
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{CHECKS_SDK_INT_AT_LEAST_ANNOTATION});
        if (psiAnnotation == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"AnnotationUtil.findAnnot\u2026\n        ) ?: return null");
        PsiAnnotation annotation = psiAnnotation;
        int value = this.getApiLevel(annotation, owner, call);
        return value != -1 ? Boolean.valueOf(api <= value) : null;
    }

    static /* synthetic */ Boolean isValidFromAnnotation$default(VersionChecks versionChecks, int n, PsiModifierListOwner psiModifierListOwner, UCallExpression uCallExpression, int n2, Object object) {
        if ((n2 & 4) != 0) {
            uCallExpression = null;
        }
        return versionChecks.isValidFromAnnotation(n, psiModifierListOwner, uCallExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final int getApiLevel(PsiAnnotation annotation, PsiModifierListOwner owner, UCallExpression call) {
        int api = VersionChecksKt.getAnnotationIntValue$default(annotation, "api", 0, 2, null);
        if (api != -1) {
            return api;
        }
        String codename = VersionChecksKt.getAnnotationStringValue$default(annotation, "codename", null, 2, null);
        CharSequence charSequence = codename;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return SdkVersionInfo.getApiByPreviewName((String)codename, (boolean)true);
        }
        int parameterIndex = VersionChecksKt.getAnnotationIntValue$default(annotation, "parameter", 0, 2, null);
        if (owner instanceof PsiMethod && call != null) {
            PsiParameterList psiParameterList = ((PsiMethod)owner).getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"owner.parameterList");
            PsiParameter[] parameters = psiParameterList.getParameters();
            if (parameterIndex >= 0 && parameterIndex < parameters.length) {
                Map mapping;
                PsiParameter target2 = parameters[parameterIndex];
                Map map = mapping = this.evaluator.computeArgumentMapping(call, (PsiMethod)owner);
                boolean bl2 = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    boolean bl3 = false;
                    map = (UExpression)entry2.getKey();
                    entry2 = entry;
                    bl3 = false;
                    PsiParameter value1 = (PsiParameter)entry2.getValue();
                    if (value1 != target2 && !value1.isEquivalentTo((PsiElement)target2)) continue;
                    Object v = ConstantEvaluator.evaluate(null, (UElement)((UElement)key));
                    Object object = v;
                    if (!(object instanceof Number)) {
                        object = null;
                    }
                    Number number = (Number)object;
                    return number != null ? number.intValue() : -1;
                }
            }
        }
        return -1;
    }

    private final Boolean isValidVersionCall(int api, boolean isLowerBound, boolean and, UCallExpression call) {
        PsiMethod method = call.resolve();
        if (method == null) {
            String name;
            int version;
            UIdentifier identifier = call.getMethodIdentifier();
            if (identifier != null && (version = Companion.getMinSdkVersionFromMethodName(name = identifier.getName())) != -1 && isLowerBound) {
                return api <= version;
            }
            return null;
        }
        return this.isValidVersionCall(api, isLowerBound, and, (UElement)call, method);
    }

    private final Boolean isValidVersionCall(int api, boolean isLowerBound, boolean and, UElement call, PsiMethod method) {
        int version;
        PsiClass containingClass;
        Boolean validFromAnnotation;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)method;
        UElement uElement = call;
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        if ((validFromAnnotation = this.isValidFromAnnotation(api, psiModifierListOwner, (UCallExpression)uElement)) != null) {
            return validFromAnnotation;
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && isLowerBound && (containingClass = method.getContainingClass()) != null && Intrinsics.areEqual((Object)"BuildCompat", (Object)containingClass.getName())) {
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastN")) {
                return api <= 24;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastNMR1")) {
                return api <= 25;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastO")) {
                return api <= 26;
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastP", (boolean)false, (int)2, null)) {
                return api <= 28;
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastQ", (boolean)false, (int)2, null)) {
                return api <= 29;
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && name.length() == 10 && Character.isUpperCase(name.charAt(9)) && Intrinsics.compare((int)name.charAt(9), (int)81) > 0) {
                return api <= 31;
            }
        }
        if ((version = Companion.getMinSdkVersionFromMethodName(name)) != -1 && isLowerBound) {
            return api <= version;
        }
        if (!method.hasModifierProperty("abstract")) {
            UExpression uExpression = UastFacade.INSTANCE.getMethodBody(method);
            if (uExpression == null) {
                return null;
            }
            UExpression body = uExpression;
            List expressions = null;
            List list = expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : CollectionsKt.listOf((Object)body);
            if (expressions.size() == 1) {
                UExpression returnValue;
                UExpression statement = (UExpression)expressions.get(0);
                UExpression uExpression2 = returnValue = statement instanceof UReturnExpression ? ((UReturnExpression)statement).getReturnExpression() : statement;
                if (returnValue != null) {
                    Function1 lookup2;
                    Boolean ok;
                    List arguments;
                    List list2 = arguments = call instanceof UCallExpression ? ((UCallExpression)call).getValueArguments() : CollectionsKt.emptyList();
                    if (arguments.isEmpty()) {
                        Boolean isConditional;
                        if ((returnValue instanceof UPolyadicExpression || returnValue instanceof UCallExpression || returnValue instanceof UQualifiedReferenceExpression) && (isConditional = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)returnValue, and, null, null, 48, null)) != null) {
                            return isConditional;
                        }
                    } else if (arguments.size() == 1 && (ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)returnValue, and, null, lookup2 = (Function1)new Function1<UElement, Integer>(this, arguments){
                        final /* synthetic */ VersionChecks this$0;
                        final /* synthetic */ List $arguments;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke(@NotNull UElement reference) {
                            void var2_2;
                            int index;
                            PsiParameterList parameterList;
                            PsiElement resolved;
                            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                            int apiLevel = -1;
                            if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null && (index = parameterList.getParameterIndex((PsiParameter)resolved)) != -1 && index < this.$arguments.size()) {
                                apiLevel = VersionChecks.access$getApiLevel(this.this$0, (UExpression)this.$arguments.get(index), null);
                            }
                            return (int)var2_2;
                        }
                        {
                            this.this$0 = versionChecks;
                            this.$arguments = list;
                            super(1);
                        }
                    }, 16, null)) != null) {
                        return ok;
                    }
                }
            }
        }
        return null;
    }

    private final boolean isSdkInt(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiExpression initializer;
            if (Intrinsics.areEqual((Object)SDK_INT, (Object)((PsiReferenceExpression)element).getReferenceName())) {
                return true;
            }
            PsiElement resolved = ((PsiReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return this.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression psiReferenceExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"element.methodExpression");
            if (Intrinsics.areEqual((Object)GET_BUILD_SDK_INT, (Object)psiReferenceExpression.getReferenceName())) {
                return true;
            }
        }
        return false;
    }

    private final boolean isSdkInt(UElement element) {
        if (element instanceof UReferenceExpression) {
            PsiExpression initializer;
            if (Intrinsics.areEqual((Object)SDK_INT, (Object)((UReferenceExpression)element).getResolvedName())) {
                return true;
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression initializer2 = ((ULocalVariable)resolved).getUastInitializer();
                if (initializer2 != null) {
                    return this.isSdkInt((UElement)initializer2);
                }
            } else if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return this.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof UCallExpression && Intrinsics.areEqual((Object)GET_BUILD_SDK_INT, (Object)Lint.getMethodName((UCallExpression)((UCallExpression)element)))) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Boolean isVersionCheckConditional(int api, boolean isLowerBound, boolean fromThen, UBinaryExpression binary, Function1<? super UElement, Integer> apiLevelLookup) {
        boolean fromThen2 = fromThen;
        UastBinaryOperator tokenType = binary.getOperator();
        if (tokenType != UastBinaryOperator.GREATER && tokenType != UastBinaryOperator.GREATER_OR_EQUALS && tokenType != UastBinaryOperator.LESS_OR_EQUALS && tokenType != UastBinaryOperator.LESS && tokenType != UastBinaryOperator.EQUALS && tokenType != UastBinaryOperator.IDENTITY_EQUALS && tokenType != UastBinaryOperator.NOT_EQUALS && tokenType != UastBinaryOperator.IDENTITY_NOT_EQUALS) return null;
        UExpression left = binary.getLeftOperand();
        int level = 0;
        UExpression right = null;
        if (!this.isSdkInt((UElement)left)) {
            right = binary.getRightOperand();
            if (!this.isSdkInt((UElement)right)) return null;
            fromThen2 = !fromThen2;
            level = this.getApiLevel(left, apiLevelLookup);
        } else {
            right = binary.getRightOperand();
            level = this.getApiLevel(right, apiLevelLookup);
        }
        if (level == -1) return null;
        if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
            return isLowerBound ? Boolean.valueOf(level >= api && fromThen2) : Boolean.valueOf(level - 1 <= api && !fromThen2);
        }
        if (tokenType == UastBinaryOperator.GREATER) {
            return isLowerBound ? Boolean.valueOf(level >= api - 1 && fromThen2) : Boolean.valueOf(level <= api && !fromThen2);
        }
        if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
            return isLowerBound ? Boolean.valueOf(level >= api - 1 && !fromThen2) : Boolean.valueOf(level <= api && fromThen2);
        }
        if (tokenType == UastBinaryOperator.LESS) {
            return isLowerBound ? Boolean.valueOf(level >= api && !fromThen2) : Boolean.valueOf(level - 1 <= api && fromThen2);
        }
        if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
            return isLowerBound ? Boolean.valueOf(level >= api && fromThen2) : Boolean.valueOf(level <= api && fromThen2);
        }
        if (tokenType == UastBinaryOperator.NOT_EQUALS || tokenType == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return level == api && !fromThen2;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (!_Assertions.ENABLED) return null;
        boolean bl3 = false;
        UastBinaryOperator uastBinaryOperator = tokenType;
        throw (Throwable)((Object)new AssertionError(uastBinaryOperator));
    }

    static /* synthetic */ Boolean isVersionCheckConditional$default(VersionChecks versionChecks, int n, boolean bl, boolean bl2, UBinaryExpression uBinaryExpression, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        return versionChecks.isVersionCheckConditional(n, bl, bl2, uBinaryExpression, (Function1<? super UElement, Integer>)function1);
    }

    private final int getApiLevel(UExpression element, Function1<? super UElement, Integer> apiLevelLookup) {
        Object value;
        int level = -1;
        if (element instanceof UReferenceExpression) {
            Object constant;
            String codeName = ((UReferenceExpression)element).getResolvedName();
            if (codeName != null) {
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            }
            if (level == -1 && (constant = ConstantEvaluator.evaluate(null, (UElement)((UElement)element))) instanceof Number) {
                level = ((Number)constant).intValue();
            }
        } else if (element instanceof ULiteralExpression && (value = ((ULiteralExpression)element).getValue()) instanceof Integer) {
            level = ((Number)value).intValue();
        }
        if (level == -1 && apiLevelLookup != null && element != null) {
            level = ((Number)apiLevelLookup.invoke((Object)element)).intValue();
        }
        return level;
    }

    private final boolean isOredWithConditional(UElement element, int api, boolean isLowerBound, UElement before) {
        if (element instanceof UBinaryExpression) {
            Boolean value;
            UExpression left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)left, false, null, null, 48, null);
                if (ok != null) {
                    return ok;
                }
                UExpression right = ((UBinaryExpression)element).getRightOperand();
                ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)right, false, null, null, 48, null);
                if (ok != null) {
                    return ok;
                }
            }
            return (value = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, false, (UBinaryExpression)element, null, 16, null)) != null && value != false;
        }
        if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR) {
            UExpression operand;
            Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
            while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                if (!this.isOredWithConditional((UElement)operand, api, isLowerBound, before)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isAndedWithConditional(UElement element, int api, boolean isLowerBound, UElement before) {
        if (element instanceof UBinaryExpression) {
            Boolean value;
            UExpression left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)left, true, null, null, 48, null);
                if (ok != null) {
                    return ok;
                }
                UExpression right = ((UBinaryExpression)element).getRightOperand();
                ok = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, (UElement)right, true, null, null, 48, null);
                if (ok != null) {
                    return ok;
                }
            }
            return (value = VersionChecks.isVersionCheckConditional$default(this, api, isLowerBound, true, (UBinaryExpression)element, null, 16, null)) != null && value != false;
        }
        if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND) {
            UExpression operand;
            Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
            while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                if (!this.isAndedWithConditional((UElement)operand, api, isLowerBound, before)) continue;
                return true;
            }
        }
        return false;
    }

    public VersionChecks(@NotNull JavaEvaluator evaluator) {
        Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
        this.evaluator = evaluator;
    }

    static {
        Companion = new Companion(null);
        VERSION_METHOD_NAME_PREFIXES = new String[]{"isAtLeast", "isRunning", "is", "runningOn", "running", "has"};
        VERSION_METHOD_NAME_SUFFIXES = new String[]{"OrLater", "OrAbove", "OrHigher", "OrNewer", "Sdk"};
    }

    public static final /* synthetic */ int access$getApiLevel(VersionChecks $this, UExpression element, Function1 apiLevelLookup) {
        return $this.getApiLevel(element, (Function1<? super UElement, Integer>)apiLevelLookup);
    }

    @JvmStatic
    public static final int codeNameToApi(@NotNull String text) {
        return Companion.codeNameToApi(text);
    }

    @JvmStatic
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean isLowerBound) {
        return Companion.isWithinVersionCheckConditional(evaluator, element, api, isLowerBound);
    }

    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean isLowerBound) {
        return Companion.isPrecededByVersionCheckExit(evaluator, element, api, isLowerBound);
    }

    @JvmStatic
    @Nullable
    public static final Boolean isVersionCheckConditional(int api, @NotNull UBinaryExpression binary) {
        return Companion.isVersionCheckConditional(api, binary);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/VersionChecks$VersionCheckWithExitFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "endElement", "Lorg/jetbrains/uast/UElement;", "api", "", "isLowerBound", "", "(Lcom/android/tools/lint/checks/VersionChecks;Lorg/jetbrains/uast/UElement;IZ)V", "done", "found", "visitElement", "node", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "android.sdktools.lint-checks"})
    private final class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        private boolean found;
        private boolean done;
        private final UElement endElement;
        private final int api;
        private final boolean isLowerBound;

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.done) {
                return true;
            }
            if (node == this.endElement) {
                this.done = true;
            }
            return this.done;
        }

        public boolean visitIfExpression(@NotNull UIfExpression node) {
            Boolean level;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitIfExpression(node);
            if (this.done) {
                return true;
            }
            if (UastUtils.isUastChildOf((UElement)this.endElement, (UElement)((UElement)node), (boolean)true)) {
                this.done = true;
                return true;
            }
            UExpression thenBranch = node.getThenExpression();
            UExpression elseBranch = node.getElseExpression();
            if (thenBranch != null && (level = VersionChecks.isVersionCheckConditional$default(VersionChecks.this, this.api, this.isLowerBound, (UElement)node.getCondition(), false, null, null, 48, null)) != null && level.booleanValue() && VersionChecks.this.isUnconditionalReturn(thenBranch)) {
                this.found = true;
                this.done = true;
            }
            if (elseBranch != null && (level = VersionChecks.isVersionCheckConditional$default(VersionChecks.this, this.api, this.isLowerBound, (UElement)node.getCondition(), true, null, null, 48, null)) != null && level.booleanValue() && VersionChecks.this.isUnconditionalReturn(elseBranch)) {
                this.found = true;
                this.done = true;
            }
            return true;
        }

        public final boolean found() {
            return this.found;
        }

        public VersionCheckWithExitFinder(UElement endElement, int api, boolean isLowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
            this.endElement = endElement;
            this.api = api;
            this.isLowerBound = isLowerBound;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/VersionChecks$Companion;", "", "()V", "CHECKS_SDK_INT_AT_LEAST_ANNOTATION", "", "GET_BUILD_SDK_INT", "SDK_INT", "VERSION_METHOD_NAME_PREFIXES", "", "[Ljava/lang/String;", "VERSION_METHOD_NAME_SUFFIXES", "codeNameToApi", "", "text", "getMinSdkVersionFromMethodName", "name", "isPrecededByVersionCheckExit", "", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "element", "Lorg/jetbrains/uast/UElement;", "api", "isLowerBound", "isVersionCheckConditional", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "(ILorg/jetbrains/uast/UBinaryExpression;)Ljava/lang/Boolean;", "isWithinVersionCheckConditional", "android.sdktools.lint-checks"})
    public static final class Companion {
        @JvmStatic
        public final int codeNameToApi(@NotNull String text) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex != -1) {
                String string2 = text;
                int n = dotIndex + 1;
                boolean bl = false;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = text;
            }
            String buildCode = string;
            return SdkVersionInfo.getApiByBuildCode((String)buildCode, (boolean)true);
        }

        @JvmStatic
        public final boolean isWithinVersionCheckConditional(@NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean isLowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return new VersionChecks(evaluator).isWithinVersionCheckConditional(evaluator, element, api, isLowerBound, (Function1<? super UElement, Integer>)null);
        }

        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean isLowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            VersionChecks check = new VersionChecks(evaluator);
            UElement prev = element;
            UExpression current = (UExpression)UastUtils.getParentOfType((UElement)prev, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
            while (current != null) {
                VersionCheckWithExitFinder visitor2 = check.new VersionCheckWithExitFinder(prev, api, isLowerBound);
                current.accept((UastVisitor)visitor2);
                if (visitor2.found()) {
                    return true;
                }
                prev = (UElement)current;
                current = (UExpression)UastUtils.getParentOfType((UElement)((UElement)current), UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
            }
            return false;
        }

        @JvmStatic
        @Nullable
        public final Boolean isVersionCheckConditional(int api, @NotNull UBinaryExpression binary) {
            UExpression left;
            Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
            UastBinaryOperator tokenType = binary.getOperator();
            if ((tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) && (left = binary.getLeftOperand()) instanceof UReferenceExpression && Intrinsics.areEqual((Object)VersionChecks.SDK_INT, (Object)((UReferenceExpression)left).getResolvedName())) {
                Object value;
                UExpression right = binary.getRightOperand();
                int level = -1;
                if (right instanceof UReferenceExpression) {
                    String string = ((UReferenceExpression)right).getResolvedName();
                    if (string == null) {
                        return false;
                    }
                    String codeName = string;
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof ULiteralExpression && (value = ((ULiteralExpression)right).getValue()) instanceof Integer) {
                    level = ((Number)value).intValue();
                }
                if (level != -1) {
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS && level < api) {
                        return true;
                    }
                    if (tokenType == UastBinaryOperator.GREATER && level <= api - 1) {
                        return true;
                    }
                    if (tokenType == UastBinaryOperator.LESS_OR_EQUALS && level < api) {
                        return false;
                    }
                    if (tokenType == UastBinaryOperator.LESS && level <= api) {
                        return false;
                    }
                    if ((tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) && level < api) {
                        return false;
                    }
                }
            }
            return null;
        }

        @VisibleForTesting
        public final int getMinSdkVersionFromMethodName(@NotNull String name) {
            String string;
            String string2;
            int element$iv2;
            String prefix;
            int n;
            block15: {
                String string3;
                block14: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    String[] $this$firstOrNull$iv = VERSION_METHOD_NAME_PREFIXES;
                    boolean $i$f$firstOrNull = false;
                    String[] stringArray = $this$firstOrNull$iv;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String element$iv2;
                        String it = element$iv2 = stringArray[n];
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                        string3 = element$iv2;
                        break block14;
                    }
                    string3 = null;
                }
                if (string3 == null) {
                    return -1;
                }
                prefix = string3;
                String[] $this$firstOrNull$iv = VERSION_METHOD_NAME_SUFFIXES;
                boolean $i$f$firstOrNull = false;
                String[] stringArray = $this$firstOrNull$iv;
                n = stringArray.length;
                for (element$iv2 = 0; element$iv2 < n; ++element$iv2) {
                    String element$iv3;
                    String it = element$iv3 = stringArray[element$iv2];
                    boolean bl = false;
                    if (!SdkUtils.endsWithIgnoreCase((String)name, (String)it)) continue;
                    string2 = element$iv3;
                    break block15;
                }
                string2 = string = null;
            }
            if (string2 == null) {
                if (Intrinsics.areEqual((Object)prefix, (Object)"is") ^ true) {
                    string = "";
                } else {
                    return -1;
                }
            }
            String suffix = string;
            String $i$f$firstOrNull = name;
            int n3 = prefix.length();
            n = name.length() - suffix.length();
            element$iv2 = 0;
            String string4 = $i$f$firstOrNull.substring(n3, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String codeName = string4;
            int version = SdkVersionInfo.getApiByPreviewName((String)codeName, (boolean)false);
            if (version == -1) {
                version = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
                if (version == -1 && codeName.length() == 1 && Character.isUpperCase(codeName.charAt(0))) {
                    version = 31;
                } else if (SdkUtils.startsWithIgnoreCase((String)codeName, (String)"api")) {
                    int end;
                    int begin = 3;
                    int length = codeName.length();
                    if (begin < length && codeName.charAt(begin) == '_') {
                        ++begin;
                    }
                    for (end = begin; end < length && Character.isDigit(codeName.charAt(end)); ++end) {
                    }
                    if (begin < end) {
                        String string5 = codeName;
                        boolean bl = false;
                        String string6 = string5;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(begin, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        Integer n4 = Integer.decode(string7);
                        Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"Integer.decode(codeName.substring(begin, end))");
                        version = n4;
                    }
                }
            }
            return version;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

