/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ToastDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkShown", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "toastName", "", "getApplicableMethodNames", "", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class ToastDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"makeText", "make"});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return");
        PsiClass containingClass = psiClass;
        String className = containingClass.getQualifiedName();
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)className, (Object)"android.widget.Toast") && Intrinsics.areEqual((Object)name, (Object)"makeText")) {
            UExpression duration;
            List args = node.getValueArguments();
            if (args.size() == 3 && (duration = (UExpression)args.get(2)) instanceof ULiteralExpression) {
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)duration), (Location)context.getLocation((UElement)duration), (String)"Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported", null, (int)16, null);
            }
            this.checkShown(context, node, "Toast");
        } else if (Intrinsics.areEqual((Object)name, (Object)"make") && (Intrinsics.areEqual((Object)className, (Object)"com.google.android.material.snackbar.Snackbar") || Intrinsics.areEqual((Object)className, (Object)"android.support.design.widget.Snackbar"))) {
            this.checkShown(context, node, "Snackbar");
        }
    }

    private final void checkShown(JavaContext context, UCallExpression node, String toastName) {
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        AtomicBoolean shown = new AtomicBoolean(false);
        AtomicBoolean escapes = new AtomicBoolean(false);
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(shown, escapes, node, SetsKt.setOf((Object)node), CollectionsKt.emptyList()){
            final /* synthetic */ AtomicBoolean $shown;
            final /* synthetic */ AtomicBoolean $escapes;
            final /* synthetic */ UCallExpression $node;

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (this.isShowCall(call)) {
                    this.$shown.set(true);
                }
                super.receiver(call);
            }

            private final boolean isShowCall(UCallExpression call) {
                String methodName = Lint.getMethodName((UCallExpression)call);
                return Intrinsics.areEqual((Object)methodName, (Object)"show");
            }

            public void field(@NotNull UElement field) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                this.$escapes.set(true);
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                this.$escapes.set(true);
            }

            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.$escapes.set(true);
            }
            {
                this.$shown = $captured_local_variable$0;
                this.$escapes = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
        method.accept((UastVisitor)visitor2);
        if (!shown.get() && !escapes.get()) {
            LintFix fix = CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) ? this.fix().replace().name("Call show()").range(context.getLocation((UElement)node)).end().with(".show()").build() : null;
            context.report(ISSUE, (UElement)node, context.getCallLocation(node, true, false), toastName + " created but not shown: did you forget to call `show()` ?", fix);
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ShowToast", (String)"Toast created but not shown", (String)"\n                    `Toast.makeText()` creates a `Toast` but does **not** show it. You must \\\n                    call `show()` on the resulting object to actually make the `Toast` \\\n                    appear.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ToastDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

