/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\b\b\u0000\u0010 *\u00020\f2\u0006\u0010!\u001a\u00020\f2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u0002H 0#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0006H\u0002J\u001a\u0010*\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J|\u0010+\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00062\b\u0010/\u001a\u0004\u0018\u00010\u00142\b\u00100\u001a\u0004\u0018\u0001012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0016\u00a8\u00066"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkColor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "Lorg/jetbrains/uast/UElement;", "checkHalfFloat", "checkPx", "checkResourceType", "expectedTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceType;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "getFirstResourceAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "getLastInQualifiedChain", "Lorg/jetbrains/uast/UExpression;", "node", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "getMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "getParentSequence", "Lkotlin/sequences/Sequence;", "T", "element", "clz", "Ljava/lang/Class;", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isResourceAnnotation", "signature", "typeArrayFromArrayLiteral", "visitAnnotationUsage", "usage", "annotation", "qualifiedName", "method", "referenced", "Lcom/intellij/psi/PsiElement;", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "android.sdktools.lint-checks"})
public final class ResourceTypeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue RESOURCE_TYPE;
    @JvmField
    @NotNull
    public static final Issue COLOR_USAGE;
    @JvmField
    @NotNull
    public static final Issue HALF_FLOAT;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{ResourceEvaluator.COLOR_INT_ANNOTATION.oldName(), ResourceEvaluator.COLOR_INT_ANNOTATION.newName(), ResourceEvaluator.DIMENSION_ANNOTATION.oldName(), ResourceEvaluator.DIMENSION_ANNOTATION.newName(), ResourceEvaluator.PX_ANNOTATION.oldName(), ResourceEvaluator.PX_ANNOTATION.newName(), AnnotationDetector.HALF_FLOAT_ANNOTATION.oldName(), AnnotationDetector.HALF_FLOAT_ANNOTATION.newName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.newName(), ResourceEvaluator.ANIM_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIM_RES_ANNOTATION.newName(), ResourceEvaluator.ANY_RES_ANNOTATION.oldName(), ResourceEvaluator.ANY_RES_ANNOTATION.newName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.oldName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.newName(), ResourceEvaluator.ATTR_RES_ANNOTATION.oldName(), ResourceEvaluator.ATTR_RES_ANNOTATION.newName(), ResourceEvaluator.BOOL_RES_ANNOTATION.oldName(), ResourceEvaluator.BOOL_RES_ANNOTATION.newName(), ResourceEvaluator.COLOR_RES_ANNOTATION.oldName(), ResourceEvaluator.COLOR_RES_ANNOTATION.newName(), ResourceEvaluator.FONT_RES_ANNOTATION.oldName(), ResourceEvaluator.FONT_RES_ANNOTATION.newName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.oldName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.newName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.newName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.oldName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.newName(), ResourceEvaluator.ID_RES_ANNOTATION.oldName(), ResourceEvaluator.ID_RES_ANNOTATION.newName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.oldName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.newName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.newName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.oldName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.newName(), ResourceEvaluator.MENU_RES_ANNOTATION.oldName(), ResourceEvaluator.MENU_RES_ANNOTATION.newName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.oldName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.newName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.oldName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.newName(), ResourceEvaluator.RAW_RES_ANNOTATION.oldName(), ResourceEvaluator.RAW_RES_ANNOTATION.newName(), ResourceEvaluator.STRING_RES_ANNOTATION.oldName(), ResourceEvaluator.STRING_RES_ANNOTATION.newName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.newName(), ResourceEvaluator.STYLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLE_RES_ANNOTATION.newName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.oldName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.newName(), ResourceEvaluator.XML_RES_ANNOTATION.oldName(), ResourceEvaluator.XML_RES_ANNOTATION.newName()});
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return true;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        String string = qualifiedName;
        if (Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.newName())) {
            this.checkColor(context, usage);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.HALF_FLOAT_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.HALF_FLOAT_ANNOTATION.newName())) {
            this.checkHalfFloat(context, usage);
        } else if (Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.PX_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)ResourceEvaluator.PX_ANNOTATION.newName())) {
            this.checkPx(context, usage);
        } else if (this.isResourceAnnotation(qualifiedName)) {
            UastBinaryOperator operator;
            if (annotations.size() > 1 && this.getFirstResourceAnnotation(annotations) != annotation) {
                return;
            }
            UExpression expression = (UExpression)UastUtils.getParentOfType((UElement)usage, UExpression.class, (boolean)true);
            if (expression instanceof UBinaryExpression && (operator = ((UBinaryExpression)expression).getOperator()) instanceof UastBinaryOperator.ComparisonOperator && operator != UastBinaryOperator.EQUALS && operator != UastBinaryOperator.NOT_EQUALS && operator != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                UElement uElement = (UElement)expression;
                Location location = context.getLocation((UElement)expression);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "Comparing resource types (`@%1$s`) other than equality is dangerous and usually wrong;  some resource types set top bit which turns the value negative";
                Object[] objectArray = new Object[]{SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.removeFrom(qualifiedName)};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                JavaContext.report$default((JavaContext)context, (Issue)RESOURCE_TYPE, (UElement)uElement, (Location)location, (String)string3, null, (int)16, null);
                return;
            }
            EnumSet types = ResourceEvaluator.getTypesFromAnnotations(annotations);
            if (types != null) {
                if (types.contains(ResourceType.STYLEABLE) && type == AnnotationUsageType.ASSIGNMENT) {
                    return;
                }
                this.checkResourceType(context, usage, types, method);
            }
        }
    }

    private final UAnnotation getFirstResourceAnnotation(List<? extends UAnnotation> annotations) {
        for (UAnnotation uAnnotation : annotations) {
            String qualifiedName = uAnnotation.getQualifiedName();
            if (qualifiedName == null || !this.isResourceAnnotation(qualifiedName)) continue;
            return uAnnotation;
        }
        return null;
    }

    private final boolean isResourceAnnotation(String signature) {
        return ResourceEvaluator.getTypeFromAnnotationSignature((String)signature) != null || ResourceEvaluator.ANY_RES_ANNOTATION.isEquals(signature);
    }

    private final void checkColor(JavaContext context, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkColor(context, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkColor(context, (UElement)uExpression);
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && types.contains(ResourceType.COLOR)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`";
            Object[] objectArray = new Object[]{argument.asSourceString()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            this.report(context, COLOR_USAGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkHalfFloat(JavaContext context, UElement argument) {
        UExpression curr;
        if (argument instanceof UIfExpression) {
            UExpression elseExpression;
            UExpression thenExpression = ((UIfExpression)argument).getThenExpression();
            if (thenExpression != null) {
                this.checkColor(context, (UElement)thenExpression);
            }
            if ((elseExpression = ((UIfExpression)argument).getElseExpression()) != null) {
                this.checkColor(context, (UElement)elseExpression);
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && !types.isEmpty()) {
            String type = types.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "dimension" : (types.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "color" : "resource id");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Expected a half float here, not a %1$s";
            Object[] objectArray = new Object[]{type};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            this.report(context, HALF_FLOAT, argument, context.getLocation(argument), message2);
            return;
        }
        Iterator iterator = this.getParentSequence(argument, UExpression.class).iterator();
        while (iterator.hasNext() && !((curr = (UExpression)iterator.next()) instanceof UBinaryExpressionWithType)) {
            PsiType expressionType = curr.getExpressionType();
            if (expressionType == null || !(Intrinsics.areEqual((Object)PsiType.SHORT, (Object)expressionType) ^ true)) continue;
            if (Intrinsics.areEqual((Object)PsiType.VOID, (Object)expressionType) || Intrinsics.areEqual((Object)PsiType.BOOLEAN, (Object)expressionType) || Intrinsics.areEqual((Object)PsiType.BYTE, (Object)expressionType) || Intrinsics.areEqual((Object)expressionType.getCanonicalText(), (Object)"android.util.Half")) break;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Half-float type in expression widened to %1$s";
            Object[] objectArray = new Object[]{expressionType.getCanonicalText()};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            String message3 = string3;
            this.report(context, HALF_FLOAT, argument, context.getLocation(argument), message3);
            break;
        }
    }

    private final <T extends UElement> Sequence<T> getParentSequence(UElement element, Class<? extends T> clz) {
        UElement seed = UastUtils.getParentOfType((UElement)element, clz, (boolean)false);
        Function1 nextFunction2 = new Function1<T, T>(clz){
            final /* synthetic */ Class $clz;

            @Nullable
            public final T invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return (T)UastUtils.getParentOfType(it, (Class)this.$clz, (boolean)true);
            }
            {
                this.$clz = clazz;
                super(1);
            }
        };
        return SequencesKt.generateSequence((Object)seed, (Function1)nextFunction2);
    }

    private final void checkPx(JavaContext context, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkPx(context, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                if (uExpression == null) {
                    Intrinsics.throwNpe();
                }
                this.checkPx(context, (UElement)uExpression);
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && types.contains(ResourceType.DIMEN)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(%1$s)`";
            Object[] objectArray = new Object[]{argument.asSourceString()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            this.report(context, COLOR_USAGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkResourceType(JavaContext context, UElement argument, EnumSet<ResourceType> expectedTypes, PsiMethod calledMethod) {
        UExpression call;
        EnumSet actual = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (actual == null && (!UastLintUtils.Companion.isNumber(argument) || UastLintUtils.Companion.isZero(argument) || UastLintUtils.Companion.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection((Set)actual, (Set)expectedTypes).isEmpty() || expectedTypes.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (expectedTypes.contains(ResourceType.STYLEABLE) && expectedTypes.size() == 1 && calledMethod != null && context.getEvaluator().isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && (call = (UExpression)UastUtils.getParentOfType((UElement)argument, UCallExpression.class, (boolean)false)) instanceof UCallExpression && this.typeArrayFromArrayLiteral((UElement)((UCallExpression)call).getReceiver(), context)) {
            return;
        }
        String message2 = actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedTypes.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "Should pass resolved color instead of resource id here: " + "`getResources().getColor(" + argument.asSourceString() + ")`" : (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "Expected a dimension resource id (`R.dimen.`) but received a pixel integer" : (expectedTypes.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "Should pass resolved pixel size instead of resource id here: " + "`getResources().getDimension*(" + argument.asSourceString() + ")`" : (Intrinsics.areEqual(expectedTypes, (Object)ResourceEvaluator.getAnyRes()) ? "Expected resource identifier (`R`.type.`name`)" : "Expected resource of type " + CollectionsKt.joinToString$default((Iterable)expectedTypes, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null)))));
        this.report(context, RESOURCE_TYPE, argument, context.getLocation(argument), message2);
    }

    private final boolean typeArrayFromArrayLiteral(UElement node, JavaContext context) {
        if (node == null) {
            return false;
        }
        UCallExpression expression = this.getMethodCall(node);
        if (expression != null) {
            List expressions;
            String name = expression.getMethodName();
            if (name != null && Intrinsics.areEqual((Object)"obtainStyledAttributes", (Object)name) && !(expressions = expression.getValueArguments()).isEmpty()) {
                int arg = 0;
                if (expressions.size() == 1) {
                    arg = 0;
                } else if (expressions.size() == 2) {
                    PsiType type;
                    for (arg = 0; arg < expressions.size() && !((type = ((UExpression)expressions.get(arg)).getExpressionType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions.size()) {
                        return false;
                    }
                } else if (expressions.size() == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((UElement)((UElement)expressions.get(arg)));
            }
            return false;
        }
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.Companion.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return this.typeArrayFromArrayLiteral((UElement)lastAssignment, context);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression operand = parenthesizedExpression.getExpression();
                return this.typeArrayFromArrayLiteral((UElement)operand, context);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                UExpression operand = castExpression.getOperand();
                return this.typeArrayFromArrayLiteral((UElement)operand, context);
            }
        }
        return false;
    }

    private final UCallExpression getMethodCall(UElement node) {
        UExpression last;
        if (node instanceof UQualifiedReferenceExpression && UastExpressionUtils.isMethodCall((UElement)((UElement)(last = this.getLastInQualifiedChain((UQualifiedReferenceExpression)node))))) {
            UExpression uExpression = last;
            if (uExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            return (UCallExpression)uExpression;
        }
        return node != null && UastExpressionUtils.isMethodCall((UElement)node) ? (UCallExpression)node : null;
    }

    private final UExpression getLastInQualifiedChain(UQualifiedReferenceExpression node) {
        UExpression last = node.getSelector();
        while (last instanceof UQualifiedReferenceExpression) {
            last = ((UQualifiedReferenceExpression)last).getSelector();
        }
        return last;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ResourceTypeDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 7;
        String string = null;
        Category category = Category.CORRECTNESS;
        RESOURCE_TYPE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ResourceType", (String)"Wrong Resource Type", (String)"\n                Ensures that resource id's passed to APIs are of the right type; for \\\n                example, calling `Resources.getColor(R.string.name)` is wrong.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 7;
        string = null;
        category = Category.CORRECTNESS;
        COLOR_USAGE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ResourceAsColor", (String)"Should pass resolved color instead of resource id", (String)"\n                Methods that take a color in the form of an integer should be passed an \\\n                RGB triple, not the actual color resource id. You must call \\\n                `getResources().getColor(resource)` to resolve the actual color value first.\n\n                Similarly, methods that take a dimension integer should be passed an \\\n                actual dimension (call `getResources().getDimension(resource)`", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 7;
        string = null;
        category = Category.CORRECTNESS;
        HALF_FLOAT = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"HalfFloat", (String)"Incorrect Half Float", (String)"\n                Half-precision floating point are stored in a short data type, and should be \\\n                manipulated using the `android.util.Half` class. This check flags usages \\\n                where it appears that these values are used incorrectly.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector$Companion;", "", "()V", "COLOR_USAGE", "Lcom/android/tools/lint/detector/api/Issue;", "HALF_FLOAT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESOURCE_TYPE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

