/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.RemoteViewDetector;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "isSupportedTag", "", "tag", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Issues", "android.sdktools.lint-checks"})
public final class RemoteViewDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"android.widget.RemoteViews");
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        block13: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
            List arguments = node.getValueArguments();
            if (arguments.size() != 2) {
                return;
            }
            UExpression argument = (UExpression)arguments.get(1);
            ResourceReference resourceReference = ResourceReference.Companion.get((UElement)argument);
            if (resourceReference == null) {
                return;
            }
            ResourceReference resource = resourceReference;
            if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android") || resource.getType() != ResourceType.LAYOUT) {
                return;
            }
            ResourceRepository resourceRepository = context.getClient().getResourceRepository(context.getMainProject(), true, false);
            if (resourceRepository == null) {
                return;
            }
            ResourceRepository resources = resourceRepository;
            List items = resources.getResources(ResourceNamespace.TODO(), resource.getType(), resource.getName());
            Set tags = null;
            List list = items;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"items");
            Set paths2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)visitConstructor.paths.1.INSTANCE));
            for (PathString path : paths2) {
                try {
                    if (context.getClient().createXmlPullParser(path) == null) {
                        continue;
                    }
                    while (true) {
                        XmlPullParser parser;
                        int event;
                        if ((event = parser.next()) == 2) {
                            String tag;
                            if (parser.getName() == null) {
                                continue;
                            }
                            if (this.isSupportedTag(tag)) continue;
                            Set set = tags;
                            if (set == null) {
                                HashSet hashSet = new HashSet();
                                boolean bl = false;
                                boolean bl2 = false;
                                HashSet it = hashSet;
                                boolean bl3 = false;
                                tags = it;
                                set = hashSet;
                            }
                            set.add(tag);
                            continue;
                        }
                        if (event == 1) break;
                    }
                }
                catch (XmlPullParserException xmlPullParserException) {
                }
                catch (IOException iOException) {}
            }
            Set set = tags;
            if (set == null) break block13;
            Set set2 = set;
            boolean bl = false;
            boolean bl4 = false;
            Set set3 = set2;
            boolean bl5 = false;
            SortedSet sorted = CollectionsKt.toSortedSet((Iterable)set3);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("`@layout/" + resource.getName() + "` includes views not allowed in a `RemoteView`: " + CollectionsKt.joinToString$default((Iterable)sorted, null, null, null, (int)0, null, null, (int)63, null)), null, (int)16, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedTag(String tag) {
        String string = tag;
        switch (string.hashCode()) {
            case 1942574248: {
                if (!string.equals("include")) return false;
                return true;
            }
            case 1280029577: {
                if (!string.equals("requestFocus")) return false;
                return true;
            }
            case 940309185: {
                if (!string.equals("TextClock")) return false;
                return true;
            }
            case 1204826236: {
                if (!string.equals("AdapterViewFlipper")) return false;
                return true;
            }
            case -170947679: {
                if (!string.equals("AbsoluteLayout")) return false;
                return true;
            }
            case 886763275: {
                if (!string.equals("ViewFlipper")) return false;
                return true;
            }
            case -1822277072: {
                if (!string.equals("GridLayout")) return false;
                return true;
            }
            case -937446323: {
                if (!string.equals("ImageButton")) return false;
                return true;
            }
            case 1260470547: {
                if (!string.equals("ViewStub")) return false;
                return true;
            }
            case 1410352259: {
                if (!string.equals("ListView")) return false;
                return true;
            }
            case 2001146706: {
                if (!string.equals("Button")) return false;
                return true;
            }
            case -984371546: {
                if (!string.equals("Chronometer")) return false;
                return true;
            }
            case 1310765783: {
                if (!string.equals("FrameLayout")) return false;
                return true;
            }
            case 103785528: {
                if (!string.equals("merge")) return false;
                return true;
            }
            case -443652810: {
                if (!string.equals("RelativeLayout")) return false;
                return true;
            }
            case 1778827486: {
                if (!string.equals("AnalogClock")) return false;
                return true;
            }
            case -938935918: {
                if (!string.equals("TextView")) return false;
                return true;
            }
            case 382765867: {
                if (!string.equals("GridView")) return false;
                return true;
            }
            case 1125864064: {
                if (!string.equals("ImageView")) return false;
                return true;
            }
            case -563016403: {
                if (!string.equals("StackView")) return false;
                return true;
            }
            case -1495589242: {
                if (!string.equals("ProgressBar")) return false;
                return true;
            }
            case 1127291599: {
                if (!string.equals("LinearLayout")) return false;
                return true;
            }
        }
        return false;
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(RemoteViewDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "https://developer.android.com/reference/android/widget/RemoteViews";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"RemoteViewLayout", (String)"Unsupported View in RemoteView", (String)"\n            In a `RemoteView`, only some layouts and views are allowed.\n            ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

