/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "layoutsWithRootLayoutParams", "", "", "pendingErrors", "", "Lcom/android/utils/Pair;", "Lcom/android/tools/lint/detector/api/Location;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "", "hasLayoutParams", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "name", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class LayoutInflationDetector
extends LayoutDetector
implements SourceCodeScanner {
    private Set<String> layoutsWithRootLayoutParams;
    private List<Pair<String, Location>> pendingErrors;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String ERROR_MESSAGE = "Avoid passing `null` as the view root (needed to resolve layout parameters on the inflated layout's root element)";
    public static final Companion Companion;

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        List<Pair<String, Location>> list = this.pendingErrors;
        if (list == null) {
            return;
        }
        List<Pair<String, Location>> pendingErrors = list;
        for (Pair<String, Location> pair : pendingErrors) {
            Location location;
            String inflatedLayout = (String)pair.getFirst();
            if (this.layoutsWithRootLayoutParams == null) continue;
            Set<String> set = this.layoutsWithRootLayoutParams;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            if (!CollectionsKt.contains((Iterable)set, (Object)inflatedLayout)) continue;
            if ((Location)pair.getSecond() == null) {
                continue;
            }
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)ERROR_MESSAGE, null, (int)8, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Element root = document.getDocumentElement();
        if (root != null) {
            NamedNodeMap attributes = root.getAttributes();
            NamedNodeMap namedNodeMap = attributes;
            Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = attributes.item(i);
                if (node == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
                }
                Attr attribute = (Attr)node;
                if (attribute.getLocalName() == null) continue;
                String string = attribute.getLocalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute.localName");
                if (!StringsKt.startsWith$default((String)string, (String)"layout_", (boolean)false, (int)2, null)) continue;
                Set set = this.layoutsWithRootLayoutParams;
                if (set == null) {
                    LayoutInflationDetector layoutInflationDetector = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    LayoutInflationDetector $this$run = layoutInflationDetector;
                    boolean bl3 = false;
                    HashSet hashSet = new HashSet(20);
                    $this$run.layoutsWithRootLayoutParams = hashSet;
                    set = hashSet;
                }
                Set layouts = set;
                String string2 = context.file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.file.name");
                layouts.add((String)Lint.getBaseName((String)string2));
                break;
            }
        }
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"inflate");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (node.getReceiver() == null) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression second = (UExpression)arguments.get(1);
        if (!UastLiteralUtils.isNullLiteral((UElement)((UElement)second))) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        ResourceReference resourceReference = ResourceReference.Companion.get((UElement)first);
        if (resourceReference == null) {
            return;
        }
        ResourceReference reference = resourceReference;
        if (LayoutInflationDetector.Companion.isUsedWithAlertDialog(context, node)) {
            return;
        }
        String layoutName = reference.getName();
        if (context.getScope().contains(Scope.RESOURCE_FILE)) {
            if (!context.getDriver().isSuppressed(context, ISSUE, (UAnnotated)node)) {
                List list = this.pendingErrors;
                if (list == null) {
                    LayoutInflationDetector layoutInflationDetector = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    LayoutInflationDetector $this$run = layoutInflationDetector;
                    boolean bl3 = false;
                    ArrayList arrayList = new ArrayList();
                    $this$run.pendingErrors = arrayList;
                    list = arrayList;
                }
                List pending = list;
                Location location = context.getLocation((UElement)second);
                Pair pair = Pair.of((Object)layoutName, (Object)location);
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.of(layoutName, location)");
                pending.add((Pair<String, Location>)pair);
            }
        } else if (this.hasLayoutParams(context, layoutName)) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)second), (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final boolean hasLayoutParams(JavaContext context, String name) {
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return true;
        }
        Project project = context.getProject();
        ResourceRepository resourceRepository = client.getResourceRepository(project, true, false);
        if (resourceRepository == null) {
            return true;
        }
        ResourceRepository resources = resourceRepository;
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, name);
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            ResourceItem item;
            ResourceItem resourceItem = item = (ResourceItem)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceItem, (String)"item");
            if (resourceItem.getSource() == null) {
                return true;
            }
            try {
                PathString source;
                XmlPullParser parser = client.createXmlPullParser(source);
                if (parser == null || !Companion.hasLayoutParams(parser)) continue;
                return true;
            }
            catch (XmlPullParserException e) {
                context.log((Throwable)e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
            catch (IOException e) {
                context.log((Throwable)e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(LayoutInflationDetector.class, Scope.JAVA_AND_RESOURCE_FILES, new EnumSet[]{Scope.JAVA_FILE_SCOPE});
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        Severity severity = Severity.WARNING;
        int n = 5;
        Category category = Category.CORRECTNESS;
        String string = "https://www.bignerdranch.com/blog/understanding-androids-layoutinflater-inflate/";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"InflateParams", (String)"Layout Inflation without a Parent", (String)"\n                    When inflating a layout, avoid passing in null as the parent view, since \\\n                    otherwise any layout parameters on the root of the inflated layout will be \\\n                    ignored.", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3840, null);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean hasLayoutParams(@NotNull XmlPullParser parser) throws XmlPullParserException, IOException {
        return Companion.hasLayoutParams(parser);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector$Companion;", "", "()V", "ERROR_MESSAGE", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "hasLayoutParams", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "isAlertBuilder", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "cls", "Lcom/intellij/psi/PsiClass;", "s", "isUsedWithAlertDialog", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private final boolean isUsedWithAlertDialog(JavaContext context, UCallExpression call) {
            UElement uElement = UastUtils.getParentOfType$default((UElement)((UElement)call), UVariable.class, (boolean)false, (int)2, null);
            if (uElement == null) {
                return false;
            }
            UElement variable = uElement;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)variable, UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return false;
            }
            UMethod method = uMethod;
            PsiElement sourcePsi = variable.getSourcePsi();
            PsiElement javaPsi = variable.getJavaPsi();
            Ref isAlertBuilderUsage = new Ref((Object)false);
            method.accept((UastVisitor)new AbstractUastVisitor(sourcePsi, javaPsi, isAlertBuilderUsage, context){
                final /* synthetic */ PsiElement $sourcePsi;
                final /* synthetic */ PsiElement $javaPsi;
                final /* synthetic */ Ref $isAlertBuilderUsage;
                final /* synthetic */ JavaContext $context;

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    this.checkUsage(node);
                    return super.visitSimpleNameReferenceExpression(node);
                }

                private final void checkUsage(USimpleNameReferenceExpression node) {
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (Intrinsics.areEqual((Object)resolved, (Object)this.$sourcePsi) ^ true && Intrinsics.areEqual((Object)resolved, (Object)this.$javaPsi) ^ true) {
                        return;
                    }
                    UElement uElement = node.getUastParent();
                    if (!(uElement instanceof UCallExpression)) {
                        uElement = null;
                    }
                    UCallExpression uCallExpression = (UCallExpression)uElement;
                    if (uCallExpression == null) {
                        return;
                    }
                    UCallExpression setViewCall = uCallExpression;
                    if (Intrinsics.areEqual((Object)"setView", (Object)setViewCall.getMethodName()) ^ true) {
                        return;
                    }
                    UExpression uExpression = setViewCall.getReceiver();
                    if (uExpression == null) {
                        return;
                    }
                    UExpression receiver = uExpression;
                    PsiType psiType = receiver.getExpressionType();
                    if (psiType == null) {
                        return;
                    }
                    PsiType psiType2 = psiType;
                    String string = psiType2.getCanonicalText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiType.canonicalText");
                    if (com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, string)) {
                        this.$isAlertBuilderUsage.set((Object)true);
                    } else {
                        JavaEvaluator evaluator = this.$context.getEvaluator();
                        PsiClass psiClass = evaluator.getTypeClass(psiType2);
                        if (psiClass == null) {
                            return;
                        }
                        PsiClass typeClass = psiClass;
                        PsiMethod[] psiMethodArray = typeClass.getMethods();
                        int n = psiMethodArray.length;
                        for (int i = 0; i < n; ++i) {
                            PsiClass returnClass;
                            PsiType returnType;
                            PsiMethod m;
                            PsiMethod psiMethod = m = psiMethodArray[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"m");
                            if (psiMethod.getReturnType() == null) {
                                continue;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)returnType, (String)"m.returnType ?: continue");
                            if (returnType instanceof PsiPrimitiveType) continue;
                            if (evaluator.getTypeClass(returnType) == null) {
                                continue;
                            }
                            if (returnClass == typeClass || !com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, evaluator, returnClass)) continue;
                            this.$isAlertBuilderUsage.set((Object)true);
                            break;
                        }
                    }
                }
                {
                    this.$sourcePsi = $captured_local_variable$0;
                    this.$javaPsi = $captured_local_variable$1;
                    this.$isAlertBuilderUsage = $captured_local_variable$2;
                    this.$context = $captured_local_variable$3;
                }
            });
            Object object = isAlertBuilderUsage.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"isAlertBuilderUsage.get()");
            return (Boolean)object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAlertBuilder(String s) {
            String string = s;
            switch (string.hashCode()) {
                case -1763359899: {
                    if (!string.equals("android.app.AlertDialog.Builder")) break;
                    return true;
                }
                case 768695572: {
                    if (!string.equals("androidx.appcompat.app.AlertDialog.Builder")) break;
                    return true;
                }
                case 1413679300: {
                    if (!string.equals("com.google.android.material.dialog.MaterialAlertDialogBuilder")) break;
                    return true;
                }
                case -1145139499: {
                    if (!string.equals("android.support.v7.app.AlertDialog.Builder")) break;
                    return true;
                }
            }
            boolean bl = StringsKt.contains$default((CharSequence)s, (CharSequence)"AlertDialog", (boolean)false, (int)2, null);
            return bl;
        }

        private final boolean isAlertBuilder(JavaEvaluator evaluator, PsiClass cls) {
            return !evaluator.inheritsFrom(cls, "android.app.Dialog", true) ? false : evaluator.inheritsFrom(cls, "android.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "android.support.v7.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "androidx.appcompat.app.AlertDialog", false);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        public final boolean hasLayoutParams(@NotNull XmlPullParser parser) throws XmlPullParserException, IOException {
            int event;
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            do {
                if ((event = parser.next()) != 2) continue;
                int n = 0;
                int n2 = parser.getAttributeCount();
                while (n < n2) {
                    String prefix;
                    void i;
                    String string = parser.getAttributeName((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.getAttributeName(i)");
                    if (StringsKt.startsWith$default((String)string, (String)"layout_", (boolean)false, (int)2, null) && (prefix = parser.getAttributePrefix((int)i)) != null) {
                        CharSequence charSequence = prefix;
                        boolean bl = false;
                        if (!(charSequence.length() == 0) && Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)parser.getNamespace(prefix))) {
                            return true;
                        }
                    }
                    ++i;
                }
                return false;
            } while (event != 1 && event != 3);
            return false;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, String s) {
            return $this.isAlertBuilder(s);
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, JavaEvaluator evaluator, PsiClass cls) {
            return $this.isAlertBuilder(evaluator, cls);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

