/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "checkExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "checkMethod", "declaration", "Lorg/jetbrains/uast/UMethod;", "defaultEquals", "", "type", "Lcom/intellij/psi/PsiClassType;", "Lorg/jetbrains/uast/UElement;", "isCastWithEquals", "Lorg/jetbrains/uast/UExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "withinCastWithEquals", "Companion", "android.sdktools.lint-checks"})
public final class DiffUtilDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{"android.support.v7.util.DiffUtil.ItemCallback", "androidx.recyclerview.widget.DiffUtil.ItemCallback", "android.support.v17.leanback.widget.DiffCallback", "androidx.leanback.widget.DiffCallback"});
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        for (UMethod method : declaration.getMethods()) {
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"areContentsTheSame") || evaluator.getParameterCount((PsiMethod)method) != 2) continue;
            this.checkMethod(context, method);
        }
    }

    private final void checkMethod(JavaContext context, UMethod declaration) {
        declaration.accept((UastVisitor)new AbstractUastVisitor(this, context){
            final /* synthetic */ DiffUtilDetector this$0;
            final /* synthetic */ JavaContext $context;

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                DiffUtilDetector.access$checkExpression(this.this$0, this.$context, node);
                return super.visitBinaryExpression(node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                DiffUtilDetector.access$checkCall(this.this$0, this.$context, node);
                return super.visitCallExpression(node);
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        });
    }

    private final boolean defaultEquals(JavaContext context, UElement node) {
        PsiMethod resolved = null;
        if (node instanceof UBinaryExpression) {
            resolved = ((UBinaryExpression)node).resolveOperator();
            if (resolved == null) {
                PsiType psiType = ((UBinaryExpression)node).getLeftOperand().getExpressionType();
                if (!(psiType instanceof PsiClassType)) {
                    psiType = null;
                }
                PsiClassType left = (PsiClassType)psiType;
                return this.defaultEquals(context, left);
            }
        } else if (node instanceof UCallExpression) {
            resolved = ((UCallExpression)node).resolve();
        } else {
            return false;
        }
        if (resolved == null) {
            return false;
        }
        PsiClass psiClass = resolved.getContainingClass();
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object");
    }

    private final boolean defaultEquals(JavaContext context, PsiClassType type) {
        PsiClassType psiClassType = type;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"type?.resolve() ?: return false");
        PsiClassType cls = psiClassType;
        if (Lint.isKotlin((PsiElement)((PsiElement)cls)) && (context.getEvaluator().isSealed((PsiModifierListOwner)cls) || context.getEvaluator().isData((PsiModifierListOwner)cls))) {
            return false;
        }
        for (PsiMethod m : cls.findMethodsByName("equals", true)) {
            if (!(m instanceof PsiMethod)) continue;
            PsiParameterList psiParameterList = m.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"m.parameterList");
            PsiParameter[] parameters = psiParameterList.getParameters();
            if (parameters.length != 1) continue;
            PsiParameter psiParameter = parameters[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[0]");
            PsiType psiType = psiParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"parameters[0].type");
            if (!Intrinsics.areEqual((Object)psiType.getCanonicalText(), (Object)"java.lang.Object")) continue;
            PsiClass psiClass = m.getContainingClass();
            return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.lang.Object");
        }
        return false;
    }

    private final void checkCall(JavaContext context, UCallExpression node) {
        if (this.defaultEquals(context, (UElement)node)) {
            if (this.withinCastWithEquals(context, node)) {
                return;
            }
            Object object = node.getReceiverType();
            if (object == null || (object = object.getCanonicalText()) == null) {
                object = "target";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.receiverType?.canonicalText ?: \"target\"");
            Object targetType = object;
            String message2 = "Suspicious equality check: `equals()` is not implemented in " + (String)targetType;
            Location location = context.getCallLocation(node, false, true);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
        }
    }

    private final boolean withinCastWithEquals(JavaContext context, UCallExpression node) {
        UElement uElement = UastUtils.getParentOfType((UElement)((UElement)node), UIfExpression.class, (boolean)false, (Class[])new Class[]{UMethod.class});
        if (!(uElement instanceof UIfExpression)) {
            uElement = null;
        }
        UIfExpression uIfExpression = (UIfExpression)uElement;
        if (uIfExpression == null) {
            return false;
        }
        UIfExpression ifStatement = uIfExpression;
        UExpression condition = ifStatement.getCondition();
        return this.isCastWithEquals(context, condition);
    }

    private final boolean isCastWithEquals(JavaContext context, UExpression node) {
        if (node instanceof UBinaryExpressionWithType) {
            PsiType psiType = ((UBinaryExpressionWithType)node).getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            return !this.defaultEquals(context, (PsiClassType)psiType);
        }
        if (node instanceof UPolyadicExpression) {
            for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                if (!this.isCastWithEquals(context, operand)) continue;
                return true;
            }
        }
        return false;
    }

    private final void checkExpression(JavaContext context, UBinaryExpression node) {
        block10: {
            UIdentifier uIdentifier;
            String message2;
            block15: {
                block14: {
                    block11: {
                        UIdentifier uIdentifier2;
                        String message3;
                        block13: {
                            block12: {
                                if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.IDENTITY_EQUALS) && !Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) break block10;
                                PsiType psiType = node.getLeftOperand().getExpressionType();
                                if (psiType == null) {
                                    return;
                                }
                                PsiType left = psiType;
                                PsiType psiType2 = node.getRightOperand().getExpressionType();
                                if (psiType2 == null) {
                                    return;
                                }
                                PsiType right = psiType2;
                                if (!(left instanceof PsiClassType) || !(right instanceof PsiClassType)) break block10;
                                if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) break block11;
                                if (!this.defaultEquals(context, (UElement)node)) break block10;
                                message3 = "Suspicious equality check: `equals()` is not implemented in " + ((PsiClassType)left).getClassName();
                                uIdentifier2 = node.getOperatorIdentifier();
                                if (uIdentifier2 == null) break block12;
                                UIdentifier uIdentifier3 = uIdentifier2;
                                boolean bl = false;
                                boolean bl2 = false;
                                UIdentifier it = uIdentifier3;
                                boolean bl3 = false;
                                uIdentifier2 = context.getLocation((UElement)it);
                                if (uIdentifier2 != null) break block13;
                            }
                            uIdentifier2 = context.getLocation((UElement)node);
                        }
                        UIdentifier location = uIdentifier2;
                        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message3, null, (int)16, null);
                        break block10;
                    }
                    message2 = Lint.isKotlin((PsiElement)node.getSourcePsi()) ? "Suspicious equality check: Did you mean `==` instead of `===` ?" : "Suspicious equality check: Did you mean `.equals()` instead of `==` ?";
                    uIdentifier = node.getOperatorIdentifier();
                    if (uIdentifier == null) break block14;
                    UIdentifier uIdentifier4 = uIdentifier;
                    boolean bl = false;
                    boolean bl4 = false;
                    UIdentifier it = uIdentifier4;
                    boolean bl5 = false;
                    uIdentifier = context.getLocation((UElement)it);
                    if (uIdentifier != null) break block15;
                }
                uIdentifier = context.getLocation((UElement)node);
            }
            UIdentifier location = uIdentifier;
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(DiffUtilDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Severity severity = Severity.ERROR;
        String string = "https://issuetracker.google.com/116789824";
        Boolean bl2 = true;
        int n = 4;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DiffUtilEquals", (String)"Suspicious DiffUtil Equality", (String)"\n                `areContentsTheSame` is used by `DiffUtil` to produce diffs. If the \\\n                method is implemented incorrectly, such as using identity equals \\\n                instead of equals, or calling equals on a class that has not implemented \\\n                it, weird visual artifacts can occur.\n                ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3328, null);
    }

    public static final /* synthetic */ void access$checkExpression(DiffUtilDetector $this, JavaContext context, UBinaryExpression node) {
        $this.checkExpression(context, node);
    }

    public static final /* synthetic */ void access$checkCall(DiffUtilDetector $this, JavaContext context, UCallExpression node) {
        $this.checkCall(context, node);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/DiffUtilDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

