/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/DateFormatDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkDateFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "argument", "Lorg/jetbrains/uast/UExpression;", "getApplicableConstructorTypes", "", "", "getApplicableMethodNames", "visitConstructor", "node", "constructor", "Lcom/intellij/psi/PsiMethod;", "visitMethodCall", "method", "Companion", "android.sdktools.lint-checks"})
public final class DateFormatDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue DATE_FORMAT;
    @JvmField
    @NotNull
    public static final Issue WEEK_YEAR;
    @NotNull
    public static final String LOCALE_CLS = "java.util.Locale";
    private static final String CLS_DATE_TIME_FORMATTER = "java.time.format.DateTimeFormatter";
    private static final String JAVA_SIMPLE_DATE_FORMAT_CLS = "java.text.SimpleDateFormat";
    private static final String ICU_SIMPLE_DATE_FORMAT_CLS = "android.icu.text.SimpleDateFormat";
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object[])new String[]{JAVA_SIMPLE_DATE_FORMAT_CLS, ICU_SIMPLE_DATE_FORMAT_CLS});
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        if (!DateFormatDetector.Companion.specifiesLocale(constructor)) {
            Location location = context.getLocation((UElement)node);
            String message2 = "To get local formatting use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()`, or use `new SimpleDateFormat(String template, Locale locale)` with for example `Locale.US` for ASCII dates.";
            JavaContext.report$default((JavaContext)context, (Issue)DATE_FORMAT, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
        }
        if (context.isEnabled(WEEK_YEAR)) {
            this.checkDateFormat(context, node);
        }
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"ofPattern");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (context.getEvaluator().isMemberInClass((PsiMember)method, CLS_DATE_TIME_FORMATTER) && context.isEnabled(WEEK_YEAR)) {
            this.checkDateFormat(context, node);
        }
    }

    private final void checkDateFormat(JavaContext context, UCallExpression call) {
        for (UExpression argument : call.getValueArguments()) {
            PsiType type;
            if (argument.getExpressionType() == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)"java.lang.String")) continue;
            this.checkDateFormat(context, argument);
            break;
        }
    }

    private final void checkDateFormat(JavaContext context, UExpression argument) {
        int index;
        Object object;
        UExpression uExpression = argument;
        if (uExpression instanceof ULiteralExpression) {
            object = ((ULiteralExpression)argument).getValue();
        } else if (uExpression instanceof UInjectionHost) {
            Object object2 = ((UInjectionHost)argument).evaluateToString();
            if (object2 == null) {
                object2 = object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument);
            }
            if (object2 == null) {
                return;
            }
        } else {
            object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument);
            if (object == null) {
                return;
            }
        }
        Object value = object;
        String format = String.valueOf(value);
        if (!StringsKt.contains$default((CharSequence)format, (CharSequence)"Y", (boolean)false, (int)2, null)) {
            return;
        }
        boolean escaped = false;
        int weekYearStart = -1;
        boolean haveDate = false;
        boolean haveEraYear = false;
        CharSequence charSequence = format;
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c = charSequence.charAt(n2);
            if (c == '\'') {
                escaped = !escaped;
            } else if (c == 'M' || c == 'L' || c == 'd') {
                haveDate = true;
            } else if (c == 'y' || c == 'u') {
                haveEraYear = true;
            } else if (c == 'Y' && !escaped && weekYearStart == -1) {
                weekYearStart = index;
            }
            ++index;
        }
        if (weekYearStart != -1 && haveDate && !haveEraYear) {
            int end;
            index = weekYearStart;
            Location location = context.getLocation((UElement)argument);
            for (end = index + 1; end < format.length() && format.charAt(end) == 'Y'; ++end) {
            }
            String string = format;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(index, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String digits = string3;
            if (argument instanceof ULiteralExpression) {
                location = context.getRangeLocation((UElement)argument, index, end - index);
            } else if (argument instanceof UInjectionHost && argument instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)argument).getOperator(), (Object)UastBinaryOperator.PLUS) && ((UPolyadicExpression)argument).getOperands().size() == 1 && CollectionsKt.first((List)((UPolyadicExpression)argument).getOperands()) instanceof ULiteralExpression) {
                location = context.getRangeLocation((UElement)((UPolyadicExpression)argument).getOperands().get(0), index, end - index);
            }
            JavaContext.report$default((JavaContext)context, (Issue)WEEK_YEAR, (UElement)((UElement)argument), (Location)location, (String)("`DateFormat` character 'Y' in " + digits + " is the week-era-year; did you mean 'y' ?"), null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(DateFormatDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        String string = "https://developer.android.com/reference/java/text/SimpleDateFormat.html";
        Severity severity = Severity.WARNING;
        int n = 6;
        Object object = Category.CORRECTNESS;
        DATE_FORMAT = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"SimpleDateFormat", (String)"Implied locale in date format", (String)"\n                    Almost all callers should use `getDateInstance()`, `getDateTimeInstance()`, \\\n                    or `getTimeInstance()` to get a ready-made instance of SimpleDateFormat \\\n                    suitable for the user's locale. The main reason you'd create an instance \\\n                    this class directly is because you need to format/parse a specific \\\n                    machine-readable format, in which case you almost certainly want to \\\n                    explicitly ask for US to ensure that you get ASCII digits (rather than, \\\n                    say, Arabic digits).\n\n                    Therefore, you should either use the form of the SimpleDateFormat \\\n                    constructor where you pass in an explicit locale, such as Locale.US, or \\\n                    use one of the get instance methods, or suppress this error if really know \\\n                    what you are doing.\n                    ", (Implementation)implementation, (String)string, (Category)object, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3840, null);
        collection = null;
        enumSet = null;
        bl = null;
        Implementation implementation2 = IMPLEMENTATION;
        boolean bl3 = true;
        string = Severity.WARNING;
        int n2 = 6;
        Category category = Category.I18N;
        object = "https://stackoverflow.com/questions/46847245/using-datetimeformatter-on-january-first-cause-an-invalid-year-value";
        WEEK_YEAR = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"WeekBasedYear", (String)"Week Based Year", (String)"\n                The `DateTimeFormatter` pattern `YYYY` returns the *week* based year, not \\\n                the era-based year. This means that 12/29/2019 will format to 2019, but \\\n                12/30/2019 will format to 2020!\n\n                If you expected this to format as 2019, you should use the pattern `yyyy` \\\n                instead.\n                ", (Implementation)implementation2, (String)object, (Category)category, (int)n2, (Severity)string, (boolean)bl3, bl, enumSet, collection, (int)3584, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/DateFormatDetector$Companion;", "", "()V", "CLS_DATE_TIME_FORMATTER", "", "DATE_FORMAT", "Lcom/android/tools/lint/detector/api/Issue;", "ICU_SIMPLE_DATE_FORMAT_CLS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "JAVA_SIMPLE_DATE_FORMAT_CLS", "LOCALE_CLS", "WEEK_YEAR", "specifiesLocale", "", "method", "Lcom/intellij/psi/PsiMethod;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private final boolean specifiesLocale(PsiMethod method) {
            PsiParameter[] parameters;
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList parameterList = psiParameterList;
            PsiParameter[] psiParameterArray = parameters = parameterList.getParameters();
            int n = psiParameterArray.length;
            for (int i = 0; i < n; ++i) {
                PsiType type;
                PsiParameter parameter;
                PsiParameter psiParameter = parameter = psiParameterArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameter");
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter.getType(), (String)"parameter.type");
                if (!Intrinsics.areEqual((Object)type.getCanonicalText(), (Object)DateFormatDetector.LOCALE_CLS)) continue;
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

