/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getRequiredSuperMethod", "Lcom/intellij/psi/PsiMethod;", "method", "Lorg/jetbrains/uast/UMethod;", "Issues", "SuperCallVisitor", "android.sdktools.lint-checks"})
public final class CallSuperDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final AndroidxName CALL_SUPER_ANNOTATION;
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ CallSuperDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiMethod psiMethod = CallSuperDetector.access$getRequiredSuperMethod(this.this$0, this.$context, node);
                if (psiMethod == null) {
                    return;
                }
                PsiMethod superMethod = psiMethod;
                SuperCallVisitor visitor2 = new SuperCallVisitor(superMethod);
                node.accept((UastVisitor)visitor2);
                int count = visitor2.getCallsSuperCount();
                if (count == 0) {
                    String message2 = "Overriding method should call `super." + node.getName() + '`';
                    Location location = this.$context.getNameLocation(node);
                    LintFix fix = CallSuperDetector.access$fix(this.this$0).map().put(PsiMethod.class, (Object)superMethod).build();
                    this.$context.report(CallSuperDetector.ISSUE, node, location, message2, fix);
                } else if (count > 1 && Intrinsics.areEqual((Object)node.getName(), (Object)"onCreate")) {
                    USuperExpression uSuperExpression = visitor2.findFirstOverlap(node);
                    if (uSuperExpression == null) {
                        return;
                    }
                    USuperExpression overlap = uSuperExpression;
                    String message3 = "Calling `super." + node.getName() + "` more than once can lead to crashes";
                    Location location = this.$context.getNameLocation((UElement)overlap);
                    this.$context.report(CallSuperDetector.ISSUE, node, location, message3);
                }
            }
            {
                this.this$0 = this$0;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final PsiMethod getRequiredSuperMethod(JavaContext context, UMethod method) {
        PsiAnnotation[] annotations;
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod psiMethod = evaluator.getSuperMethod((PsiMethod)method);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod directSuper = psiMethod;
        String name = method.getName();
        if (Intrinsics.areEqual((Object)ON_DETACHED_FROM_WINDOW, (Object)name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                return null;
            }
            return directSuper;
        }
        if (Intrinsics.areEqual((Object)ON_VISIBILITY_CHANGED, (Object)name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return directSuper;
        }
        for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)directSuper, true)) {
            String signature = annotation.getQualifiedName();
            if (!CALL_SUPER_ANNOTATION.isEquals(signature) && (signature == null || !StringsKt.endsWith$default((String)signature, (String)".OverrideMustInvoke", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)signature, (String)".OverridingMethodsMustInvokeSuper", (boolean)false, (int)2, null))) continue;
            return directSuper;
        }
        return null;
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create("MissingSuperCall", "Missing Super Call", "\n            Some methods, such as `View#onDetachedFromWindow`, require that you also call the \\\n            super implementation as part of your method.\n            ", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
        CALL_SUPER_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"CallSuper");
    }

    public static final /* synthetic */ PsiMethod access$getRequiredSuperMethod(CallSuperDetector $this, JavaContext context, UMethod method) {
        return $this.getRequiredSuperMethod(context, method);
    }

    public static final /* synthetic */ LintFix.Builder access$fix(CallSuperDetector $this) {
        return $this.fix();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$SuperCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "targetMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)V", "callsSuperCount", "", "getCallsSuperCount", "()I", "superCalls", "", "Lorg/jetbrains/uast/USuperExpression;", "getSuperCalls", "()Ljava/util/List;", "findFirstOverlap", "method", "Lorg/jetbrains/uast/UMethod;", "visitSuperExpression", "", "node", "android.sdktools.lint-checks"})
    private static final class SuperCallVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final List<USuperExpression> superCalls;
        private final PsiMethod targetMethod;

        @NotNull
        public final List<USuperExpression> getSuperCalls() {
            return this.superCalls;
        }

        public final int getCallsSuperCount() {
            return this.superCalls.size();
        }

        public boolean visitSuperExpression(@NotNull USuperExpression node) {
            PsiElement resolved;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UElement parent = Lint.skipParentheses((UElement)node.getUastParent());
            if (parent instanceof UReferenceExpression && ((resolved = ((UReferenceExpression)parent).resolve()) == null || this.targetMethod.isEquivalentTo(resolved))) {
                this.superCalls.add(node);
            }
            return super.visitSuperExpression(node);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final USuperExpression findFirstOverlap(@NotNull UMethod method) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            int n = 0;
            int n2 = this.superCalls.size();
            while (n < n2) {
                void i;
                void var4_4 = i + true;
                int n3 = this.superCalls.size();
                while (var4_4 < n3) {
                    void j;
                    if (CutPasteDetector.isReachableFrom(method, (UElement)this.superCalls.get((int)i), (UElement)this.superCalls.get((int)j))) {
                        return this.superCalls.get((int)j);
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public SuperCallVisitor(@NotNull PsiMethod targetMethod) {
            Intrinsics.checkParameterIsNotNull((Object)targetMethod, (String)"targetMethod");
            this.targetMethod = targetMethod;
            boolean bl = false;
            this.superCalls = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$Issues;", "", "()V", "CALL_SUPER_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ON_DETACHED_FROM_WINDOW", "", "ON_VISIBILITY_CHANGED", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

