/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDependencyInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDependencyInspection() {
        super(LintBundle.message("android.lint.inspections.gradle.dependency", new Object[0]), GradleDetector.DEPENDENCY);
    }

    public static void upgrade(@Nullable Module module) {
        if (module != null) {
            LintIdeSupport.get().updateToLatest(module, ConstraintLayoutDetector.LATEST_KNOWN_VERSION);
        }
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Class detector;
        if (startElement == null) {
            AndroidLintGradleDependencyInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintGradleDependencyInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintGradleDependencyInspection.$$$reportNull$$$0(2);
        }
        if (Objects.equals(detector = (Class)LintFix.getData((LintFix)fixData, Class.class), ConstraintLayoutDetector.class)) {
            LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new UpgradeConstraintLayoutFix()};
            if (lintIdeQuickFixArray == null) {
                AndroidLintGradleDependencyInspection.$$$reportNull$$$0(3);
            }
            return lintIdeQuickFixArray;
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        if (lintIdeQuickFixArray == null) {
            AndroidLintGradleDependencyInspection.$$$reportNull$$$0(4);
        }
        return lintIdeQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintGradleDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintGradleDependencyInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UpgradeConstraintLayoutFix
    implements LintIdeQuickFix {
        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            if (startElement == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(0);
            }
            if (endElement == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(1);
            }
            if (context == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(2);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
            AndroidLintGradleDependencyInspection.upgrade(module);
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            if (startElement == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(4);
            }
            if (contextType == null) {
                UpgradeConstraintLayoutFix.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            return "Upgrade to recommended version";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextType";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintGradleDependencyInspection$UpgradeConstraintLayoutFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isApplicable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

