/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.inspections.SpringSecurityBaseInspection;
import com.intellij.spring.security.model.xml.Debug;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;

public final class SpringSecurityDebugActivatedInspection
extends SpringSecurityBaseInspection {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        boolean hasDebugElement = SpringDomUtils.hasElement(domFileElement, Debug.class);
        if (!hasDebugElement) {
            return;
        }
        Beans beans = (Beans)domFileElement.getRootElement();
        beans.acceptChildren((DomElementVisitor)new MyDomElementVisitor(holder));
    }

    private static final class MyDomElementVisitor
    implements DomElementVisitor {
        private final DomElementAnnotationHolder holder;

        private MyDomElementVisitor(DomElementAnnotationHolder holder) {
            this.holder = holder;
        }

        public void visitDomElement(DomElement element) {
        }

        public void visitDebug(Debug debug) {
            this.holder.createProblem((DomElement)debug, SpringSecurityBundle.message("model.inspection.debug.activated.message", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

