/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.dataSource;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class WebLogicDataSourceDetector
extends DataSourceDetector {
    private static final String WEBLOGIC_RESOURCE_TYPE = "weblogic.resource";
    private static final String JDBC_DATA_SOURCE_TAG = "jdbc-data-source";
    private static final String JDBC_DRIVER_PARAMS_TAG = "jdbc-driver-params";
    private static final String PROPERTIES_TAG = "properties";
    private static final String DRIVER_NAME_TAG = "driver-name";
    private static final String NAME_TAG = "name";
    private static final String PROPERTY_TAG = "property";
    private static final String VALUE_TAG = "value";
    private static final String URL_TAG = "url";
    private static final String USER_TAG = "user";
    private static final String PASSWORD_TAG = "password";

    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            WebLogicDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            WebLogicDataSourceDetector.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord((element, offsetInElement) -> {
            XmlTag sourceTag = (XmlTag)ObjectUtils.tryCast((Object)element, XmlTag.class);
            if (sourceTag == null || !JDBC_DATA_SOURCE_TAG.equals(sourceTag.getLocalName())) {
                return true;
            }
            XmlTag driverParamsTag = sourceTag.findFirstSubTag(JDBC_DRIVER_PARAMS_TAG);
            if (driverParamsTag == null) {
                return true;
            }
            XmlTag propertiesTag = driverParamsTag.findFirstSubTag(PROPERTIES_TAG);
            if (propertiesTag == null) {
                return true;
            }
            String username = "";
            String password = "";
            for (XmlTag property : propertiesTag.findSubTags(PROPERTY_TAG)) {
                String propertyName = property.getSubTagText(NAME_TAG);
                if (USER_TAG.equals(propertyName)) {
                    username = property.getSubTagText(VALUE_TAG);
                    continue;
                }
                if (!PASSWORD_TAG.equals(propertyName)) continue;
                password = property.getSubTagText(VALUE_TAG);
            }
            builder.withName(sourceTag.getSubTagText(NAME_TAG)).withDriverClass(driverParamsTag.getSubTagText(DRIVER_NAME_TAG)).withUrl(driverParamsTag.getSubTagText(URL_TAG)).withUser(username).withPassword(password).withComment(WEBLOGIC_RESOURCE_TYPE).withOrigin((Object)sourceTag).commit();
            return true;
        }, (SearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (FileType[])new FileType[]{StdFileTypes.XML}), JDBC_DATA_SOURCE_TAG, (short)8, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/weblogic/dataSource/WebLogicDataSourceDetector";
        objectArray[2] = "collectDataSources";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

