/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.build;

import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.weblogic.applicationServer.WeblogicPersistentData;
import com.intellij.javaee.weblogic.build.WebLogicServerValidator;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.ArtifactType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebLogicValidatorsFactory {
    private WebLogicValidatorsFactory() {
    }

    private static Version getVersion(@NotNull ApplicationServer server) {
        if (server == null) {
            WebLogicValidatorsFactory.$$$reportNull$$$0(0);
        }
        WeblogicPersistentData persistentData = (WeblogicPersistentData)server.getPersistentData();
        return new Version(persistentData.VERSION);
    }

    @Nullable
    public static AppServerSpecificValidator createValidator(JavaeeFacet facet, @NotNull ApplicationServer server) {
        if (server == null) {
            WebLogicValidatorsFactory.$$$reportNull$$$0(1);
        }
        Version version = WebLogicValidatorsFactory.getVersion(server);
        Project project = facet.getModule().getProject();
        if (version.getMajor() >= 8) {
            return new WebLogicServerValidator(project, server, version, true);
        }
        if (EjbFacet.ID.equals(facet.getTypeId())) {
            return new WebLogicServerValidator(project, server, version, false);
        }
        return null;
    }

    @Nullable
    public static AppServerSpecificValidator createValidator(@NotNull ApplicationServer server, ArtifactType artifactType, Project project) {
        Version version;
        if (server == null) {
            WebLogicValidatorsFactory.$$$reportNull$$$0(2);
        }
        if ((version = WebLogicValidatorsFactory.getVersion(server)).getMajor() >= 8) {
            return new WebLogicServerValidator(project, server, version, true);
        }
        if (JavaeeArtifactUtil.getInstance().isEjbApplication(artifactType)) {
            return new WebLogicServerValidator(project, server, version, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "server";
        objectArray2[1] = "com/intellij/javaee/weblogic/build/WebLogicValidatorsFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

