/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EnterpriseBean;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.weblogic.model.WeblogicEjbJar;
import com.intellij.javaee.weblogic.model.WeblogicEnterpriseBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

final class WeblogicPsiElementsProvider
extends JamDeleteHandler {
    WeblogicPsiElementsProvider() {
    }

    public void addModelElements(CommonModelElement element, Collection<CommonModelElement> result) {
        WeblogicRdbmsJar weblogicRdbmsJar;
        if (!(element instanceof EnterpriseBean)) {
            return;
        }
        EnterpriseBean ejb = (EnterpriseBean)element;
        String name = (String)ejb.getEjbName().getValue();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)ejb);
        if (ejbFacet == null) {
            return;
        }
        WeblogicEjbJar weblogicEjbJar = WeblogicEjbFacetUtil.getEjbRoot(ejbFacet);
        if (weblogicEjbJar != null) {
            for (WeblogicEnterpriseBean bean : weblogicEjbJar.getWeblogicEnterpriseBeans()) {
                if (!ejb.equals(bean.getEjbName().getValue())) continue;
                result.add((CommonModelElement)bean);
            }
        }
        if (ejb instanceof EntityBean && (weblogicRdbmsJar = WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet)) != null) {
            for (WeblogicRdbmsBean bean : weblogicRdbmsJar.getWeblogicRdbmsBeans()) {
                if (!ejb.equals(bean.getEjbName().getValue())) continue;
                ContainerUtil.addIfNotNull(result, (Object)bean);
            }
        }
    }
}

