/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.EntityBean;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.model.WeblogicEnterpriseBean;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;

public class WeblogicDomAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, final DomElementAnnotationHolder holder) {
        element.accept(new DomElementVisitor(){

            public void visitWeblogicEnterpriseBean(WeblogicEnterpriseBean bean) {
                EntityBean ejb;
                EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)bean);
                if (ejbFacet != null && (ejb = (EntityBean)ContainerUtil.find((Iterable)ejbFacet.getMergedRoot().getEnterpriseBeans().getEntities(), object -> Comparing.equal((Object)object.getEjbName().getValue(), (Object)bean.getEjbName().getValue()))) != null) {
                    GenericDomValue<String> jndiName = bean.getJndiName();
                    if (ejb.getHome().getValue() != null && StringUtil.isEmpty((String)((String)jndiName.getValue()))) {
                        holder.createProblem(jndiName, WeblogicBundle.message("warning.text.configure.ejbs.jndi.name.should.not.be.empty", new Object[0]), new LocalQuickFix[0]);
                    }
                    GenericDomValue<String> localJndiName = bean.getLocalJndiName();
                    if (ejb.getLocalHome().getValue() != null && StringUtil.isEmpty((String)((String)localJndiName.getValue()))) {
                        holder.createProblem(localJndiName, WeblogicBundle.message("warning.text.configure.ejbs.local.jndi.name.should.not.be.empty", new Object[0]), new LocalQuickFix[0]);
                    }
                }
                this.visitDomElement((DomElement)bean);
            }

            public void visitDomElement(DomElement element) {
            }
        });
    }
}

