/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.tasks.Task;
import java.util.List;
import java.util.stream.Collectors;

public class TaskResult {
    private final DeployerException exception;
    private final List<Task<?>> tasks;

    public TaskResult(List<Task<?>> tasks) {
        this(tasks, null);
    }

    public TaskResult(List<Task<?>> tasks, DeployerException exception) {
        this.tasks = tasks;
        this.exception = exception;
    }

    public List<DeployMetric> getMetrics() {
        return this.tasks.stream().map(Task::getMetric).filter(TaskResult::shouldIncludeMetric).collect(Collectors.toList());
    }

    public DeployerException getException() {
        return this.exception;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    private static boolean shouldIncludeMetric(DeployMetric metric) {
        if (metric == null) {
            return false;
        }
        return "Success".equals(metric.getStatus()) || "Failed".equals(metric.getStatus());
    }
}

