/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployerException;
import com.android.tools.tracer.Trace;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class Task<T> {
    private final Callable<T> callable;
    private final Task<?>[] inputs;
    final SettableFuture<T> future = SettableFuture.create();
    private DeployMetric metric;

    Task(String name, Callable<T> callable, Task<?> ... inputs) {
        this.inputs = inputs;
        this.callable = () -> {
            String status = "Not Started";
            this.metric = new DeployMetric(name);
            try {
                Object v;
                block12: {
                    Trace ignored = Trace.begin((String)name);
                    try {
                        Object value = callable.call();
                        status = "Success";
                        v = value;
                        if (ignored == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ExecutionException e) {
                            status = "Dropped";
                            throw e;
                        }
                        catch (Throwable t) {
                            status = "Failed";
                            throw t;
                        }
                    }
                    ignored.close();
                }
                return v;
            }
            finally {
                this.metric.finish(status);
            }
        };
    }

    public T get() throws DeployerException {
        try {
            return (T)this.future.get();
        }
        catch (InterruptedException e) {
            throw DeployerException.interrupted(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DeployerException) {
                throw (DeployerException)e.getCause();
            }
            throw DeployerException.runtimeException(e);
        }
    }

    public void run(Executor executor) {
        List futures = Arrays.stream(this.inputs).map(t -> t.future).collect(Collectors.toList());
        this.future.setFuture(Futures.whenAllComplete(futures).call(this.callable, executor));
    }

    public DeployMetric getMetric() {
        return this.metric;
    }
}

