/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.InstallerBasedClassRedefiner;
import com.android.tools.deployer.InstallerResponseHandler;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.idea.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OptimisticApkSwapper {
    private final Installer installer;
    private final boolean restart;
    private final Map<Integer, ClassRedefiner> redefiners;
    private final MetricsRecorder metrics;
    private final DeployerOption options;

    public OptimisticApkSwapper(Installer installer, Map<Integer, ClassRedefiner> redefiners, boolean restart, DeployerOption options, MetricsRecorder metrics) {
        this.installer = installer;
        this.redefiners = redefiners;
        this.restart = restart;
        this.options = options;
        this.metrics = metrics;
    }

    public SwapResult optimisticSwap(String packageId, List<Integer> pids, Deploy.Arch arch, OverlayUpdate overlayUpdate) throws DeployerException {
        String file;
        DeploymentCacheDatabase.Entry cachedDump = overlayUpdate.cachedDump;
        DexComparator.ChangedClasses dexOverlays = overlayUpdate.dexOverlays;
        Map fileOverlays = overlayUpdate.fileOverlays;
        OverlayId.Builder overlayIdBuilder = OverlayId.builder(cachedDump.getOverlayId());
        OverlayId expectedOverlayId = cachedDump.getOverlayId();
        Deploy.OverlaySwapRequest.Builder request = Deploy.OverlaySwapRequest.newBuilder().setPackageName(packageId).setRestartActivity(this.restart).setArch(arch).setExpectedOverlayId(expectedOverlayId.isBaseInstall() ? "" : expectedOverlayId.getSha()).setAlwaysUpdateOverlay(this.options.fastRestartOnSwapFail);
        boolean hasDebuggerAttached = false;
        for (Integer n : pids) {
            if (this.redefiners.containsKey(n)) {
                ClassRedefiner redefiner = this.redefiners.get(n);
                if (redefiner.canRedefineClass().support != ClassRedefiner.RedefineClassSupport.FULL) {
                    throw new IllegalArgumentException("R+ Device should have FULL debugger swap support");
                }
                hasDebuggerAttached = true;
                continue;
            }
            request.addProcessIds(n.intValue());
        }
        for (DexClass dexClass : dexOverlays.newClasses) {
            request.addNewClasses(Deploy.ClassDef.newBuilder().setName(dexClass.name).setDex(ByteString.copyFrom((byte[])dexClass.code)));
            file = String.format(Locale.US, "%s.dex", dexClass.name);
            overlayIdBuilder.addOverlayFile(file, dexClass.checksum);
        }
        for (DexClass dexClass : dexOverlays.modifiedClasses) {
            request.addModifiedClasses(Deploy.ClassDef.newBuilder().setName(dexClass.name).setDex(ByteString.copyFrom((byte[])dexClass.code)).addAllFields(dexClass.variableStates));
            file = String.format(Locale.US, "%s.dex", dexClass.name);
            overlayIdBuilder.addOverlayFile(file, dexClass.checksum);
        }
        for (Map.Entry entry : fileOverlays.entrySet()) {
            request.addResourceOverlays(Deploy.OverlayFile.newBuilder().setPath(((ApkEntry)entry.getKey()).getQualifiedPath()).setContent((ByteString)entry.getValue()));
            overlayIdBuilder.addOverlayFile(((ApkEntry)entry.getKey()).getQualifiedPath(), ((ApkEntry)entry.getKey()).getChecksum());
        }
        request.setStructuralRedefinition(this.options.useStructuralRedefinition);
        request.setVariableReinitialization(this.options.useVariableReinitialization);
        OverlayId overlayId = overlayIdBuilder.build();
        request.setOverlayId(overlayId.getSha());
        Deploy.OverlaySwapRequest overlaySwapRequest = request.build();
        InstallerResponseHandler.SuccessStatus successStatus = InstallerResponseHandler.SuccessStatus.OK;
        if (hasDebuggerAttached) {
            try {
                Deploy.OverlayIdPushResponse response = this.installer.verifyOverlayId(request.getPackageName(), request.getExpectedOverlayId());
                if (response.getStatus() != Deploy.OverlayIdPushResponse.Status.OK) {
                    throw DeployerException.overlayIdMismatch();
                }
            }
            catch (IOException e) {
                throw DeployerException.installerIoException(e);
            }
            block14: for (Map.Entry<Integer, ClassRedefiner> entry : this.redefiners.entrySet()) {
                switch (this.sendSwapRequest(overlaySwapRequest, entry.getValue())) {
                    case SWAP_FAILED_BUT_APP_UPDATED: {
                        successStatus = InstallerResponseHandler.SuccessStatus.SWAP_FAILED_BUT_APP_UPDATED;
                        continue block14;
                    }
                    case OK: {
                        continue block14;
                    }
                }
                throw new IllegalStateException("Unknown swap status");
            }
        }
        switch (this.sendSwapRequest(overlaySwapRequest, new InstallerBasedClassRedefiner(this.installer))) {
            case SWAP_FAILED_BUT_APP_UPDATED: {
                successStatus = InstallerResponseHandler.SuccessStatus.SWAP_FAILED_BUT_APP_UPDATED;
                break;
            }
            case OK: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown swap status");
            }
        }
        return new SwapResult(overlayId, successStatus == InstallerResponseHandler.SuccessStatus.OK);
    }

    private InstallerResponseHandler.SuccessStatus sendSwapRequest(Deploy.OverlaySwapRequest request, ClassRedefiner redefiner) throws DeployerException {
        Deploy.SwapResponse swapResponse = redefiner.redefine(request);
        this.metrics.add(swapResponse.getAgentLogsList());
        return new InstallerResponseHandler(this.options.useStructuralRedefinition ? InstallerResponseHandler.RedefinitionCapability.ALLOW_ADD_FIELD : InstallerResponseHandler.RedefinitionCapability.MOFIFY_CODE_ONLY).handle(swapResponse);
    }

    public static class SwapResult {
        public final OverlayId overlayId;
        public final boolean hotswapSucceeded;

        private SwapResult(OverlayId overlayId, boolean hotswapSucceeded) {
            this.overlayId = overlayId;
            this.hotswapSucceeded = hotswapSucceeded;
        }
    }

    public static final class OverlayUpdate {
        private final DeploymentCacheDatabase.Entry cachedDump;
        private final DexComparator.ChangedClasses dexOverlays;
        private final Map<ApkEntry, ByteString> fileOverlays;

        public OverlayUpdate(DeploymentCacheDatabase.Entry cachedDump, DexComparator.ChangedClasses dexOverlays, Map<ApkEntry, ByteString> fileOverlays) {
            this.cachedDump = cachedDump;
            this.dexOverlays = dexOverlays;
            this.fileOverlays = fileOverlays;
        }
    }
}

