/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployRunnerParameters;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DeployerRunner {
    private static final String DEX_DB_PATH = "/tmp/studio_dex.db";
    private static final String DEPLOY_DB_PATH = "/tmp/studio_deploy.db";
    private final DeploymentCacheDatabase cacheDb;
    private final SqlApkFileDatabase dexDb;
    private final MetricsRecorder metrics;
    private final UIService service;

    public static void main(String[] args) {
        Trace.start();
        Trace.begin((String)"main");
        int errorcode = DeployerRunner.tracedMain(args, (ILogger)new StdLogger(StdLogger.Level.VERBOSE));
        Trace.end();
        Trace.flush();
        if (errorcode != 0) {
            System.exit(errorcode);
        }
    }

    public static int tracedMain(String[] args, ILogger logger) {
        DeployerRunner runner = new DeployerRunner(new File(DEPLOY_DB_PATH), new File(DEX_DB_PATH), (UIService)new CommandLineService());
        return runner.run(args, logger);
    }

    public DeployerRunner(File deployCacheFile, File databaseFile, UIService service) {
        this(new DeploymentCacheDatabase(deployCacheFile), new SqlApkFileDatabase(databaseFile, null), service);
    }

    @VisibleForTesting
    public DeployerRunner(DeploymentCacheDatabase cacheDb, SqlApkFileDatabase dexDb, UIService service) {
        this.cacheDb = cacheDb;
        this.dexDb = dexDb;
        this.service = service;
        this.metrics = new MetricsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args, ILogger logger) {
        try {
            AndroidDebugBridge bridge = this.initDebugBridge();
            Trace.begin((String)"getDevice()");
            IDevice device = this.getDevice(bridge);
            if (device == null) {
                logger.error(null, "%s", new Object[]{"No device found."});
                int n = -2;
                return n;
            }
            Trace.end();
            int n = this.run(device, args, logger);
            return n;
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(IDevice device, String[] args, ILogger logger) {
        if (args.length < 2) {
            logger.info("Usage: DeployerRunner packageName [packageBase,packageSplit1,...]", new Object[0]);
            return -1;
        }
        DeployRunnerParameters parameters = DeployRunnerParameters.parse(args);
        String packageName = parameters.get(0);
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 1; i < parameters.size(); ++i) {
            apks.add(parameters.get(i));
        }
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (parameters.isOptimisticInstall()) {
            optimisticInstallSupport.add(ChangeType.DEX);
            optimisticInstallSupport.add(ChangeType.NATIVE_LIBRARY);
            optimisticInstallSupport.add(ChangeType.RESOURCE);
        }
        this.metrics.getDeployMetrics().clear();
        AdbClient adb = new AdbClient(device, logger);
        AdbInstaller installer = new AdbInstaller(parameters.getInstallersPath(), adb, this.metrics.getDeployMetrics(), logger);
        ExecutorService service = Executors.newFixedThreadPool(5);
        TaskRunner runner = new TaskRunner(service);
        DeployerOption deployerOption = new DeployerOption.Builder().setUseOptimisticSwap(true).setUseOptimisticResourceSwap(true).setUseStructuralRedefinition(true).setUseVariableReinitialization(true).setFastRestartOnSwapFail(false).setOptimisticInstallSupport(optimisticInstallSupport).build();
        Deployer deployer = new Deployer(adb, this.cacheDb, this.dexDb, runner, installer, this.service, this.metrics, logger, deployerOption);
        try {
            if (parameters.getCommand() == DeployRunnerParameters.Command.INSTALL) {
                InstallOptions.Builder options = InstallOptions.builder().setAllowDebuggable();
                if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
                    options.setGrantAllPermissions();
                }
                Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
                if (parameters.isForceFullInstall()) {
                    installMode = Deployer.InstallMode.FULL;
                }
                deployer.install(packageName, apks, options.build(), installMode);
            } else if (parameters.getCommand() == DeployRunnerParameters.Command.FULLSWAP) {
                deployer.fullSwap(apks);
            } else if (parameters.getCommand() == DeployRunnerParameters.Command.CODESWAP) {
                deployer.codeSwap(apks, (Map<Integer, ClassRedefiner>)ImmutableMap.of());
            } else {
                throw new RuntimeException("UNKNOWN command");
            }
            runner.run();
        }
        catch (DeployerException e) {
            logger.error((Throwable)e, "Not possible to execute " + parameters.getCommand().name().toLowerCase(), new Object[0]);
            logger.warning(e.getDetails(), new Object[0]);
            int n = e.getError().ordinal();
            return n;
        }
        finally {
            service.shutdown();
        }
        return 0;
    }

    public List<DeployMetric> getMetrics() {
        return this.metrics.getDeployMetrics();
    }

    private IDevice getDevice(AndroidDebugBridge bridge) {
        IDevice[] devices = bridge.getDevices();
        if (devices.length < 1) {
            return null;
        }
        return devices[0];
    }

    private AndroidDebugBridge initDebugBridge() {
        AndroidDebugBridge.init((AdbInitOptions)AdbInitOptions.DEFAULT);
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
        while (!bridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return bridge;
    }

    static class CommandLineService
    implements UIService {
        CommandLineService() {
        }

        @Override
        public boolean prompt(String message) {
            System.err.println(message + ". Y/N?");
            try (Scanner scanner = new Scanner(System.in);){
                boolean bl = scanner.nextLine().equalsIgnoreCase("y");
                return bl;
            }
        }

        @Override
        public void message(String message) {
            System.err.println(message);
        }
    }
}

