/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkEntryExtractor;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkParser;
import com.android.tools.deployer.ApkPreInstaller;
import com.android.tools.deployer.ApkSwapper;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.CachedDexSplitter;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.D8DexSplitter;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OptimisticApkInstaller;
import com.android.tools.deployer.OptimisticApkSwapper;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.SwapVerifier;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.tasks.Task;
import com.android.tools.deployer.tasks.TaskResult;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class Deployer {
    public static final String BASE_DIRECTORY = "/data/local/tmp/.studio";
    public static final String INSTALLER_DIRECTORY = "/data/local/tmp/.studio/bin";
    public static final String INSTALLER_TMP_DIRECTORY = "/data/local/tmp/.studio/tmp";
    private final AdbClient adb;
    private final SqlApkFileDatabase dexDb;
    private final DeploymentCacheDatabase deployCache;
    private final Installer installer;
    private final TaskRunner runner;
    private final UIService service;
    private final MetricsRecorder metrics;
    private final ILogger logger;
    private final DeployerOption options;

    public Deployer(AdbClient adb, DeploymentCacheDatabase deployCache, SqlApkFileDatabase dexDb, TaskRunner runner, Installer installer, UIService service, MetricsRecorder metrics, ILogger logger, DeployerOption options) {
        this.adb = adb;
        this.deployCache = deployCache;
        this.dexDb = dexDb;
        this.runner = runner;
        this.installer = installer;
        this.service = service;
        this.metrics = metrics;
        this.logger = logger;
        this.options = options;
    }

    public Result install(String packageName, List<String> apks, InstallOptions options, InstallMode installMode) throws DeployerException {
        try (Trace ignored = Trace.begin((String)"install");){
            if (this.supportsNewPipeline()) {
                installMode = installMode == InstallMode.DELTA ? InstallMode.DELTA_NO_SKIP : installMode;
                Result result = this.maybeOptimisticInstall(packageName, apks, options, installMode);
                return result;
            }
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            Task<List<String>> paths = this.runner.create(apks);
            Task<List> apkList = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths);
            Result result = new Result();
            result.skippedInstall = !apkInstaller.install(packageName, apks, options, installMode, this.metrics.getDeployMetrics());
            CachedDexSplitter splitter = new CachedDexSplitter(this.dexDb, new D8DexSplitter());
            this.runner.create(Tasks.CACHE, splitter::cache, apkList);
            this.runner.runAsync();
            Result result2 = result;
            return result2;
        }
    }

    private Result maybeOptimisticInstall(String pkgName, List<String> paths, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        Task<String> packageName = this.runner.create(pkgName);
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<List> apks = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, this.runner.create(paths));
        boolean installSuccess = false;
        if (!this.options.optimisticInstallSupport.isEmpty()) {
            OptimisticApkInstaller apkInstaller = new OptimisticApkInstaller(this.installer, this.adb, this.deployCache, this.metrics, this.options, this.logger);
            Task<OverlayId> overlayId = this.runner.create(Tasks.OPTIMISTIC_INSTALL, apkInstaller::install, packageName, apks);
            TaskResult result = this.runner.run();
            installSuccess = result.isSuccess();
            if (installSuccess) {
                this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::store, deviceSerial, packageName, apks, overlayId);
            }
            result.getMetrics().forEach(this.metrics::add);
        }
        CachedDexSplitter splitter = new CachedDexSplitter(this.dexDb, new D8DexSplitter());
        this.runner.create(Tasks.CACHE, splitter::cache, apks);
        Result deployResult = new Result();
        if (!installSuccess) {
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            deployResult.skippedInstall = !apkInstaller.install(pkgName, paths, installOptions, installMode, this.metrics.getDeployMetrics());
            this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::invalidate, deviceSerial, packageName);
        }
        this.runner.runAsync();
        return deployResult;
    }

    public Result codeSwap(List<String> apks, Map<Integer, ClassRedefiner> debuggerRedefiners) throws DeployerException {
        try (Trace ignored = Trace.begin((String)"codeSwap");){
            if (this.supportsNewPipeline()) {
                Result result = this.optimisticSwap(apks, false, debuggerRedefiners);
                return result;
            }
            Result result = this.swap(apks, false, debuggerRedefiners);
            return result;
        }
    }

    public Result fullSwap(List<String> apks) throws DeployerException {
        try (Trace ignored = Trace.begin((String)"fullSwap");){
            if (this.supportsNewPipeline() && this.options.useOptimisticResourceSwap) {
                Result result = this.optimisticSwap(apks, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of());
                return result;
            }
            Result result = this.swap(apks, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of());
            return result;
        }
    }

    private Result swap(List<String> argPaths, boolean argRestart, Map<Integer, ClassRedefiner> debuggerRedefiners) throws DeployerException {
        if (!this.adb.getVersion().isGreaterOrEqualThan(26)) {
            throw DeployerException.apiNotSupported();
        }
        Task<List<String>> paths = this.runner.create(argPaths);
        Task<Boolean> restart = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<List> newFiles = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths);
        Task<ApplicationDumper.Dump> dumps = this.runner.create(Tasks.DUMP, new ApplicationDumper(this.installer)::dump, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, (dump, newApks) -> new ApkDiffer().diff(dump.apks, (List<Apk>)newApks), dumps, newFiles);
        Task<String> sessionId = this.runner.create(Tasks.PREINSTALL, new ApkPreInstaller(this.adb, this.installer, this.logger)::preinstall, dumps, newFiles, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, diffs, restart);
        Task<DexComparator.ChangedClasses> toSwap = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        ApkSwapper swapper = new ApkSwapper(this.installer, debuggerRedefiners, argRestart, this.adb, this.logger);
        this.runner.create(Tasks.SWAP, swapper::swap, swapper::error, dumps, sessionId, toSwap);
        TaskResult result = this.runner.run();
        result.getMetrics().forEach(this.metrics::add);
        if (!result.isSuccess()) {
            throw result.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        this.runner.runAsync();
        Result deployResult = new Result();
        deployResult.skippedInstall = sessionId.get().equals("<SKIPPED-INSTALLATION>");
        return deployResult;
    }

    private Result optimisticSwap(List<String> argPaths, boolean argRestart, Map<Integer, ClassRedefiner> redefiners) throws DeployerException {
        if (!this.adb.getVersion().isGreaterOrEqualThan(26)) {
            throw DeployerException.apiNotSupported();
        }
        Task<List<String>> paths = this.runner.create(argPaths);
        Task<Boolean> restart = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<List> newFiles = this.runner.create(Tasks.PARSE_PATHS, new ApkParser()::parsePaths, paths);
        Task<String> packageName = this.runner.create(Tasks.PARSE_APP_IDS, ApplicationDumper::getPackageName, newFiles);
        Task<List> pids = this.runner.create(Tasks.GET_PIDS, this.adb::getPids, packageName);
        Task<Deploy.Arch> arch = this.runner.create(Tasks.GET_ARCH, this.adb::getArch, pids);
        Task<DeploymentCacheDatabase.Entry> speculativeDump = this.runner.create(Tasks.OPTIMISTIC_DUMP, this::dumpWithCache, packageName, deviceSerial, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, new ApkDiffer()::specDiff, speculativeDump, newFiles);
        Predicate<String> filter = file -> file.startsWith("res") || file.startsWith("assets");
        Task<Map> extractedFiles = this.runner.create(Tasks.EXTRACT_APK_ENTRIES, new ApkEntryExtractor(filter)::extractFromDiffs, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, newFiles, diffs, restart);
        Task<DexComparator.ChangedClasses> changedClasses = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        OptimisticApkSwapper swapper = new OptimisticApkSwapper(this.installer, redefiners, argRestart, this.options, this.metrics);
        Task<OptimisticApkSwapper.OverlayUpdate> overlayUpdate = this.runner.create(Tasks.COLLECT_SWAP_DATA, OptimisticApkSwapper.OverlayUpdate::new, speculativeDump, changedClasses, extractedFiles);
        Task<OptimisticApkSwapper.SwapResult> swapResultTask = this.runner.create(Tasks.OPTIMISTIC_SWAP, swapper::optimisticSwap, packageName, pids, arch, overlayUpdate);
        TaskResult result = this.runner.run();
        result.getMetrics().forEach(this.metrics::add);
        if (!result.isSuccess()) {
            throw result.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        this.runner.create(Tasks.DEPLOY_CACHE_STORE, (serial, pkgName, files, swap) -> this.deployCache.store((String)serial, (String)pkgName, (List<Apk>)files, swap.overlayId), deviceSerial, packageName, newFiles, swapResultTask);
        this.runner.runAsync();
        Result deployResult = new Result();
        if (this.options.fastRestartOnSwapFail && !swapResultTask.get().hotswapSucceeded) {
            deployResult.needsRestart = true;
        }
        return deployResult;
    }

    private DeploymentCacheDatabase.Entry dumpWithCache(String packageName, String deviceSerial, List<Apk> apks) throws DeployerException {
        String serial = this.adb.getSerial();
        DeploymentCacheDatabase.Entry entry = this.deployCache.get(serial, packageName);
        if (entry != null && !entry.getOverlayId().isBaseInstall()) {
            return entry;
        }
        ApplicationDumper dumper = new ApplicationDumper(this.installer);
        List<Apk> deviceApks = dumper.dump(apks).apks;
        this.deployCache.store(serial, packageName, deviceApks, new OverlayId(deviceApks));
        return this.deployCache.get(serial, packageName);
    }

    public boolean supportsNewPipeline() {
        return this.options.useOptimisticSwap && this.adb.getVersion().getApiLevel() >= 30;
    }

    public static class Result {
        public boolean skippedInstall = false;
        public boolean needsRestart = false;
    }

    public static enum InstallMode {
        DELTA,
        DELTA_NO_SKIP,
        FULL;

    }

    static enum Tasks {
        CACHE,
        DUMP,
        DIFF,
        PREINSTALL,
        VERIFY,
        COMPARE,
        SWAP,
        PARSE_PATHS,
        PARSE_APP_IDS,
        DEPLOY_CACHE_STORE,
        OPTIMISTIC_DUMP,
        VERIFY_DUMP,
        EXTRACT_APK_ENTRIES,
        COLLECT_SWAP_DATA,
        OPTIMISTIC_SWAP,
        OPTIMISTIC_INSTALL,
        GET_PIDS,
        GET_ARCH,
        COMPUTE_FRESHINSTALL_OID;

    }
}

