/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.SdkConstants;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import com.android.tools.tracer.Trace;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkParser {
    public static final int EOCD_SIGNATURE = 101010256;
    private static final byte[] SIGNATURE_BLOCK_MAGIC = "APK Sig Block 42".getBytes();
    private static final long USHRT_MAX = 65535L;
    public static final int EOCD_SIZE = 22;

    public List<Apk> parsePaths(List<String> paths) throws DeployerException {
        ArrayList<Apk> arrayList;
        block9: {
            Trace ignored = Trace.begin((String)"parseApks");
            try {
                ArrayList<Apk> newFiles = new ArrayList<Apk>();
                for (String apkPath : paths) {
                    newFiles.add(this.parse(apkPath));
                }
                arrayList = newFiles;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw DeployerException.parseFailed(e.getMessage());
                }
            }
            ignored.close();
        }
        return arrayList;
    }

    public ApkDetails getApkDetails(String path) throws IOException {
        ApkDetails apkDetails;
        try (ZipFile zipFile = new ZipFile(path);){
            ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
            InputStream stream = zipFile.getInputStream(manifestEntry);
            apkDetails = this.parseManifest(stream);
        }
        return apkDetails;
    }

    private Apk parse(String apkPath) throws IOException, DeployerException {
        List<ZipUtils.ZipEntry> zipEntries;
        String digest;
        File file = new File(apkPath);
        String absolutePath = file.getAbsolutePath();
        try (RandomAccessFile raf = new RandomAccessFile(absolutePath, "r");
             FileChannel fileChannel = raf.getChannel();){
            ApkArchiveMap map = new ApkArchiveMap();
            ApkParser.findCDLocation(fileChannel, map);
            ApkParser.findSignatureLocation(fileChannel, map);
            digest = this.generateDigest(raf, map);
            zipEntries = this.readZipEntries(raf, map);
        }
        ApkDetails apkDetails = this.getApkDetails(absolutePath);
        Apk.Builder builder = Apk.builder().setName(apkDetails.fileName).setChecksum(digest).setPath(absolutePath).setPackageName(apkDetails.packageName).setTargetPackages(apkDetails.targetPackages).setIsolatedServices(apkDetails.isolatedServices);
        for (ZipUtils.ZipEntry entry : zipEntries) {
            Path path = Paths.get(entry.name, new String[0]);
            if (path.startsWith("lib")) {
                builder.addLibraryAbi(path.getName(1).toString());
            }
            builder.addApkEntry(entry);
        }
        return builder.build();
    }

    public static void findSignatureLocation(FileChannel channel, ApkArchiveMap map) {
        try {
            ByteBuffer signatureBlockMagicNumber = ByteBuffer.allocate(SIGNATURE_BLOCK_MAGIC.length);
            channel.read(signatureBlockMagicNumber, map.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length);
            signatureBlockMagicNumber.rewind();
            if (!signatureBlockMagicNumber.equals(ByteBuffer.wrap(SIGNATURE_BLOCK_MAGIC))) {
                return;
            }
            ByteBuffer sizeBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(sizeBuffer, map.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length - 8L);
            sizeBuffer.rewind();
            long lowerSignatureBlockSize = sizeBuffer.getLong();
            sizeBuffer.rewind();
            channel.read(sizeBuffer, map.cdOffset - 8L - lowerSignatureBlockSize);
            sizeBuffer.rewind();
            long upperSignatureBlocSize = sizeBuffer.getLong();
            if (lowerSignatureBlockSize != upperSignatureBlocSize) {
                return;
            }
            map.signatureBlockOffset = map.cdOffset - 8L - lowerSignatureBlockSize;
            map.signatureBlockSize = lowerSignatureBlockSize;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void findCDLocation(FileChannel channel, ApkArchiveMap map) throws IOException, DeployerException {
        long fileSize = channel.size();
        if (fileSize < 22L) {
            throw DeployerException.parseFailed("File is too small to be a valid zip file");
        }
        ByteBuffer eocdBuffer = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(eocdBuffer, fileSize - 22L);
        eocdBuffer.rewind();
        if (ApkParser.readEOCD(map, eocdBuffer)) {
            return;
        }
        ByteBuffer endofFileBuffer = ByteBuffer.allocate((int)Math.min(fileSize, 65557L)).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(endofFileBuffer, fileSize - (long)endofFileBuffer.capacity());
        endofFileBuffer.position(endofFileBuffer.capacity() - 22);
        while (!ApkParser.readEOCD(map, endofFileBuffer)) {
            if (endofFileBuffer.position() - 5 < 0) {
                throw DeployerException.parseFailed("Unable to find apk's ECOD signature");
            }
            endofFileBuffer.position(endofFileBuffer.position() - 5);
        }
        return;
    }

    private static boolean readEOCD(ApkArchiveMap map, ByteBuffer buffer) {
        if (buffer.getInt() != 101010256) {
            return false;
        }
        buffer.position(buffer.position() + 8);
        map.cdSize = ZipUtils.uintToLong(buffer.getInt());
        map.cdOffset = ZipUtils.uintToLong(buffer.getInt());
        return true;
    }

    private List<ZipUtils.ZipEntry> readZipEntries(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        ByteBuffer buffer;
        if (SdkConstants.currentPlatform() == 2) {
            byte[] cdContent = new byte[(int)map.cdSize];
            randomAccessFile.seek(map.cdOffset);
            randomAccessFile.readFully(cdContent);
            buffer = ByteBuffer.wrap(cdContent);
        } else {
            buffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, map.cdOffset, map.cdSize);
        }
        return ZipUtils.readZipEntries(buffer);
    }

    private String generateDigest(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        byte[] sigContent;
        if (map.signatureBlockOffset != -1L) {
            sigContent = new byte[(int)map.signatureBlockSize];
            randomAccessFile.seek(map.signatureBlockOffset);
            randomAccessFile.readFully(sigContent);
        } else {
            sigContent = new byte[(int)map.cdSize];
            randomAccessFile.seek(map.cdOffset);
            randomAccessFile.readFully(sigContent);
        }
        ByteBuffer buffer = ByteBuffer.wrap(sigContent);
        return ZipUtils.digest(buffer);
    }

    private ApkDetails parseManifest(InputStream decompressedManifest) throws IOException {
        BinaryResourceFile file = BinaryResourceFile.fromInputStream((InputStream)decompressedManifest);
        List chunks = file.getChunks();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("Invalid APK, empty manifest");
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            throw new IllegalArgumentException("APK manifest chunk[0] != XmlChunk");
        }
        String packageName = null;
        String splitName = null;
        int versionCode = 0;
        ArrayList<String> targetPackages = new ArrayList<String>();
        ArrayList<String> isolatedServices = new ArrayList<String>();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        for (Chunk chunk : xmlChunk.getChunks().values()) {
            if (!(chunk instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk startChunk = (XmlStartElementChunk)chunk;
            if (startChunk.getName().equals("manifest")) {
                for (XmlAttribute attribute : startChunk.getAttributes()) {
                    BinaryResourceValue value;
                    if (attribute.name().equals("split")) {
                        splitName = attribute.rawValue();
                    }
                    if (attribute.name().equals("package")) {
                        packageName = attribute.rawValue();
                    }
                    if (!attribute.name().equals("versionCode") || (value = attribute.typedValue()) == null) continue;
                    versionCode = value.data();
                }
            }
            if (startChunk.getName().equals("instrumentation")) {
                for (XmlAttribute attribute : startChunk.getAttributes()) {
                    if (!attribute.name().equals("targetPackage")) continue;
                    targetPackages.add(attribute.rawValue());
                }
            }
            if (!startChunk.getName().equals("service")) continue;
            String name = "";
            boolean isolatedProcess = false;
            for (XmlAttribute attribute : startChunk.getAttributes()) {
                if (attribute.name().equals("name")) {
                    name = attribute.rawValue();
                    continue;
                }
                if (!attribute.name().equals("isolatedProcess")) continue;
                isolatedProcess = attribute.typedValue().data() != 0;
            }
            if (!isolatedProcess) continue;
            isolatedServices.add(name);
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Package name was not found in manifest");
        }
        String apkFileName = splitName == null ? "base.apk" : "split_" + splitName + ".apk";
        return new ApkDetails(apkFileName, packageName, versionCode, targetPackages, isolatedServices);
    }

    public static class ApkDetails {
        public final int versionCode;
        public final String fileName;
        public final String packageName;
        public final List<String> targetPackages;
        public final List<String> isolatedServices;

        private ApkDetails(String fileName, String packageName, int versionCode, List<String> targetPackages, List<String> isolatedServices) {
            this.fileName = fileName;
            this.packageName = packageName;
            this.versionCode = versionCode;
            this.targetPackages = targetPackages;
            this.isolatedServices = isolatedServices;
        }
    }

    public static class ApkArchiveMap {
        public static final long UNINITIALIZED = -1L;
        long cdOffset = -1L;
        long cdSize = -1L;
        long signatureBlockOffset = -1L;
        long signatureBlockSize = -1L;
    }
}

