/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import com.android.tools.idea.protobuf.ByteString;
import com.android.zipflinger.ZipArchive;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;

public class ApkEntryExtractor {
    private final Predicate<String> filter;

    public ApkEntryExtractor() {
        this.filter = t -> true;
    }

    public ApkEntryExtractor(Predicate<String> filter) {
        this.filter = filter;
    }

    public SortedMap<ApkEntry, ByteString> extractFromDiffs(List<FileDiff> diffs) throws DeployerException {
        ArrayListMultimap entriesToExtract = ArrayListMultimap.create();
        diffs.stream().filter(this::shouldExtract).forEach(diff -> entriesToExtract.put((Object)diff.newFile.getApk(), (Object)diff.newFile));
        return this.extractFromApks((ArrayListMultimap<Apk, ApkEntry>)entriesToExtract);
    }

    public SortedMap<ApkEntry, ByteString> extractFromEntries(Collection<ApkEntry> entries) throws DeployerException {
        ArrayListMultimap entriesToExtract = ArrayListMultimap.create();
        entries.stream().filter(entry -> this.filter.test(entry.getName())).forEach(entry -> entriesToExtract.put((Object)entry.getApk(), entry));
        return this.extractFromApks((ArrayListMultimap<Apk, ApkEntry>)entriesToExtract);
    }

    private SortedMap<ApkEntry, ByteString> extractFromApks(ArrayListMultimap<Apk, ApkEntry> entriesToExtract) throws DeployerException {
        TreeMap<ApkEntry, ByteString> extracted = new TreeMap<ApkEntry, ByteString>(ApkEntryExtractor::compareApkEntries);
        for (Apk apk : entriesToExtract.keySet()) {
            this.extractFromApk(apk, entriesToExtract.get((Object)apk), extracted);
        }
        return extracted;
    }

    private void extractFromApk(Apk apk, List<ApkEntry> entries, Map<ApkEntry, ByteString> extracted) throws DeployerException {
        try (ZipArchive zip = new ZipArchive(new File(apk.path));){
            for (ApkEntry apkEntry : entries) {
                ByteBuffer content = zip.getContent(apkEntry.getName());
                if (content == null) {
                    throw DeployerException.entryNotFound(apkEntry.getName(), apk.path);
                }
                extracted.put(apkEntry, ByteString.copyFrom((ByteBuffer)content));
            }
        }
        catch (IOException io) {
            throw DeployerException.entryUnzipFailed(io);
        }
    }

    private boolean shouldExtract(FileDiff diff) {
        switch (diff.status) {
            case CREATED: 
            case MODIFIED: 
            case RESOURCE_NOT_IN_OVERLAY: {
                return this.filter.test(diff.newFile.getName());
            }
            case DELETED: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected diff status: " + (Object)((Object)diff.status));
    }

    private static int compareApkEntries(ApkEntry a, ApkEntry b) {
        return a.getQualifiedPath().compareTo(b.getQualifiedPath());
    }
}

