/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;

public class AdbInstallerChannelManager {
    private static final HashMap<String, SocketChannel> channels = new HashMap();
    private final ILogger logger;
    private final AdbInstaller.Mode mode;

    AdbInstallerChannelManager(ILogger logger, AdbInstaller.Mode mode) {
        this.logger = logger;
        this.mode = mode;
    }

    public synchronized SocketChannel getChannel(AdbClient client, String version) throws IOException {
        String deviceId = client.getSerial();
        if (!channels.containsKey(deviceId)) {
            this.logger.info("Created SocketChannel to '" + deviceId + "'", new Object[0]);
            SocketChannel channel = this.createChannel(client, version);
            channels.put(deviceId, channel);
        }
        return channels.get(deviceId);
    }

    private synchronized SocketChannel createChannel(AdbClient client, String version) throws IOException {
        AbstractInterruptibleChannel channel = null;
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-version=" + version);
        if (this.mode == AdbInstaller.Mode.DAEMON) {
            parameters.add("-daemon");
        }
        try {
            channel = client.rawExec("/data/local/tmp/.studio/bin/installer", parameters.toArray(new String[0]));
        }
        catch (AdbCommandRejectedException | TimeoutException e) {
            AbstractInterruptibleChannel c = channel;
            if (c != null) {
                c.close();
            }
            throw new IOException(e);
        }
        ((AbstractSelectableChannel)channel).configureBlocking(true);
        return channel;
    }

    public synchronized void reset(AdbClient client) throws IOException {
        String serial = client.getSerial();
        this.logger.info("Reset SocketChannel to '" + serial + "'", new Object[0]);
        try (SocketChannel c = channels.get(serial);){
            channels.remove(serial);
        }
    }
}

