/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstallerChannelManager;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.Version;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.CodedOutputStream;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class AdbInstaller
implements Installer {
    public static final String INSTALLER_BINARY_NAME = "installer";
    public static final String INSTALLER_PATH = "/data/local/tmp/.studio/bin/installer";
    public static final String ANDROID_EXECUTABLE_PATH = "/tools/base/deploy/installer/android-installer";
    private final AdbClient adb;
    private final String installersFolder;
    private final Collection<DeployMetric> metrics;
    private final ILogger logger;
    private static final byte[] MAGIC_NUMBER = new byte[]{-84, -91, -84, -91, -84, -91, -84, -91};
    private final AdbInstallerChannelManager channelsProvider;
    private final Mode mode;

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger) {
        this(installersFolder, adb, metrics, logger, Mode.ONE_SHOT);
    }

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger, Mode mode) {
        this.adb = adb;
        this.installersFolder = installersFolder;
        this.metrics = metrics;
        this.logger = logger;
        this.channelsProvider = new AdbInstallerChannelManager(logger, mode);
        this.mode = mode;
    }

    private void logEvents(List<Deploy.Event> events) {
        for (Deploy.Event event : events) {
            this.logger.info(event.getTimestampNs() / 1000000L + "ms " + event.getType() + " [" + event.getPid() + "][" + event.getTid() + "] : " + event.getText(), new Object[0]);
        }
    }

    @Override
    public Deploy.DumpResponse dump(List<String> packageNames) throws IOException {
        Deploy.DumpRequest.Builder dumpRequestBuilder = Deploy.DumpRequest.newBuilder();
        for (String packageName : packageNames) {
            dumpRequestBuilder.addPackageNames(packageName);
        }
        Deploy.InstallerRequest.Builder request = this.buildRequest("dump").setDumpRequest(dumpRequestBuilder);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.DumpResponse response = installerResponse.getDumpResponse();
        this.logger.verbose("installer dump: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.SwapResponse swap(Deploy.SwapRequest swapRequest) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("swap");
        request.setSwapRequest(swapRequest);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.SwapResponse response = installerResponse.getSwapResponse();
        this.logger.verbose("installer swap: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.SwapResponse overlaySwap(Deploy.OverlaySwapRequest overlaySwapRequest) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("overlayswap");
        request.setOverlaySwapRequest(overlaySwapRequest);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.SwapResponse response = installerResponse.getSwapResponse();
        this.logger.verbose("installer overlayswap: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.OverlayInstallResponse overlayInstall(Deploy.OverlayInstallRequest overlayInstallRequest) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("overlayinstall");
        request.setOverlayInstall(overlayInstallRequest);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.OverlayInstallResponse response = installerResponse.getOverlayInstallResponse();
        this.logger.verbose("installer overlayinstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.OverlayIdPushResponse verifyOverlayId(String packageName, String oid) throws IOException {
        Deploy.OverlayIdPush overlayIdPushRequest = AdbInstaller.createOidPushRequest(packageName, oid, oid, false);
        Deploy.InstallerRequest.Builder request = this.buildRequest("overlayidpush");
        request.setOverlayIdPush(overlayIdPushRequest);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.OverlayIdPushResponse response = installerResponse.getOverlayidpushResponse();
        this.logger.verbose("installer overlayidpush: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    private static Deploy.OverlayIdPush createOidPushRequest(String packageName, String prevOid, String nextOid, boolean wipeOverlays) {
        return Deploy.OverlayIdPush.newBuilder().setPackageName(packageName).setPrevOid(prevOid).setNextOid(nextOid).setWipeOverlays(wipeOverlays).build();
    }

    @Override
    public Deploy.DeltaPreinstallResponse deltaPreinstall(Deploy.InstallInfo info) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("deltapreinstall");
        request.setInstallInfoRequest(info);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.DeltaPreinstallResponse response = installerResponse.getDeltapreinstallResponse();
        this.logger.verbose("installer deltapreinstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.DeltaInstallResponse deltaInstall(Deploy.InstallInfo info) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("deltainstall");
        request.setInstallInfoRequest(info);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.DeltaInstallResponse response = installerResponse.getDeltainstallResponse();
        this.logger.verbose("installer deltainstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.LiveLiteralUpdateResponse updateLiveLiterals(Deploy.LiveLiteralUpdateRequest liveLiterals) throws IOException {
        Deploy.InstallerRequest.Builder request = this.buildRequest("liveliteralupdate");
        request.setLiveLiteralRequest(liveLiterals);
        Deploy.InstallerResponse installerResponse = this.sendInstallerRequest(request.build());
        Deploy.LiveLiteralUpdateResponse response = installerResponse.getLiveLiteralResponse();
        this.logger.verbose("installer liveliteralupdate: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest request) throws IOException {
        return this.sendInstallerRequest(request, 5L, AdbClient.DEFAULT_TIMEUNIT);
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest request, long timeOut, TimeUnit timeUnit) throws IOException {
        Trace.begin((String)("./installer " + request.getCommandName()));
        long start = System.nanoTime();
        Deploy.InstallerResponse response = this.sendInstallerRequest(request, OnFail.RETRY, timeOut, timeUnit);
        this.logEvents(response.getEventsList());
        long end = System.nanoTime();
        long maxNs = Long.MIN_VALUE;
        long minNs = Long.MAX_VALUE;
        for (Deploy.Event event : response.getEventsList()) {
            maxNs = Math.max(maxNs, event.getTimestampNs());
            minNs = Math.min(minNs, event.getTimestampNs());
        }
        long delta = (maxNs + minNs - (end + start)) / 2L;
        Stack<Deploy.Event> eventStack = new Stack<Deploy.Event>();
        for (Deploy.Event event : response.getEventsList()) {
            switch (event.getType()) {
                case TRC_BEG: 
                case TRC_METRIC: {
                    Trace.begin((long)event.getPid(), (long)event.getTid(), (long)(event.getTimestampNs() - delta), (String)event.getText());
                    eventStack.push(event);
                    break;
                }
                case TRC_END: {
                    Deploy.Event begin;
                    Trace.end((long)event.getPid(), (long)event.getTid(), (long)(event.getTimestampNs() - delta));
                    if (eventStack.empty() || (begin = (Deploy.Event)eventStack.pop()).getType() != Deploy.Event.Type.TRC_METRIC) break;
                    long startMs = begin.getTimestampNs() - delta;
                    long endMs = event.getTimestampNs() - delta;
                    this.metrics.add(new DeployMetric(begin.getText(), startMs, endMs));
                    break;
                }
            }
        }
        Trace.end();
        return response;
    }

    private Deploy.InstallerResponse sendInstallerRequest(Deploy.InstallerRequest installerRequest, OnFail onFail, long timeOut, TimeUnit timeUnit) throws IOException {
        ByteBuffer request = this.wrap(installerRequest);
        Deploy.InstallerResponse response = null;
        SocketChannel channel = this.channelsProvider.getChannel(this.adb, this.getVersion());
        if (this.writeRequest(channel, request, timeOut, timeUnit)) {
            response = this.readResponse(channel, timeOut, timeUnit);
        }
        if (response == null) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Invalid installer response");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(installerRequest, OnFail.DO_NO_RETRY, timeOut, timeUnit);
        }
        if (response.getStatus() == Deploy.InstallerResponse.Status.ERROR_WRONG_VERSION) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Unrecoverable installer WRONG_VERSION error. Aborting");
            }
            this.channelsProvider.reset(this.adb);
            this.prepare();
            return this.sendInstallerRequest(installerRequest, OnFail.DO_NO_RETRY, timeOut, timeUnit);
        }
        if (this.mode == Mode.ONE_SHOT) {
            this.channelsProvider.reset(this.adb);
        }
        return response;
    }

    private boolean writeRequest(SocketChannel channel, ByteBuffer request, long timeOut, TimeUnit timeUnit) {
        try {
            channel.write(request);
        }
        catch (IOException e) {
            return false;
        }
        return request.remaining() == 0;
    }

    private Deploy.InstallerResponse readResponse(SocketChannel channel, long timeOut, TimeUnit timeUnit) {
        try {
            ByteBuffer bufferMarker = ByteBuffer.allocate(MAGIC_NUMBER.length);
            if (!AdbInstaller.readIntoBuffer(channel, bufferMarker)) {
                return null;
            }
            if (!Arrays.equals(MAGIC_NUMBER, bufferMarker.array())) {
                String garbage = new String(bufferMarker.array(), Charsets.UTF_8);
                this.logger.info("Read '" + garbage + "' from socket", new Object[0]);
                return null;
            }
            ByteBuffer bufferSize = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            if (!AdbInstaller.readIntoBuffer(channel, bufferSize)) {
                return null;
            }
            bufferSize.rewind();
            int responseSize = bufferSize.getInt();
            if (responseSize < 0) {
                return null;
            }
            ByteBuffer bufferPayload = ByteBuffer.allocate(responseSize);
            if (!AdbInstaller.readIntoBuffer(channel, bufferPayload)) {
                return null;
            }
            return this.unwrap(bufferPayload);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean readIntoBuffer(SocketChannel channel, ByteBuffer buffer) throws IOException {
        int read;
        while (buffer.remaining() != 0 && (read = channel.read(buffer)) != -1) {
        }
        return buffer.remaining() == 0;
    }

    private void prepare() throws IOException {
        File installerFile = null;
        List<String> abis = this.adb.getAbis();
        for (String abi : abis) {
            String installerJarPath = abi + "/" + INSTALLER_BINARY_NAME;
            InputStream inputStream = this.getResource(installerJarPath);
            try {
                if (inputStream == null) continue;
                this.logger.info("Pushed installer '" + installerJarPath + "'", new Object[0]);
                installerFile = File.createTempFile(".studio_installer", abi);
                Files.copy(inputStream, Paths.get(installerFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (installerFile == null) {
            throw new IOException("Unsupported abis: " + Arrays.toString(abis.toArray()));
        }
        this.cleanAndPushInstaller(installerFile);
        installerFile.delete();
    }

    private void cleanAndPushInstaller(File installerFile) throws IOException {
        this.runShell(new String[]{"rm", "-fr", "/data/local/tmp/.studio/bin", "/data/local/tmp/.studio/tmp"});
        this.runShell(new String[]{"mkdir", "-p", "/data/local/tmp/.studio/bin", "/data/local/tmp/.studio/tmp"});
        this.adb.push(installerFile.getAbsolutePath(), INSTALLER_PATH);
        this.runShell(new String[]{"chmod", "+x", INSTALLER_PATH});
    }

    private void runShell(String[] cmd) throws IOException {
        byte[] response = this.adb.shell(cmd);
        if (response.length <= 0) {
            return;
        }
        String extraMsg = new String(response, Charsets.UTF_8).trim();
        String error = String.format("Cannot '%s' : '%s'", String.join((CharSequence)" ", cmd), extraMsg);
        this.logger.error(null, error, new Object[0]);
        throw new IOException(error);
    }

    private InputStream getResource(String path) throws FileNotFoundException {
        InputStream stream = this.installersFolder == null ? Installer.class.getResourceAsStream("/tools/base/deploy/installer/android-installer/" + path) : new FileInputStream(this.installersFolder + "/" + path);
        return stream;
    }

    private Deploy.InstallerResponse unwrap(ByteBuffer buffer) {
        buffer.rewind();
        try {
            CodedInputStream cis = CodedInputStream.newInstance((ByteBuffer)buffer);
            return (Deploy.InstallerResponse)Deploy.InstallerResponse.parser().parseFrom(cis);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteBuffer wrap(Deploy.InstallerRequest message) {
        int messageSize = message.getSerializedSize();
        int headerSize = MAGIC_NUMBER.length + 4;
        byte[] buffer = new byte[headerSize + messageSize];
        ByteBuffer headerWriter = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
        headerWriter.put(MAGIC_NUMBER);
        headerWriter.putInt(messageSize);
        try {
            CodedOutputStream cos = CodedOutputStream.newInstance((byte[])buffer, (int)headerSize, (int)messageSize);
            message.writeTo(cos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ByteBuffer.wrap(buffer);
    }

    @VisibleForTesting
    public String getVersion() {
        return Version.hash();
    }

    private Deploy.InstallerRequest.Builder buildRequest(String commandName) {
        Deploy.InstallerRequest.Builder request = Deploy.InstallerRequest.newBuilder().setCommandName(commandName).setVersion(this.getVersion());
        return request;
    }

    public static enum Mode {
        DAEMON,
        ONE_SHOT;

    }

    private static enum OnFail {
        RETRY,
        DO_NO_RETRY;

    }
}

