/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow;

import com.intellij.ProjectTopics;
import com.intellij.beanValidation.BVCoreIcons;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.toolWindow.tree.BVTreeStructure;
import com.intellij.beanValidation.toolWindow.tree.actions.NodeTypesToggleAction;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVNodeTypes;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVNodesConfig;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BeanValidationView
extends SimpleToolWindowPanel
implements Disposable {
    @NonNls
    public static final String BEAN_VALIDATION_VIEW = "Bean_Validation_Tool_Window";
    private final Project myProject;
    private final BVNodesConfig myNodesConfig = new BVNodesConfig();
    private final Tree myTree;
    private final StructureTreeModel myModel;
    public static final Topic<Listener> TOPIC = new Topic("Bean Tree Changes", Listener.class);

    public BeanValidationView(Project project) {
        super(true, true);
        this.myProject = project;
        this.myTree = new Tree();
        this.myTree.setRootVisible(false);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Object[] nodes;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nodes = BeanValidationView.this.myTree.getSelectedNodes(Object.class, null)).length == 1) {
                    Navigatable navigatable = ((AbstractBVNode)((Object)((DefaultMutableTreeNode)BeanValidationView.this.myTree.getSelectedNodes(Object.class, null)[0]).getUserObject())).getNavigatableElement();
                    if (navigatable != null) {
                        navigatable.navigate(true);
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/beanValidation/toolWindow/BeanValidationView$1", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        BVTreeStructure structure = new BVTreeStructure(this.myProject, this.myNodesConfig);
        this.myModel = new StructureTreeModel((AbstractTreeStructure)structure, (Disposable)this);
        this.myTree.setModel((TreeModel)new AsyncTreeModel((TreeModel)this.myModel, (Disposable)this));
        this.initComponents();
        this.initListeners();
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(TOPIC, () -> this.myModel.invalidate());
    }

    private void initComponents() {
        this.setToolbar(this.createToolbar());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
    }

    private JComponent createToolbar() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, this.myNodesConfig, BVNodeTypes.CONSTRAINTS, BVBundle.message("actions.show.constraints", new Object[0]), BVCoreIcons.Constraints));
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, this.myNodesConfig, BVNodeTypes.VALIDATORS, BVBundle.message("actions.show.validators", new Object[0]), BVCoreIcons.ConstraintValidator));
        actions.add((AnAction)new NodeTypesToggleAction(this.myProject, this.myNodesConfig, BVNodeTypes.CONSTRAINT_MAPPINGS, BVBundle.message("xml.defined.constraints", new Object[0]), BVCoreIcons.ConstraintMappings));
        actions.addSeparator();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BeanValidation", (ActionGroup)actions, true);
        toolbar.setTargetComponent((JComponent)((Object)this));
        return toolbar.getComponent();
    }

    private void initListeners() {
        PsiModificationTracker.Listener modificationHandler = this::updateTree;
        ModuleRootListener moduleRootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                BeanValidationView.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/beanValidation/toolWindow/BeanValidationView$2", "rootsChanged"));
            }
        };
        ModuleListener moduleListener = new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                BeanValidationView.this.updateTree();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(3);
                }
                BeanValidationView.this.updateTree();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    3.$$$reportNull$$$0(6);
                }
                BeanValidationView.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/beanValidation/toolWindow/BeanValidationView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)modificationHandler);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)moduleRootListener);
        connection.subscribe(ProjectTopics.MODULES, (Object)moduleListener);
    }

    private void updateTree() {
        this.myModel.invalidate();
    }

    public void dispose() {
    }

    public Object getData(@NotNull @NonNls String dataId) {
        Set set;
        Object data;
        if (dataId == null) {
            BeanValidationView.$$$reportNull$$$0(0);
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return BEAN_VALIDATION_VIEW;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null && !(set = Stream.of(paths).map(TreeUtil::getLastUserObject).collect(Collectors.toSet())).isEmpty()) {
            Object nodeDescriptor = set.iterator().next();
            if (!(nodeDescriptor instanceof AbstractBVNode)) {
                return null;
            }
            AbstractBVNode node = (AbstractBVNode)((Object)nodeDescriptor);
            PsiElement element = node.getPsiElement();
            Navigatable navigatable = node.getNavigatableElement();
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && navigatable != null) {
                return navigatable;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/beanValidation/toolWindow/BeanValidationView", "getData"));
    }

    public static interface Listener {
        public void settingsChanged();
    }
}

