/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.checkers.CheckAnnotationIsConstraint;
import com.intellij.beanValidation.highlighting.checkers.CheckClassIsConstraintAnnotation;
import com.intellij.beanValidation.highlighting.checkers.CheckMissingParameters;
import com.intellij.beanValidation.model.xml.BvMappingsDomElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class BvConstraintMappingsInspection
extends BasicDomElementsInspection<BvMappingsDomElement> {
    private static final HashMap<String, BvChecker[]> CHECKERS = new HashMap();

    private static void register(String key, BvChecker ... checkers) {
        CHECKERS.put(key, checkers);
    }

    public BvConstraintMappingsInspection() {
        super(BvMappingsDomElement.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue value;
        String checkerId;
        BvChecker[] checkers;
        super.checkDomElement(element, holder, helper);
        if (element instanceof GenericDomValue && (checkers = CHECKERS.get(checkerId = BvConstraintMappingsInspection.getCheckerId(value = (GenericDomValue)element))) != null) {
            for (BvChecker checker : checkers) {
                checker.check(value, holder);
            }
        }
    }

    private static String getCheckerId(@NotNull GenericDomValue value) {
        DomElement parent;
        if (value == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(0);
        }
        return (parent = value.getParent()) == null ? value.getXmlElementName() : parent.getXmlElementName() + "/" + value.getXmlElementName();
    }

    static {
        BvConstraintMappingsInspection.register("constraint/annotation", new CheckClassIsConstraintAnnotation(), new CheckMissingParameters());
        BvConstraintMappingsInspection.register("element/name", new CheckAnnotationIsConstraint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection", "getCheckerId"));
    }
}

