/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.gradle.javaee;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JavaUltimateIcons;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;

final class GradleWebFrameworkSupportProvider
extends GradleFrameworkSupportProvider {
    private static final Logger LOG = Logger.getInstance(GradleWebFrameworkSupportProvider.class);
    public static final String ID = "web";

    GradleWebFrameworkSupportProvider() {
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return new FrameworkTypeEx(ID){

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                GradleWebFrameworkSupportProvider gradleWebFrameworkSupportProvider = GradleWebFrameworkSupportProvider.this;
                if (gradleWebFrameworkSupportProvider == null) {
                    1.$$$reportNull$$$0(0);
                }
                return gradleWebFrameworkSupportProvider;
            }

            @NotNull
            @NonNls
            public String getPresentableName() {
                return "Web";
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = JavaUltimateIcons.Web.WebModule;
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/javaee/gradle/javaee/GradleWebFrameworkSupportProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProvider";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public void addSupport(@NotNull ProjectId projectId, @NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        if (projectId == null) {
            GradleWebFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GradleWebFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        if (rootModel == null) {
            GradleWebFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        if (modifiableModelsProvider == null) {
            GradleWebFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        if (buildScriptData == null) {
            GradleWebFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        buildScriptData.addPluginDefinitionInPluginsGroup("id 'war'").addRepositoriesDefinition("mavenCentral()").addDependencyNotation("testImplementation 'junit:junit:4.11'");
        String webRootPath = buildScriptData.getBuildScriptFile().getParent().getPath() + "/src/main/webapp";
        try {
            File ioFile = new File(FileUtil.toSystemDependentName((String)webRootPath), "index.jsp");
            if (ioFile.exists()) {
                return;
            }
            FileUtil.createIfDoesntExist((File)ioFile);
            VirtualFile indexFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            Project project = module.getProject();
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("Jsp File.jsp");
            assert (indexFile != null);
            VfsUtil.saveText((VirtualFile)indexFile, (String)fileTemplate.getText(FileTemplateManager.getInstance((Project)project).getDefaultProperties()));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "projectId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "rootModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "modifiableModelsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "buildScriptData";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/gradle/javaee/GradleWebFrameworkSupportProvider";
        objectArray[2] = "addSupport";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

