/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.gradle.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetConfiguration;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetType;
import com.intellij.javaee.application.model.xml.application.JavaeeApplication;
import com.intellij.javaee.application.model.xml.application.JavaeeModule;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.gradle.GradleArtifactProperties;
import com.intellij.javaee.gradle.GradleArtifactPropertiesProvider;
import com.intellij.javaee.gradle.JavaeeProjectDataService;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.Jar;

@Order(value=1000)
final class EarModuleGradleDataService
extends JavaeeProjectDataService<EarConfigurationModelData, JavaeeApplicationFacet, JavaeeApplicationFacetConfiguration, JavaeeApplicationFacetType> {
    EarModuleGradleDataService() {
        super(JavaeeApplicationFacetType.getInstance());
    }

    @NotNull
    public Key<EarConfigurationModelData> getTargetDataKey() {
        Key key = EarConfigurationModelData.KEY;
        if (key == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    protected void configureJavaeeModule(@NotNull ModuleData moduleData, @NotNull EarConfigurationModelData javaeeData, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module;
        if (moduleData == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(1);
        }
        if (javaeeData == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(3);
        }
        if ((module = modelsProvider.findIdeModule(moduleData)) != null) {
            if (this.isFacetDetectionDisabled(module.getProject())) {
                return;
            }
            JavaeeApplicationFacetType javaeeFacetType = (JavaeeApplicationFacetType)this.getJavaeeFacetType();
            String facetNamePrefix = this.getFacetNamePrefix((FacetType<?, ?>)javaeeFacetType);
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Collection javaeeApplicationFacets = facetModel.getFacetsByType(javaeeFacetType.getId());
            for (JavaeeApplicationFacet facet : javaeeApplicationFacets) {
                if (!facet.getName().startsWith(facetNamePrefix)) continue;
                facetModel.removeFacet((Facet)facet);
            }
            for (Ear ear : javaeeData.getArtifacts()) {
                LibraryData libraryData;
                Object moduleArchiveName;
                ModuleData moduleDependencyData;
                ArrayList<ApplicationXmlAppender> appenders = new ArrayList<ApplicationXmlAppender>();
                String facetName = this.adjustName(facetNamePrefix, ear.getName());
                JavaeeApplicationFacet javaeeApplicationFacet = (JavaeeApplicationFacet)this.createOrReplaceFacet(facetModel, module, facetName, javaeeFacetType);
                String explodedArtifactName = this.resolveArtifactName(moduleData, ear.getName(), true);
                ModifiableArtifact explodedArtifact = this.prepareArtifact(modelsProvider, module, explodedArtifactName, (Jar)ear, javaeeFacetType.getExplodedArtifactType());
                CompositePackagingElement rootElement = explodedArtifact.getRootElement();
                rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)javaeeApplicationFacet));
                PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
                Object appDirName = ear.getAppDirName();
                if (!new File((String)appDirName).isAbsolute()) {
                    appDirName = moduleData.getLinkedExternalProjectPath() + "/" + (String)appDirName;
                }
                String appDirPath = FileUtil.toSystemIndependentName((String)appDirName);
                rootElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(appDirPath, "/"));
                for (EarResource resource : ear.getResources()) {
                    String filePath;
                    if (!resource.getFile().isFile() || FileUtil.isAncestor((String)appDirPath, (String)(filePath = FileUtil.toSystemIndependentName((String)resource.getFile().getPath())), (boolean)true)) continue;
                    rootElement.addOrFindChild(packagingElementFactory.createFileCopyWithParentDirectories(filePath, resource.getEarDirectory(), new File(resource.getRelativePath()).getName()));
                }
                for (DependencyData dependencyData : javaeeData.getDeployDependencies()) {
                    if (dependencyData instanceof ModuleDependencyData) {
                        CompositePackagingElement moduleArchive;
                        moduleDependencyData = (ModuleData)dependencyData.getTarget();
                        boolean isWeb = false;
                        moduleArchiveName = null;
                        Collection dependencyArtifacts = ((ModuleDependencyData)dependencyData).getModuleDependencyArtifacts();
                        if (dependencyArtifacts != null) {
                            for (String path : dependencyArtifacts) {
                                if (FileUtilRt.extensionEquals((String)path, (String)"war") || FileUtilRt.extensionEquals((String)path, (String)"WAR")) {
                                    isWeb = true;
                                    moduleArchiveName = FileUtilRt.getNameWithoutExtension((String)new File(path).getName()) + ".war";
                                    break;
                                }
                                moduleArchiveName = FileUtilRt.getNameWithoutExtension((String)new File(path).getName()) + ".jar";
                            }
                        }
                        if (moduleArchiveName == null) {
                            moduleArchiveName = this.formatModuleArchiveFileName(moduleDependencyData);
                        }
                        Artifact webArtifactCandidate = null;
                        if (isWeb) {
                            String webArtifactNamePrefix = this.resolveArtifactName(moduleDependencyData, "", true);
                            String webArtifactName = this.resolveArtifactName(moduleDependencyData, (String)moduleArchiveName, true);
                            ModifiableArtifactModel artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel();
                            for (Artifact artifact : artifactModel.getArtifactsByType((ArtifactType)ExplodedWarArtifactType.getInstance())) {
                                if (webArtifactName.equals(artifact.getName())) {
                                    webArtifactCandidate = artifact;
                                    break;
                                }
                                if (!artifact.getName().startsWith(webArtifactNamePrefix)) continue;
                                webArtifactCandidate = artifact;
                            }
                        }
                        if (webArtifactCandidate == null) {
                            Module depModule = modelsProvider.findIdeModule(moduleDependencyData);
                            if (depModule == null) continue;
                            moduleArchive = packagingElementFactory.createDirectory((String)moduleArchiveName);
                            moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(depModule));
                            String moduleResourceOutputDir = moduleDependencyData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE);
                            if (StringUtil.isNotEmpty((String)moduleResourceOutputDir)) {
                                moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(moduleResourceOutputDir, "/"));
                            }
                            rootElement.addOrFindChild((PackagingElement)moduleArchive);
                        } else {
                            PackagingElement artifactElement = packagingElementFactory.createArtifactElement(webArtifactCandidate, module.getProject());
                            moduleArchive = packagingElementFactory.createDirectory((String)moduleArchiveName);
                            moduleArchive.addOrFindChild(artifactElement);
                            rootElement.addOrFindChild((PackagingElement)moduleArchive);
                        }
                        EarModuleGradleDataService.link((String)moduleArchiveName, isWeb, appenders);
                        continue;
                    }
                    if (!(dependencyData instanceof LibraryDependencyData)) continue;
                    libraryData = (LibraryData)dependencyData.getTarget();
                    Set libraryDataPaths = libraryData.getPaths(LibraryPathType.BINARY);
                    for (String libraryDataPath : libraryDataPaths) {
                        rootElement.addOrFindChild(packagingElementFactory.createFileCopy(libraryDataPath, null));
                    }
                }
                for (DependencyData dependencyData : javaeeData.getEarlibDependencies()) {
                    if (dependencyData instanceof ModuleDependencyData) {
                        moduleDependencyData = (ModuleData)dependencyData.getTarget();
                        Module depModule = modelsProvider.findIdeModule(moduleDependencyData);
                        if (depModule == null) continue;
                        moduleArchiveName = this.formatModuleArchiveFileName(moduleDependencyData);
                        CompositePackagingElement moduleArchive = packagingElementFactory.createArchive((String)moduleArchiveName);
                        moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(depModule));
                        String moduleResourceOutputDir = moduleDependencyData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE);
                        if (StringUtil.isNotEmpty((String)moduleResourceOutputDir)) {
                            moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(moduleResourceOutputDir, "/"));
                        }
                        packagingElementFactory.getOrCreateDirectory(rootElement, ear.getLibDirName()).addOrFindChild((PackagingElement)moduleArchive);
                        continue;
                    }
                    if (!(dependencyData instanceof LibraryDependencyData)) continue;
                    libraryData = (LibraryData)dependencyData.getTarget();
                    Set libraryDataPaths = libraryData.getPaths(LibraryPathType.BINARY);
                    for (String libraryDataPath : libraryDataPaths) {
                        packagingElementFactory.getOrCreateDirectory(rootElement, ear.getLibDirName()).addOrFindChild(packagingElementFactory.createFileCopy(libraryDataPath, null));
                    }
                }
                EarModuleGradleDataService.configureDescriptor(moduleData, module, ear, appenders, explodedArtifact, javaeeApplicationFacet);
                String artifactName = this.resolveArtifactName(moduleData, ear.getName(), false);
                ModifiableArtifact archiveArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)ear, javaeeFacetType.getArchiveArtifactType());
                PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)explodedArtifact, module.getProject());
                archiveArtifact.getRootElement().addOrFindChild(artifactElement);
            }
        }
    }

    private static void configureDescriptor(@NotNull ModuleData moduleData, Module module, Ear ear, List<ApplicationXmlAppender> appenders, ModifiableArtifact explodedArtifact, JavaeeApplicationFacet javaeeApplicationFacet) {
        ArtifactProperties<GradleArtifactProperties> artifactProperties;
        if (moduleData == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(4);
        }
        if ((artifactProperties = EarModuleGradleDataService.getGradleArtifactProperties((Artifact)explodedArtifact)) == null) {
            return;
        }
        String descriptorPath = (String)ObjectUtils.chooseNotNull((Object)explodedArtifact.getOutputPath(), (Object)(moduleData.getLinkedExternalProjectPath() + "build")) + "/META-INF/application.xml";
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> javaeeApplicationFacet.getDescriptorsContainer().getConfiguration().replaceConfigFile(DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA, VfsUtilCore.pathToUrl((String)descriptorPath)));
        Project project = module.getProject();
        GradleArtifactProperties gradleArtifactProperties = (GradleArtifactProperties)((Object)artifactProperties.getState());
        ConfigFile descriptor = javaeeApplicationFacet.getApplicationDescriptor();
        if (descriptor == null) {
            return;
        }
        String deploymentDescriptor = ear.getDeploymentDescriptor();
        ConfigFileMetaData metaData = DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA;
        String fileText = StringUtil.convertLineSeparators((String)deploymentDescriptor);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(metaData.getFileName(), (FileType)StdFileTypes.XML, (CharSequence)fileText);
            JavaeeApplication root = (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)psiFile, JavaeeApplication.class);
            if (root != null) {
                for (ApplicationXmlAppender appender : appenders) {
                    appender.append(root);
                }
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                HashMap<String, String> files = new HashMap<String, String>();
                String text = StringUtil.convertLineSeparators((String)psiFile.getText(), (String)System.lineSeparator());
                files.put(descriptorPath, Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8)));
                gradleArtifactProperties.setAdditionalFiles(files);
                explodedArtifact.setProperties((ArtifactPropertiesProvider)Objects.requireNonNull(GradleArtifactPropertiesProvider.getInstance()), artifactProperties);
            }
        });
    }

    private static void link(final String archiveName, final boolean isWeb, List<ApplicationXmlAppender> appenders) {
        appenders.add(new ApplicationXmlAppender(){

            @Override
            public void append(@NotNull JavaeeApplication root) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (JavaeeModule module : root.getModules()) {
                    String uri = isWeb ? (String)module.getWeb().getWebUri().getValue() : (String)module.getEjb().getValue();
                    if (uri == null || !uri.equals(archiveName)) continue;
                    return;
                }
                JavaeeModule module = root.addModule();
                (isWeb ? module.getWeb().getWebUri() : module.getEjb()).setValue((Object)archiveName);
                if (isWeb) {
                    module.getWeb().getContextRoot().setValue((Object)FileUtilRt.getNameWithoutExtension((String)archiveName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javaee/gradle/javaee/EarModuleGradleDataService$1", "append"));
            }
        });
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? JavaeeArtifactUtil.getInstance().getExplodedEarArtifactType() : JavaeeArtifactUtil.getInstance().getEarArtifactType();
    }

    @Override
    protected Collection<String> resolveArtifactNames(@NotNull ModuleData moduleData, @NotNull EarConfigurationModelData data) {
        if (moduleData == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(5);
        }
        if (data == null) {
            EarModuleGradleDataService.$$$reportNull$$$0(6);
        }
        SmartList names = new SmartList();
        for (Ear ear : data.getArtifacts()) {
            names.add(this.resolveArtifactName(moduleData, ear.getName(), false));
            names.add(this.resolveArtifactName(moduleData, ear.getName(), true));
        }
        return names;
    }

    private boolean isFacetDetectionDisabled(Project project) {
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector(this.getJavaeeFacetType());
        return frameworkType != null && DetectionExcludesConfiguration.getInstance((Project)project).isExcludedFromDetection(frameworkType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/gradle/javaee/EarModuleGradleDataService";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/gradle/javaee/EarModuleGradleDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureJavaeeModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ApplicationXmlAppender {
        public void append(@NotNull JavaeeApplication var1);
    }
}

