/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9.mbeansModel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class AbstractWL9MBean {
    private final ObjectName myBeanName;
    private final MBeanServerConnection myConnection;

    protected AbstractWL9MBean(MBeanServerConnection connection, ObjectName beanName) {
        this.myConnection = connection;
        this.myBeanName = beanName;
    }

    protected ObjectName getChild(String name) throws JMException, IOException {
        return (ObjectName)this.getAttribute(name);
    }

    protected ObjectName[] getChildren(String name) throws JMException, IOException {
        return (ObjectName[])this.getAttribute(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractWL9MBean)) {
            return false;
        }
        AbstractWL9MBean that = (AbstractWL9MBean)o;
        return this.myBeanName.equals(that.myBeanName);
    }

    public int hashCode() {
        return this.myBeanName.hashCode();
    }

    protected Object getAttribute(String attributeName) throws JMException, IOException {
        return this.myConnection.getAttribute(this.myBeanName, attributeName);
    }

    protected void setAttribute(String name, Object value) throws JMException, IOException {
        this.myConnection.setAttribute(this.myBeanName, new Attribute(name, value));
    }

    protected Object invoke(MethodSignature signature, Object ... params) throws JMException, IOException {
        return this.myConnection.invoke(this.myBeanName, signature.getName(), params, signature.getParameterTypes());
    }

    protected ObjectName getBeanName() {
        return this.myBeanName;
    }

    protected MBeanServerConnection getConnection() {
        return this.myConnection;
    }

    protected <T extends AbstractWL9MBean> List<T> getChildren(String name, WL9MBeanCreator<T> mBeanCreator) throws IOException, JMException {
        ObjectName[] children = this.getChildren(name);
        ArrayList<T> result = new ArrayList<T>(children.length);
        for (ObjectName child : children) {
            result.add(mBeanCreator.create(this.getConnection(), child));
        }
        return result;
    }

    protected static interface WL9MBeanCreator<T extends AbstractWL9MBean> {
        public T create(MBeanServerConnection var1, ObjectName var2);
    }

    protected static class MethodSignature {
        private final String myName;
        private final String[] myParamTypes;

        public MethodSignature(String name, Class ... paramTypeClasses) {
            this.myName = name;
            this.myParamTypes = new String[paramTypeClasses.length];
            for (int i = 0; i < paramTypeClasses.length; ++i) {
                this.myParamTypes[i] = paramTypeClasses[i].getName();
            }
        }

        public MethodSignature(String name, String ... paramTypes) {
            this.myName = name;
            this.myParamTypes = paramTypes;
        }

        public String getName() {
            return this.myName;
        }

        public String[] getParameterTypes() {
            return this.myParamTypes;
        }
    }
}

