/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.main;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapProcessor;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponentPartner;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class OpenSnapshotWorker
extends Task.Backgroundable {
    private final VirtualFile myFile;
    private final boolean myShowHiddenData;
    private V8CachingReader myCachingReader;

    private OpenSnapshotWorker(Project project, VirtualFile file, boolean showHiddenData) {
        super(project, NodeJSBundle.message("progress.title.processing.heap.snapshot", file.getName()), true, null);
        this.myFile = file;
        this.myShowHiddenData = showHiddenData;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void work(Project project, VirtualFile virtualFile, boolean bl) {
        Project project2;
        void showHiddenData;
        void file;
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            byte[] bytes = V8HeapIndexManager.snapshotDigest(new File(file.getPath()), (boolean)showHiddenData);
            if (bytes != null && V8HeapComponent.getInstance(project2).activateIfOpen(new ByteArrayWrapper(bytes))) {
                return;
            }
        }
        catch (IOException e) {
            OpenSnapshotWorker.createNotificator(project2).consume((Object)e.getMessage());
        }
        ProgressManager.getInstance().run((Task)new OpenSnapshotWorker(project2, (VirtualFile)file, (boolean)showHiddenData));
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            OpenSnapshotWorker.$$$reportNull$$$0(0);
        }
        try {
            V8HeapProcessor processor = new V8HeapProcessor(OpenSnapshotWorker.createNotificator(this.myProject), new File(this.myFile.getPath()), this.myShowHiddenData, indicator);
            this.myCachingReader = processor.getFromCacheOrProcess();
        }
        catch (IOException e1) {
            this.notifyOnException(e1);
        }
        catch (ClassNotFoundException e1) {
            this.notifyOnException(e1);
        }
    }

    @NotNull
    public static Consumer<String> createNotificator(Project project) {
        Consumer consumer = message -> NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.error.notification.content", message), MessageType.ERROR).notify(project);
        if (consumer == null) {
            OpenSnapshotWorker.$$$reportNull$$$0(1);
        }
        return consumer;
    }

    private void notifyOnException(Exception e1) {
        V8HeapProcessor.LOG.info((Throwable)e1);
        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.processing.snapshot.error.notification.content", e1.getMessage()), MessageType.ERROR).notify(this.myProject);
    }

    public void onSuccess() {
        if (this.myCachingReader != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                try {
                    String name = this.myFile.getName();
                    name = name.endsWith(".heapsnapshot") ? name.substring(0, name.length() - "heapsnapshot".length() - 1) : name;
                    V8HeapComponent.getInstance(this.myProject).showMe(this.myCachingReader.getDigest(), new V8HeapComponentPartner(this.myCachingReader, name), name, null);
                }
                catch (IOException e) {
                    this.notifyOnException(e);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/main/OpenSnapshotWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/main/OpenSnapshotWorker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

