/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.CommonBundle;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.CloseTabAction;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.NodeSurrounders;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.RetainersTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.SearchDetailsTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedNodesListNode;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import com.jetbrains.nodejs.util.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8MainTableWithRetainers<T extends TreeTableModelWithCustomRenderer> {
    @NotNull
    private final Project myProject;
    private final T myMainTreeModel;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final CompositeCloseable myCloseable;
    private final Runnable myRetainersUpdater;
    private V8MainTreeNavigator myMainTreeNavigator;
    private final JPanel myDetailsPanel;
    private RetainersTreeModel myRetainersTreeModel;
    private final JBSplitter myMainSplitter;
    private final V8HeapTreeTable myTable;
    private final ZipperUpdater myUpdater;
    private final AtomicReference<Pair<Pair<V8HeapEntry, V8HeapEdge>, TreePath>> myMainSelection;
    private final AtomicReference<NodeSurrounders> myLastCalculatedSelectionValue;
    private final JBSplitter mySecondSplitter;
    private final JBTabs myDetails;
    private boolean myUseTreeSelectionForRetainers;

    public V8MainTableWithRetainers(@NotNull Project project, @NotNull T mainTreeModel, @NotNull V8CachingReader reader, @NotNull CompositeCloseable closeable, @NotNull Disposable disposable) {
        if (project == null) {
            V8MainTableWithRetainers.$$$reportNull$$$0(0);
        }
        if (mainTreeModel == null) {
            V8MainTableWithRetainers.$$$reportNull$$$0(1);
        }
        if (reader == null) {
            V8MainTableWithRetainers.$$$reportNull$$$0(2);
        }
        if (closeable == null) {
            V8MainTableWithRetainers.$$$reportNull$$$0(3);
        }
        if (disposable == null) {
            V8MainTableWithRetainers.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myMainTreeModel = mainTreeModel;
        this.myReader = reader;
        this.myCloseable = closeable;
        this.myUseTreeSelectionForRetainers = true;
        this.myUpdater = new ZipperUpdater(300, disposable);
        closeable.register(new Closeable(){

            @Override
            public void close() {
                V8MainTableWithRetainers.this.myUpdater.stop();
            }
        });
        this.myTable = V8Utils.createTable(project, this.myMainTreeModel, this.myReader);
        TreeTableSpeedSearch search = new TreeTableSpeedSearch((TreeTable)this.myTable, o -> {
            Object component = o.getLastPathComponent();
            if (component instanceof Aggregate) {
                return ((Aggregate)component).getPresentation(this.myReader);
            }
            return component.toString();
        });
        search.setComparator(new SpeedSearchComparator(false, true));
        this.myDetails = JBRunnerTabs.create((Project)project, (Disposable)disposable);
        this.myDetailsPanel = new JPanel(new BorderLayout());
        this.myDetails.addTab(new TabInfo((JComponent)this.myDetailsPanel).setText(NodeJSBundle.message("profile.cpu.main_table.details.text", new Object[0])));
        this.updateDetails(UIHelper.wrapInCenteredPanel(NodeJSBundle.message("profile.cpu.nothing_to_show.label", new Object[0])));
        this.myMainSplitter = new JBSplitter(false);
        this.mySecondSplitter = new JBSplitter(true);
        this.mySecondSplitter.setFirstComponent((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        this.mySecondSplitter.setSecondComponent(this.myDetails.getComponent());
        this.myMainSplitter.setFirstComponent((JComponent)this.mySecondSplitter);
        this.myMainSelection = new AtomicReference();
        this.myLastCalculatedSelectionValue = new AtomicReference();
        final ThreadPoolExecutor threadExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"V8 calculate retainers");
        closeable.register(new Closeable(){

            @Override
            public void close() {
                threadExecutor.shutdownNow();
            }
        });
        this.myRetainersUpdater = () -> {
            if (this.myLastCalculatedSelectionValue.get() != null && this.myMainSelection.get() != null && Comparing.equal(this.myLastCalculatedSelectionValue.get().getNodeId(), (Object)((Pair)this.myMainSelection.get().getFirst()))) {
                this.updateRetainersView();
                return;
            }
            threadExecutor.execute(() -> this.calculateRetainers());
        };
        this.mainTableSelectionListener();
        this.myMainTreeNavigator = new MyV8MainTreeNavigator(project);
    }

    private void updateDetails(JComponent component) {
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)component, "Center");
        this.myDetailsPanel.revalidate();
        this.myDetailsPanel.repaint();
    }

    public void addTab(@NlsContexts.TabTitle String text, JComponent component, DefaultActionGroup group, boolean selectTab) {
        CloseTabAction action = new CloseTabAction(this.myDetails);
        group.add((AnAction)action);
        TabInfo info = this.addTabWithoutClose(text, component, group, selectTab);
        action.setInfo(info);
    }

    public TabInfo addTabWithoutClose(@NlsContexts.TabTitle String text, JComponent component, DefaultActionGroup group, boolean selectTab) {
        JComponent wrapper = V8Utils.wrapWithActions(component, group);
        TabInfo info = new TabInfo(wrapper).setText(text);
        this.myDetails.addTab(info);
        if (selectTab) {
            this.myDetails.select(info, true);
        }
        return info;
    }

    public V8MainTreeNavigator getMainTreeNavigator() {
        return this.myMainTreeNavigator;
    }

    public JBSplitter getMainSplitter() {
        return this.myMainSplitter;
    }

    public V8HeapTreeTable getTable() {
        return this.myTable;
    }

    public T getMainTreeModel() {
        return this.myMainTreeModel;
    }

    public RetainersTreeModel getRetainersTreeModel() {
        return this.myRetainersTreeModel;
    }

    private void calculateRetainers() {
        Pair<Pair<V8HeapEntry, V8HeapEdge>, TreePath> selection = this.myMainSelection.get();
        if (this.myLastCalculatedSelectionValue.get() != null && Comparing.equal(this.myLastCalculatedSelectionValue.get().getNodeId(), (Object)((Pair)selection.getFirst()))) {
            return;
        }
        V8HeapEntry selectedEntry = (V8HeapEntry)((Pair)selection.getFirst()).getFirst();
        int count = this.myReader.getRetainersCount(selectedEntry);
        ArrayList<Pair<V8HeapEntry, V8HeapEdge>> retainers = new ArrayList<Pair<V8HeapEntry, V8HeapEdge>>();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                Pair<V8HeapEntry, V8HeapEdge> childPair = this.myReader.getRetainerChild(selectedEntry, i);
                if (!this.myReader.isShowHidden() && (V8HeapNodeType.kHidden.equals((Object)((V8HeapEntry)childPair.getFirst()).getType()) || V8HeapGraphEdgeType.kHidden.equals((Object)((V8HeapEdge)childPair.getSecond()).getType()))) continue;
                retainers.add(childPair);
            }
        }
        this.myLastCalculatedSelectionValue.set(new NodeSurrounders((Pair<V8HeapEntry, V8HeapEdge>)((Pair)selection.getFirst()), selection.getSecond() == null ? null : ((TreePath)selection.getSecond()).getPath(), retainers));
        this.updateRetainersView();
    }

    private void updateRetainersView() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Pair realRoot;
            NodeSurrounders surrounders = this.myLastCalculatedSelectionValue.get();
            if (surrounders == null) {
                return;
            }
            Pair pair = realRoot = this.myRetainersTreeModel == null ? null : Pair.create((Object)this.myRetainersTreeModel.getMain(), (Object)this.myRetainersTreeModel.getMainEdge());
            if (realRoot != null && Comparing.equal(surrounders.getNodeId(), (Object)realRoot)) {
                return;
            }
            if (this.myMainSelection.get() == null || !Comparing.equal((Object)((Pair)this.myMainSelection.get().getFirst()), surrounders.getNodeId())) {
                return;
            }
            this.myRetainersTreeModel = new RetainersTreeModel(this.myProject, this.myReader, (V8HeapEntry)surrounders.getNodeId().getFirst(), (V8HeapEdge)surrounders.getNodeId().getSecond(), surrounders.getRetainers(), surrounders.getPathToRoot());
            final V8HeapTreeTable retainersTable = new V8HeapTreeTable((TreeTableModel)this.myRetainersTreeModel, this.myReader.getResourses());
            retainersTable.setRootVisible(false);
            retainersTable.setSelectionMode(0);
            DataProviderPanel wrap = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)retainersTable)));
            wrap.register(V8NavigateToMainTreeAction.TREE_PATH.getName(), () -> {
                if (this.myRetainersTreeModel == null) {
                    return null;
                }
                TreePath selectionPath = retainersTable.getTree().getSelectionPath();
                if (selectionPath == null || !this.myRetainersTreeModel.navigatableSelected(selectionPath.getLastPathComponent())) {
                    return null;
                }
                List<V8HeapContainmentTreeTableModel.NamedEntry> list = this.myRetainersTreeModel.getPathForSelectionInMainTree(selectionPath.getLastPathComponent());
                return list == null ? null : new TreePath(ArrayUtil.toObjectArray(list));
            });
            wrap.register(MarkUnmarkAction.SELECTED_NODE.getName(), () -> {
                TreePath value = retainersTable.getTree().getSelectionPath();
                if (value != null && value.getLastPathComponent() instanceof FixedNodesListNode) {
                    return ((FixedNodesListNode)value.getLastPathComponent()).getEntry();
                }
                return null;
            });
            wrap.register(MarkUnmarkAction.REVALIDATION.getName(), new Supplier<Object>(){
                private final Runnable runnable = () -> {
                    retainersTable.revalidate();
                    retainersTable.repaint();
                };

                @Override
                public Object get() {
                    return this.runnable;
                }
            });
            this.updateDetails((JComponent)((Object)wrap));
            retainersTable.setModel(this.myRetainersTreeModel);
            V8Utils.afterModelReset(this.myProject, this.myReader, retainersTable);
            this.myRetainersTreeModel.expandByDefault(retainersTable);
            V8Utils.installHeapPopupMenu(this.myProject, retainersTable, this.myReader, this.myMainTreeNavigator);
        }, ModalityState.any(), o -> this.myCloseable.isDisposeStarted());
    }

    private void mainTableSelectionListener() {
        this.myTable.getTree().getSelectionModel().setSelectionMode(1);
        this.myTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = V8MainTableWithRetainers.this.myTable.getTree().getSelectionPath();
                int row = V8MainTableWithRetainers.this.myTable.getSelectedRow();
                if (path != null && path.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)path.getLastPathComponent();
                    if (V8MainTableWithRetainers.this.myMainSelection.get() != null && Comparing.equal((Object)((V8HeapEntry)((Pair)V8MainTableWithRetainers.this.myMainSelection.get().getFirst()).getFirst()), (Object)namedEntry.getEntry()) && Comparing.equal((Object)((TreePath)V8MainTableWithRetainers.this.myMainSelection.get().getSecond()), (Object)path)) {
                        return;
                    }
                    V8MainTableWithRetainers.this.updateDetails(UIHelper.wrapInCenteredPanel(CommonBundle.getLoadingTreeNodeText()));
                    V8MainTableWithRetainers.this.myRetainersTreeModel = null;
                    V8HeapEdge heapEdge = namedEntry.getLinkOffset() > 0L ? V8MainTableWithRetainers.this.myReader.getEdge(namedEntry.getLinkOffset() / 37L) : null;
                    V8MainTableWithRetainers.this.myMainSelection.set((Pair<Pair<V8HeapEntry, V8HeapEdge>, TreePath>)Pair.create((Object)Pair.create((Object)namedEntry.getEntry(), (Object)heapEdge), (Object)(V8MainTableWithRetainers.this.myUseTreeSelectionForRetainers ? path : null)));
                    V8MainTableWithRetainers.this.myUpdater.queue(V8MainTableWithRetainers.this.myRetainersUpdater);
                } else {
                    V8MainTableWithRetainers.this.myMainSelection.set(null);
                    V8MainTableWithRetainers.this.updateDetails(UIHelper.wrapInCenteredPanel(NodeJSBundle.message("profile.cpu.nothing_to_show.label", new Object[0])));
                    V8MainTableWithRetainers.this.myRetainersTreeModel = null;
                }
            }
        });
    }

    public void setUseTreeSelectionForRetainers(boolean useTreeSelectionForRetainers) {
        this.myUseTreeSelectionForRetainers = useTreeSelectionForRetainers;
    }

    public void setMainTreeNavigator(V8MainTreeNavigator mainTableNavigator) {
        this.myMainTreeNavigator = mainTableNavigator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "mainTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "closeable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8MainTableWithRetainers";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyV8MainTreeNavigator
    implements V8MainTreeNavigator {
        @NotNull
        private final Project myProject;

        private MyV8MainTreeNavigator(Project project) {
            if (project == null) {
                MyV8MainTreeNavigator.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        private boolean showError() {
            NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.cpu.main_table.cannot_navigate.notification.content", new Object[0]), MessageType.WARNING).notify(this.myProject);
            return false;
        }

        @Override
        public boolean navigateTo(@NotNull TreePath path) {
            TreePath convertedPath;
            if (path == null) {
                MyV8MainTreeNavigator.$$$reportNull$$$0(1);
            }
            if ((convertedPath = V8MainTableWithRetainers.this.myReader.translateIntoPathFromNodesChain(path.getPath())) == null) {
                return this.showError();
            }
            this.expandImpl(V8MainTableWithRetainers.this.myTable, convertedPath);
            return true;
        }

        private void expandImpl(TreeTable table, TreePath convertedPath) {
            table.clearSelection();
            this.expandPathIteratively((JTree)table.getTree(), 0, convertedPath.getPath(), () -> {
                table.addSelectedPath(convertedPath);
                int row = table.getTree().getRowForPath(convertedPath);
                if (row >= 0) {
                    table.scrollRectToVisible(table.getCellRect(row, 0, true));
                }
            });
        }

        @Override
        public boolean navigateTo(@NotNull V8HeapEntry node, @Nullable V8HeapEdge edgeToNode) {
            if (node == null) {
                MyV8MainTreeNavigator.$$$reportNull$$$0(2);
            }
            ArrayList<FixedRetainerNode> nodes = new ArrayList<FixedRetainerNode>(SearchDetailsTreeModel.getChainToRoot(-1, node, edgeToNode, V8MainTableWithRetainers.this.myReader));
            for (V8HeapContainmentTreeTableModel.NamedEntry namedEntry : nodes) {
                if (!(namedEntry instanceof FixedRetainerNode) || !((FixedRetainerNode)namedEntry).isUnreachable()) continue;
                return this.showError();
            }
            nodes.add(0, (FixedRetainerNode)new V8HeapContainmentTreeTableModel.NamedEntry(V8MainTableWithRetainers.this.myReader.getNode(0L), "", "", -1L));
            TreePath path = V8MainTableWithRetainers.this.myReader.translateIntoPathFromNodesChain(ArrayUtil.toObjectArray(nodes));
            if (path == null) {
                return this.showError();
            }
            this.expandImpl(V8MainTableWithRetainers.this.myTable, path);
            return true;
        }

        private void expandPathIteratively(@NotNull JTree tree, int idxTo, Object[] pathElements, Runnable finalContinuation) {
            if (tree == null) {
                MyV8MainTreeNavigator.$$$reportNull$$$0(3);
            }
            Object[] subPath = Arrays.copyOf(pathElements, idxTo + 1);
            tree.expandPath(new TreePath(subPath));
            SwingUtilities.invokeLater(() -> {
                if (pathElements.length == subPath.length) {
                    EdtExecutorService.getScheduledExecutorInstance().schedule(finalContinuation, 20L, TimeUnit.MILLISECONDS);
                } else {
                    this.expandPathIteratively(tree, idxTo + 1, pathElements, finalContinuation);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8MainTableWithRetainers$MyV8MainTreeNavigator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigateTo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expandPathIteratively";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

