/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io.reverse;

import com.intellij.util.Processor;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.heap.io.RandomRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import com.jetbrains.nodejs.util.CloseableThrowableProcessor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LinksReader<T>
implements Closeable {
    private final File myNumFile;
    private final File myLinksFile;
    private final RawSerializer<T> mySerializer;
    private final RandomRawReader<SizeOffset> myNumReader;
    private final RandomRawReader<T> myLinksReader;
    private final SequentialRawReader<SizeOffset> mySNumReader;
    private final SequentialRawReader<T> mySLinksReader;

    public LinksReader(File numFile, File linksFile, RawSerializer<T> serializer, boolean forSequential) throws FileNotFoundException {
        this.myNumFile = numFile;
        this.myLinksFile = linksFile;
        this.mySerializer = serializer;
        if (forSequential) {
            this.myNumReader = null;
            this.myLinksReader = null;
            this.mySLinksReader = new SequentialRawReader<T>(this.myLinksFile, this.mySerializer);
            this.mySNumReader = new SequentialRawReader<SizeOffset>(this.myNumFile, SizeOffset.MySerializer.getInstance());
        } else {
            this.myNumReader = new RandomRawReader<SizeOffset>(this.myNumFile, SizeOffset.MySerializer.getInstance());
            this.myLinksReader = new RandomRawReader<T>(this.myLinksFile, this.mySerializer);
            this.mySLinksReader = null;
            this.mySNumReader = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void read(long index, @NotNull Processor<? super T> processor) throws IOException {
        void processor2;
        if (processor == null) {
            LinksReader.$$$reportNull$$$0(0);
        }
        if (this.myNumReader == null) {
            throw new IllegalStateException();
        }
        SizeOffset sizeOffset = this.myNumReader.read(index);
        this.myLinksReader.read(sizeOffset.getOffset(), sizeOffset.getSize(), (Processor<T>)processor2);
    }

    public T readRandomLen(long index) throws IOException {
        if (this.myNumReader == null) {
            throw new IllegalStateException();
        }
        SizeOffset sizeOffset = this.myNumReader.read(index);
        return this.myLinksReader.readRandomLen(sizeOffset.getOffset(), sizeOffset.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skip(long items, boolean isRandomLen) throws IOException {
        SizeOffset offset;
        try (RandomRawReader<SizeOffset> random = new RandomRawReader<SizeOffset>(this.myNumFile, SizeOffset.MySerializer.getInstance());){
            offset = random.read(items);
        }
        this.mySNumReader.skip(items);
        if (isRandomLen) {
            this.mySLinksReader.skipBytes((int)offset.getOffset(), offset.getSize());
        } else {
            this.mySLinksReader.skip(offset.getOffset());
        }
    }

    public void iterateRandomLen(final @NotNull Processor<? super T> processor) throws IOException {
        if (processor == null) {
            LinksReader.$$$reportNull$$$0(1);
        }
        this.mySNumReader.iterate(new CloseableThrowableProcessor<SizeOffset, IOException>(){

            @Override
            public boolean process(SizeOffset offset) throws IOException {
                return processor.process(LinksReader.this.mySLinksReader.read());
            }

            @Override
            public void close() throws IOException {
                LinksReader.this.mySLinksReader.close();
            }
        });
    }

    public void iterate(final @NotNull Processor<? super List<T>> consumer) throws IOException {
        if (consumer == null) {
            LinksReader.$$$reportNull$$$0(2);
        }
        this.mySNumReader.iterate(new CloseableThrowableProcessor<SizeOffset, IOException>(){

            @Override
            public void close() throws IOException {
                LinksReader.this.mySLinksReader.close();
            }

            @Override
            public boolean process(SizeOffset offset) throws IOException {
                ArrayList list = new ArrayList(offset.getSize());
                for (int i = 0; i < offset.getSize(); ++i) {
                    list.add(LinksReader.this.mySLinksReader.read());
                }
                return consumer.process(list);
            }
        });
    }

    public void iterateWithThrowable(final @NotNull ThrowableConsumer<List<T>, IOException> consumer) throws IOException {
        if (consumer == null) {
            LinksReader.$$$reportNull$$$0(3);
        }
        this.mySNumReader.iterate(new CloseableThrowableConsumer<SizeOffset, IOException>(){

            @Override
            public void close() throws IOException {
                LinksReader.this.mySLinksReader.close();
            }

            public void consume(SizeOffset offset) throws IOException {
                ArrayList list = new ArrayList(offset.getSize());
                for (int i = 0; i < offset.getSize(); ++i) {
                    list.add(LinksReader.this.mySLinksReader.read());
                }
                consumer.consume(list);
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.myNumReader == null) {
            this.mySNumReader.close();
            this.mySLinksReader.close();
        } else {
            this.myNumReader.close();
            this.myLinksReader.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/io/reverse/LinksReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateRandomLen";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "iterate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateWithThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

