/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.TempFiles;
import com.jetbrains.nodejs.run.profile.heap.TimeReporter;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotListener;
import com.jetbrains.nodejs.run.profile.heap.calculation.HeapSnapshotReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.RetainedSizeCalculator;
import com.jetbrains.nodejs.run.profile.heap.calculation.ReverseIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8StringIndex;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapHeader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class V8HeapProcessor
implements Disposable {
    public static final Logger LOG = Logger.getInstance(V8HeapProcessor.class);
    private final File myFile;
    private final TimeReporter myReporter;
    @NotNull
    private final Consumer<String> myErrorNotificator;
    private File myNodeIndex;
    private File myEdgeIndex;
    private V8HeapHeader myHeader;
    private ReverseIndexes myReverseIndexes;
    private V8StringIndex myStringIndex;
    private long myStringsCnt;
    private V8CachingReader myCachingReader;
    private final CompositeCloseable myResourses;
    private RetainedSizeCalculator myRetainedSizeCalculator;
    private final boolean myShowHidden;
    private V8ImportantStringsHolder myStringsHolder;
    private final V8HeapIndexManager myManager;

    public V8HeapProcessor(@NotNull Consumer<String> errorNotificator, File file, boolean showHidden, ProgressIndicator indicator) throws IOException {
        if (errorNotificator == null) {
            V8HeapProcessor.$$$reportNull$$$0(0);
        }
        this.myErrorNotificator = errorNotificator;
        this.myShowHidden = showHidden;
        this.myReporter = new TimeReporter(NodeJSBundle.message("profile.heap.processing.action.name", new Object[0]), indicator);
        this.myFile = file;
        this.myResourses = new CompositeCloseable();
        if (this.myFile.getParentFile() == null) {
            throw new IOException("Can not create temp index files.");
        }
        this.myManager = new V8HeapIndexManager(this.myFile, this.myShowHidden);
    }

    public ByteArrayWrapper getDigest() {
        return this.myManager.getDigest();
    }

    public V8CachingReader getFromCacheOrProcess() throws IOException, ClassNotFoundException {
        V8CachingReader reader;
        if (this.myManager.isInitialized() && (reader = this.myManager.initReader(this.myResourses, this.myErrorNotificator)) != null) {
            return reader;
        }
        reader = this.processSnapshot(this.myManager.getDigest(), true, this.myManager.getIndexFiles());
        this.myManager.recordReader(reader);
        return reader;
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest) throws IOException {
        if (digest == null) {
            V8HeapProcessor.$$$reportNull$$$0(1);
        }
        return this.processSnapshot(digest, true, this.myResourses.setVeryLast(new TempFiles(this.myFile.getName())));
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest, boolean calculateRetainedSizes) throws IOException {
        if (digest == null) {
            V8HeapProcessor.$$$reportNull$$$0(2);
        }
        return this.processSnapshot(digest, calculateRetainedSizes, this.myResourses.setVeryLast(new TempFiles(this.myFile.getName())));
    }

    public V8CachingReader processSnapshot(@NotNull ByteArrayWrapper digest, boolean calculateRetainedSizes, IndexFiles indexFiles) throws IOException {
        if (digest == null) {
            V8HeapProcessor.$$$reportNull$$$0(3);
        }
        try {
            this.myNodeIndex = indexFiles.generate(V8HeapIndexManager.Category.nodeIdx, ".node.index");
            this.myEdgeIndex = indexFiles.generate(V8HeapIndexManager.Category.edgeIdx, ".edge.index");
            this.myStringIndex = this.myResourses.register(new V8StringIndex(indexFiles));
            this.plainRead(indexFiles);
            this.myReverseIndexes.continueCalculation(this.myEdgeIndex, this.myHeader.getEdgesCnt());
            this.myReporter.reportStage("Reverse indexes calculated");
            this.myResourses.closeAndRemove(this.myReverseIndexes);
            this.myCachingReader = new V8CachingReader(this.myFile, digest, this.myResourses, this.myHeader, this.myErrorNotificator, this.myStringIndex, this.myNodeIndex, this.myEdgeIndex, this.myReverseIndexes.getReverseStringIndexProcessor(), this.myReverseIndexes.getReverseLinkIndexProcessor(), this.myStringsHolder);
            if (calculateRetainedSizes) {
                this.myRetainedSizeCalculator = this.myResourses.register(new RetainedSizeCalculator(this.myHeader.getNodesCnt(), this.myShowHidden));
                this.myRetainedSizeCalculator.execute(this.myCachingReader, this.myReverseIndexes.getReverseLinkIndexProcessor(), this.myNodeIndex, indexFiles, this.myStringsHolder);
                this.myCachingReader.setInMemoryIndexes(this.myRetainedSizeCalculator.getInMemoryIndexes());
                this.myCachingReader.setAggregatesLinksReaderFactory(this.myRetainedSizeCalculator.getAggregatesLinksReaderFactory());
                this.myCachingReader.resortChildren();
                this.myResourses.closeAndRemove(this.myRetainedSizeCalculator);
                this.myRetainedSizeCalculator = null;
            }
            this.myReporter.reportStage("Retained sizes ready");
            this.myReporter.reportTotal();
            if (!this.myShowHidden) {
                this.myCachingReader.resetDoNotShowHidden();
            }
            return this.myCachingReader;
        }
        catch (IOException e) {
            this.myResourses.close();
            throw e;
        }
        catch (Throwable th) {
            this.myResourses.close();
            throw new RuntimeException(th);
        }
    }

    private void plainRead(IndexFiles indexFiles) throws IOException {
        HeapSnapshotReader reader = this.myResourses.register(new HeapSnapshotReader(this.myFile));
        this.myHeader = reader.readHeader();
        this.myReverseIndexes = this.myResourses.register(new ReverseIndexes(this.myHeader.getNodesCnt(), indexFiles, this.myNodeIndex));
        ReaderListener listener = this.myResourses.register(new ReaderListener(this.myNodeIndex, this.myEdgeIndex, this.myReverseIndexes, this.myStringIndex, this.myHeader));
        reader.readWithReader(listener);
        this.myResourses.closeAndRemove(listener);
        this.myResourses.closeAndRemove(reader);
        this.myStringsCnt = listener.getStringsCnt();
        this.myStringsHolder = listener.getStringsHolder();
        this.myStringIndex.startReading();
        this.myReporter.reportStage("Read file, wrote indexes");
    }

    public long getStringsCnt() {
        return this.myStringsCnt;
    }

    public V8ImportantStringsHolder getStringsHolder() {
        return this.myStringsHolder;
    }

    public V8HeapHeader getHeader() {
        return this.myHeader;
    }

    public void dispose() {
        try {
            this.myResourses.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorNotificator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processSnapshot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReaderListener
    implements HeapSnapshotListener,
    Closeable {
        private final V8ImportantStringsHolder myStringsHolder;
        private long myEdgesOff;
        private long myStringsCnt;
        @NotNull
        private final File myNodeIndexFile;
        @NotNull
        private final File myEdgeIndexFile;
        private final SequentialRawWriter<V8HeapEntry> myNodeWriter;
        private EdgeIndexCreator myEdgeIndexCreator;
        @NotNull
        private final ReverseIndexes myProcessor;
        @NotNull
        private final V8StringIndex myStringIndex;
        private final V8HeapHeader myHeader;
        private CloseableThrowableConsumer<V8HeapEdge, IOException> myEdgesFirstStageCalculator;
        private final CloseableThrowableConsumer<V8HeapEntry, IOException> myNodesFirstStageCalculator;

        ReaderListener(@NotNull File nodeIndexFile, @NotNull File edgeIndexFile, @NotNull ReverseIndexes processor, @NotNull V8StringIndex stringIndex, V8HeapHeader header) throws FileNotFoundException {
            if (nodeIndexFile == null) {
                ReaderListener.$$$reportNull$$$0(0);
            }
            if (edgeIndexFile == null) {
                ReaderListener.$$$reportNull$$$0(1);
            }
            if (processor == null) {
                ReaderListener.$$$reportNull$$$0(2);
            }
            if (stringIndex == null) {
                ReaderListener.$$$reportNull$$$0(3);
            }
            this.myNodeIndexFile = nodeIndexFile;
            this.myEdgeIndexFile = edgeIndexFile;
            this.myProcessor = processor;
            this.myStringIndex = stringIndex;
            this.myHeader = header;
            this.myEdgesOff = 0L;
            this.myNodeWriter = new SequentialRawWriter<V8HeapEntry>(this.myNodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance());
            this.myNodesFirstStageCalculator = this.myProcessor.getNodesFirstStageCalculator();
            this.myStringsHolder = new V8ImportantStringsHolder();
        }

        @Override
        public void allNodesRead() throws IOException {
            this.myNodeWriter.close();
            this.myEdgeIndexCreator = new EdgeIndexCreator(this.myNodeIndexFile, this.myEdgeIndexFile, this.myHeader.getNodesCnt());
            this.myEdgesFirstStageCalculator = this.myProcessor.getEdgesFirstStageCalculator();
        }

        @Override
        public void allEdgesRead() {
            this.myEdgeIndexCreator.close();
        }

        @Override
        public void stringsCount(long cnt) {
            this.myProcessor.correctStringsSize(cnt);
            this.myStringsCnt = cnt;
        }

        @Override
        public void accept(@NotNull V8HeapEntry node) throws IOException {
            if (node == null) {
                ReaderListener.$$$reportNull$$$0(4);
            }
            node.setEdgesOffset(this.myEdgesOff);
            this.myNodesFirstStageCalculator.consume(node);
            this.myNodeWriter.write(node);
            this.myEdgesOff += node.getChildrenCount();
        }

        @Override
        public void accept(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                ReaderListener.$$$reportNull$$$0(5);
            }
            this.myEdgeIndexCreator.adjust(edge);
            this.myEdgesFirstStageCalculator.consume(edge);
            this.myEdgeIndexCreator.serialize(edge);
        }

        @Override
        public void accept(@NotNull String name) throws IOException {
            if (name == null) {
                ReaderListener.$$$reportNull$$$0(6);
            }
            long id = this.myStringIndex.addString(name);
            this.myStringsHolder.accept(id, name);
        }

        @Override
        public void close() throws IOException {
            this.myStringsHolder.onFinish();
            if (this.myNodeWriter != null) {
                this.myNodeWriter.close();
            }
            if (this.myEdgeIndexCreator != null) {
                this.myEdgeIndexCreator.close();
            }
            if (this.myEdgesFirstStageCalculator != null) {
                this.myEdgesFirstStageCalculator.close();
            }
            if (this.myNodesFirstStageCalculator != null) {
                this.myNodesFirstStageCalculator.close();
            }
        }

        public long getStringsCnt() {
            return this.myStringsCnt;
        }

        public V8ImportantStringsHolder getStringsHolder() {
            return this.myStringsHolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeIndexFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeIndexFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringIndex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$ReaderListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EdgeIndexCreator {
        private final SequentialRawWriter<V8HeapEdge> myEdgeWriter;
        private long myEdgeIdx;
        private long myNodeIdx;
        private V8HeapEntry myNode;
        private final SequentialRawReader<V8HeapEntry> myNodesReader;

        EdgeIndexCreator(@NotNull File nodeIndexFile, @NotNull File edgeIndexFile, long nodesCnt) throws IOException {
            if (nodeIndexFile == null) {
                EdgeIndexCreator.$$$reportNull$$$0(0);
            }
            if (edgeIndexFile == null) {
                EdgeIndexCreator.$$$reportNull$$$0(1);
            }
            this.myEdgeWriter = new SequentialRawWriter<V8HeapEdge>(edgeIndexFile, V8HeapEdge.MyRawSerializer.getInstance());
            this.myNodesReader = new SequentialRawReader<V8HeapEntry>(nodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance(), nodesCnt);
            this.myEdgeIdx = 0L;
            this.myNodeIdx = 0L;
            this.myNode = this.myNodesReader.read();
        }

        public void adjust(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                EdgeIndexCreator.$$$reportNull$$$0(2);
            }
            while (this.myEdgeIdx == this.myNode.getEdgesOffset() + this.myNode.getChildrenCount()) {
                this.myNode = this.myNodesReader.read();
                ++this.myNodeIdx;
            }
            edge.setFromIndex(this.myNodeIdx);
        }

        public void serialize(@NotNull V8HeapEdge edge) throws IOException {
            if (edge == null) {
                EdgeIndexCreator.$$$reportNull$$$0(3);
            }
            this.myEdgeWriter.write(edge);
            ++this.myEdgeIdx;
        }

        public void close() {
            this.myEdgeWriter.close();
            this.myNodesReader.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeIndexFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeIndexFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edge";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8HeapProcessor$EdgeIndexCreator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "adjust";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

