/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExpandNodeAction
extends DumbAwareAction {
    private final V8ProfilingCallTreeTable myTable;

    public ExpandNodeAction(V8ProfilingCallTreeTable table) {
        super(NodeJSBundle.messagePointer("action.ExpandNodeAction.expand.node.text", new Object[0]), NodeJSBundle.messagePointer("action.ExpandNodeAction.expand.node.recursively.description", new Object[0]), AllIcons.Actions.Expandall);
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExpandNodeAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabled(this.myTable.getSelectedRow() >= 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int row;
        if (e == null) {
            ExpandNodeAction.$$$reportNull$$$0(1);
        }
        if ((row = this.myTable.getSelectedRow()) >= 0) {
            TreeTableWidthController widthController = this.myTable.getWidthController();
            if (widthController != null) {
                widthController.startBatchExpand();
            }
            this.expandRowRecursively(row);
            if (widthController != null) {
                widthController.stopBatchExpand();
            }
        }
    }

    private void expandRowRecursively(int row) {
        this.myTable.getTree().expandRow(row);
        TreePath parentPath = this.myTable.getTree().getPathForRow(row);
        Object component = parentPath.getLastPathComponent();
        TreeTableModel model = this.myTable.getTableModel();
        int count = model.getChildCount(component);
        Object[] pathComponents = parentPath.getPath();
        for (int i = 0; i < count; ++i) {
            Object child = model.getChild(component, i);
            if (child == null) continue;
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(pathComponents));
            list.add(child);
            int childRow = this.myTable.getTree().getRowForPath(new TreePath(ArrayUtil.toObjectArray(list)));
            if (childRow < 0) continue;
            this.expandRowRecursively(childRow);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/ExpandNodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

