/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class ChartPanel
extends JPanel {
    protected final int myLeft;
    protected int myRightMargin;
    protected int myTop;
    protected int myGridTop;
    protected int myHeight;
    protected long myRealLeft;
    protected long myRealRight;
    protected static final int myDragArea = 10;
    protected Font myGridFont;
    protected int myGridFontHeight;
    protected boolean myDrawLabels = true;
    private static final TreeMap<Long, Convertor<Long, String>> ourGridMap = new TreeMap();
    private static final Convertor<Long, String> ourMinConvertor;

    public ChartPanel(int left, int rightMargin, int top, int height, long realLeft, long realRight) {
        this.myLeft = left;
        this.myRightMargin = rightMargin;
        this.myTop = top;
        this.myGridTop = this.myGridFontHeight;
        this.myHeight = height;
        this.myRealLeft = realLeft;
        this.myRealRight = realRight;
        this.myGridFont = this.getFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myGridFontHeight = this.getFontMetrics(this.myGridFont).getHeight();
    }

    protected int pixelsFromReal(long real) {
        return this.myLeft + (int)Math.round((double)(this.getWidth() - this.myLeft - this.myRightMargin) / (double)(this.myRealRight - this.myRealLeft) * (double)(real - this.myRealLeft));
    }

    protected long realFromPixels(int pixels) {
        return this.myRealLeft + Math.round((double)(this.myRealRight - this.myRealLeft) / (double)(this.getWidth() - this.myLeft - this.myRightMargin) * (double)(pixels - this.myLeft));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.myLeft + this.myRightMargin + 10, this.myHeight + this.myTop);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, this.myHeight + this.myTop);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        V8Utils.safeDraw((Graphics2D)g, (Consumer<? super Graphics2D>)((Consumer)graphics -> {
            UISettings.setupAntialiasing((Graphics)graphics);
            int width1 = this.getWidth();
            this.drawChart((Graphics2D)graphics, this.myLeft, this.myTop, width1 - this.myLeft - this.myRightMargin, this.myHeight, this.myGridFontHeight);
            this.drawTsGrid((Graphics2D)graphics);
        }));
        this.paintBorder(g);
    }

    protected void drawTsGrid(Graphics2D g) {
        GridParameters grid = new GridParameters();
        BasicStroke dashed = new BasicStroke(0.1f);
        g.setStroke(dashed);
        g.setColor(Color.gray);
        int unit = grid.getUnit();
        g.setFont(this.myGridFont);
        Rectangle visibleRect = this.getVisibleRect();
        for (long current = Math.round((double)this.myRealLeft / (double)unit) * (long)unit; current < this.myRealRight + (long)unit; current += (long)unit) {
            int x = this.pixelsFromReal(current);
            if (x <= this.myLeft || x >= this.getWidth() - this.myRightMargin) continue;
            g.drawLine(x, visibleRect.y, x, visibleRect.y + this.myTop + this.getHeight());
            if (!this.myDrawLabels) continue;
            g.drawString((String)grid.getToStringConvertor().convert((Object)(current / 1000L)), x + 3, visibleRect.y + this.myGridTop);
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
    }

    @Nls
    public static String getIntervalDescription(long start, long end) {
        long interval = end - start;
        Long prevUnit = null;
        Convertor<Long, String> convertor = null;
        for (Long unit : ourGridMap.keySet()) {
            if (interval / unit < 10L) {
                convertor = prevUnit != null ? ourGridMap.get(prevUnit) : ourGridMap.get(unit);
                break;
            }
            prevUnit = unit;
        }
        if (convertor == null) {
            convertor = ourGridMap.lastEntry().getValue();
        }
        return (String)convertor.convert((Object)(start / 1000L)) + "-" + (String)convertor.convert((Object)(end / 1000L));
    }

    @NotNull
    private static Convertor<Long, String> createMinConvertor() {
        Convertor convertor = ts -> ts / 60000L + "min";
        if (convertor == null) {
            ChartPanel.$$$reportNull$$$0(0);
        }
        return convertor;
    }

    @NotNull
    private static Convertor<Long, String> createTsConvertor() {
        Convertor convertor = ts -> ts + "ms";
        if (convertor == null) {
            ChartPanel.$$$reportNull$$$0(1);
        }
        return convertor;
    }

    private static Convertor<Long, String> createSecondsConvertor() {
        return ts -> ts / 1000L + "s";
    }

    protected boolean aroundBound(int x, int bound) {
        return x >= bound - 10 && x <= bound + 10;
    }

    protected abstract void drawChart(Graphics2D var1, int var2, int var3, int var4, int var5, int var6);

    static {
        ourGridMap.put(1000L, ChartPanel.createTsConvertor());
        ourGridMap.put(10000L, ChartPanel.createTsConvertor());
        ourGridMap.put(100000L, (Convertor<Long, String>)((Convertor)ts -> {
            if (ts > 1000L) {
                long whole = (long)Math.floor((double)ts.longValue() / 1000.0);
                return whole + "." + Math.round((double)(ts - whole * 1000L) / 100.0) + "s";
            }
            return ts + "ms";
        }));
        ourGridMap.put(1000000L, ChartPanel.createSecondsConvertor());
        ourGridMap.put(10000000L, ChartPanel.createSecondsConvertor());
        ourMinConvertor = ChartPanel.createMinConvertor();
        ourGridMap.put(60000000L, ourMinConvertor);
        ourGridMap.put(600000000L, ourMinConvertor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/ChartPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMinConvertor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTsConvertor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class GridParameters {
        private final int myUnit;
        private final Convertor<Long, String> myToStringConvertor;

        GridParameters() {
            for (Long unit : ourGridMap.keySet()) {
                if (!this.stepIsBig(ChartPanel.this.pixelsFromReal(ChartPanel.this.myRealLeft + (long)unit.intValue()))) continue;
                this.myUnit = unit.intValue();
                this.myToStringConvertor = ourGridMap.get(unit);
                return;
            }
            this.myUnit = 60000000;
            this.myToStringConvertor = ourMinConvertor;
        }

        public int getUnit() {
            return this.myUnit;
        }

        public Convertor<Long, String> getToStringConvertor() {
            return this.myToStringConvertor;
        }

        private boolean stepIsBig(int pixels) {
            return pixels > 100;
        }
    }
}

