/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuLogCall {
    private final V8ProfileLine.ExecKind myExecKind;
    private final String myFunctionName;
    private final boolean myNative;
    private boolean myNotNavigatable;
    @Nullable
    private final V8ProfileLineFileDescriptor myDescriptor;
    @Nls
    private final String myNotParsedCallable;
    private final CodeState myCodeState;
    private final long myStringId;
    @Nls
    private String myPresentation;

    public V8CpuLogCall(@NotNull V8ProfileLine.ExecKind execKind, String functionName, boolean aNative, boolean notNavigatable, @Nullable V8ProfileLineFileDescriptor descriptor, @NlsSafe String notParsedCallable, CodeState codeState, long stringId) {
        if (execKind == null) {
            V8CpuLogCall.$$$reportNull$$$0(0);
        }
        this.myExecKind = execKind;
        this.myFunctionName = functionName;
        this.myNative = aNative;
        this.myNotNavigatable = notNavigatable;
        this.myDescriptor = descriptor;
        this.myNotParsedCallable = notParsedCallable;
        this.myCodeState = codeState;
        this.myStringId = stringId;
        this.setPresentation(this.getPresentation(false));
    }

    public V8CpuLogCall cloneMe() {
        return new V8CpuLogCall(this.myExecKind, this.myFunctionName, this.myNative, this.myNotNavigatable, this.myDescriptor, this.myNotParsedCallable, this.myCodeState, this.myStringId);
    }

    public long getStringId() {
        return this.myStringId;
    }

    public void setNotNavigatable(boolean notNavigatable) {
        this.myNotNavigatable = notNavigatable;
    }

    @NotNull
    public V8ProfileLine.ExecKind getExecKind() {
        V8ProfileLine.ExecKind execKind = this.myExecKind;
        if (execKind == null) {
            V8CpuLogCall.$$$reportNull$$$0(1);
        }
        return execKind;
    }

    public String getFunctionName() {
        return this.myFunctionName;
    }

    public boolean isNative() {
        return this.myNative;
    }

    public boolean isNotNavigatable() {
        return this.myNotNavigatable;
    }

    public boolean isLocal() {
        return !this.isNative() && !this.isNotNavigatable() && this.getDescriptor() != null && this.getDescriptor().getPath() != null;
    }

    @Nullable
    public V8ProfileLineFileDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Nls
    public String getNotParsedCallable() {
        return this.myNotParsedCallable;
    }

    public CodeState getCodeState() {
        return this.myCodeState;
    }

    public void setPresentation(@Nls String presentation) {
        this.myPresentation = presentation;
    }

    @Nls
    public String getPresentation() {
        return this.myPresentation;
    }

    @Nls
    public String getPresentation(boolean fullPath) {
        return this.getPresentation(fullPath, false);
    }

    @Nls
    public String getPresentation(boolean fullPath, boolean oldStyle) {
        V8ProfileLine.ExecKind kind = this.getExecKind();
        if (V8ProfileLine.ExecKind.unknown.equals((Object)kind)) {
            return this.getNotParsedCallable();
        }
        StringBuilder sb = new StringBuilder();
        V8ProfileLineFileDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            if (oldStyle) {
                sb.append(kind.name()).append(": ");
            }
            sb.append(this.getCodeState().getPrefix());
            String functionName = this.getFunctionName();
            if (!StringUtil.isEmptyOrSpaces((String)functionName)) {
                sb.append(functionName).append(" ");
            }
            if (this.isNative()) {
                sb.append("native ");
            }
            sb.append(fullPath ? descriptor.getLink() : descriptor.getShortLink());
        } else {
            sb.append(this.getNotParsedCallable());
        }
        @NlsSafe String s = sb.toString();
        return s;
    }

    public static V8CpuLogCall create(@NotNull @NlsSafe String line, long stringId) {
        String word;
        String functionName;
        String[] split;
        ArrayDeque<String> parts;
        if (line == null) {
            V8CpuLogCall.$$$reportNull$$$0(2);
        }
        if ((parts = new ArrayDeque<String>(Arrays.asList(split = line.split(" ")))).size() < 2) {
            return V8CpuLogCall.dumb(line, stringId);
        }
        boolean isNative = false;
        V8ProfileLine.ExecKind kind = V8CpuLogCall.parseKind(parts.removeFirst());
        if (kind == null) {
            return V8CpuLogCall.dumb(line, stringId);
        }
        boolean notNavigatable = !V8ProfileLine.ExecKind.Function.equals((Object)kind) && !V8ProfileLine.ExecKind.LazyCompile.equals((Object)kind);
        String functionStr = parts.getFirst();
        CodeState codeState = functionStr.isEmpty() ? CodeState.compiled : V8CpuLogCall.parseCodeState(functionStr.substring(0, 1));
        String string = functionName = CodeState.optimizable.equals((Object)codeState) || CodeState.optimized.equals((Object)codeState) ? functionStr.substring(1) : functionStr;
        if (notNavigatable) {
            word = functionName;
            functionName = "";
        } else {
            parts.removeFirst();
            if (parts.isEmpty()) {
                return new V8CpuLogCall(kind, functionName, false, true, null, "", codeState, stringId);
            }
            word = parts.getFirst();
        }
        if ("native".equals(word)) {
            isNative = true;
            if (parts.isEmpty()) {
                return V8CpuLogCall.dumb(line, stringId);
            }
            parts.removeFirst();
        } else {
            parts.removeFirst();
            parts.addFirst(word);
        }
        String fileStr = StringUtil.join(parts, (String)" ");
        V8ProfileLineFileDescriptor descriptor = V8CpuLogCall.parseFileStr(fileStr, kind);
        if (descriptor == null) {
            return new V8CpuLogCall(kind, functionName, isNative, notNavigatable, null, fileStr, codeState, stringId);
        }
        return new V8CpuLogCall(kind, functionName, isNative, notNavigatable, descriptor, fileStr, codeState, stringId);
    }

    private static V8ProfileLineFileDescriptor parseFileStr(String str, V8ProfileLine.ExecKind kind) {
        if (V8ProfileLine.ExecKind.Script.equals((Object)kind)) {
            return V8CpuLogCall.parsePath(FileUtil.toSystemIndependentName((String)str), -1, -1);
        }
        int idxSecondColon = str.lastIndexOf(":");
        if (idxSecondColon <= 0) {
            return V8CpuLogCall.parsePath(FileUtil.toSystemIndependentName((String)str), -1, -1);
        }
        int idxFirstColon = str.lastIndexOf(":", idxSecondColon - 1);
        if (idxFirstColon <= 0) {
            return null;
        }
        try {
            int line = Integer.parseInt(str.substring(idxFirstColon + 1, idxSecondColon));
            int column = Integer.parseInt(str.substring(idxSecondColon + 1));
            String fileName = str.substring(0, idxFirstColon);
            fileName = FileUtil.toSystemIndependentName((String)fileName);
            return V8CpuLogCall.parsePath(fileName, line, column);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static V8ProfileLineFileDescriptor parsePath(@NotNull String fileName, int line, int column) {
        int idx;
        if (fileName == null) {
            V8CpuLogCall.$$$reportNull$$$0(3);
        }
        if ((idx = fileName.lastIndexOf(47)) >= 0) {
            String path = fileName;
            fileName = fileName.substring(idx + 1);
            return new V8ProfileLineFileDescriptor(fileName, path, line, column);
        }
        return new V8ProfileLineFileDescriptor(fileName, null, line, column);
    }

    private static CodeState parseCodeState(String substring) {
        CodeState state = CodeState.fromStrState(substring);
        return state == null ? CodeState.compiled : state;
    }

    @NotNull
    public static V8CpuLogCall dumb(@NotNull @Nls String line, long stringId) {
        if (line == null) {
            V8CpuLogCall.$$$reportNull$$$0(4);
        }
        return new V8CpuLogCall(V8ProfileLine.ExecKind.unknown, "", true, true, null, line, CodeState.compiled, stringId);
    }

    private static V8ProfileLine.ExecKind parseKind(String s) {
        if (!s.endsWith(":")) {
            return null;
        }
        return V8ProfileLine.ExecKind.safeValueOf(s.substring(0, s.length() - 1));
    }

    public Navigatable[] getNavigatables(Project project) {
        return this.myDescriptor == null ? null : this.myDescriptor.getNavigatables(project, this.myFunctionName, this.myNative);
    }

    public String getShort() {
        String link;
        if (V8ProfileLine.ExecKind.unknown.equals((Object)this.getExecKind())) {
            return this.getNotParsedCallable();
        }
        String string = link = this.myDescriptor == null ? this.myNotParsedCallable : this.myDescriptor.getShortLink();
        if (StringUtil.isEmptyOrSpaces((String)this.myFunctionName)) {
            return link + " (" + this.myExecKind.name() + ")";
        }
        return this.myFunctionName + " " + link;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8CpuLogCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dumb";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

