/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.Counter;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CodeMap {
    private static final int PAGE_ALIGNMENT = 12;
    private static final int PAGE_SIZE = 4096;
    private final Map<String, Counter> myNameGeneratorMap = new HashMap<String, Counter>();
    private final TreeMap<BigInteger, DynamicCodeEntry> myDynamics = new TreeMap();
    private final TreeMap<BigInteger, CodeEntry> myStatics = new TreeMap();
    private final TreeMap<BigInteger, CodeEntry> myLibraries = new TreeMap();
    private final Map<BigInteger, Integer> myPages = new HashMap<BigInteger, Integer>();
    private final BidirectionalMap<String, Long> myStringsMap = new BidirectionalMap();

    public CodeMap() {
        this.myStringsMap.put((Object)"(Garbage collection)", (Object)0L);
        this.myStringsMap.put((Object)"(Unknown code)", (Object)1L);
        this.myStringsMap.put((Object)"(Stacktrace cut)", (Object)2L);
    }

    public String getStringByCode(long code) {
        List value = this.myStringsMap.getKeysByValue((Object)code);
        return value == null ? null : (String)value.get(0);
    }

    public Long getStringCode(String s) {
        Long code = (Long)this.myStringsMap.get((Object)s);
        if (code == null) {
            Long value = this.myStringsMap.size();
            this.myStringsMap.put((Object)s, (Object)value);
            return value;
        }
        return code;
    }

    public BidirectionalMap<String, Long> getStringsMap() {
        return this.myStringsMap;
    }

    private void ensureString(CodeEntry codeEntry) {
        String name = codeEntry.getName();
        if (!this.myStringsMap.containsKey((Object)name)) {
            this.myStringsMap.put((Object)name, (Object)this.myStringsMap.size());
        }
    }

    public void addCode(BigInteger start, @NotNull DynamicCodeEntry codeEntry) {
        if (codeEntry == null) {
            CodeMap.$$$reportNull$$$0(0);
        }
        this.deleteFromDynamics(start, start.add(BigInteger.valueOf(codeEntry.getSize())));
        this.ensureString(codeEntry);
        this.myDynamics.put(start, codeEntry);
    }

    public boolean moveCode(BigInteger from, BigInteger to) {
        DynamicCodeEntry removed = this.myDynamics.remove(from);
        if (removed == null) {
            return false;
        }
        this.addCode(to, removed);
        return true;
    }

    public boolean deleteCode(BigInteger start) {
        return this.myDynamics.remove(start) != null;
    }

    public void addLibrary(BigInteger start, @NotNull CodeEntry library) {
        if (library == null) {
            CodeMap.$$$reportNull$$$0(1);
        }
        this.markPages(start, start.add(BigInteger.valueOf(library.getSize())));
        this.ensureString(library);
        this.myLibraries.put(start, library);
    }

    public void addStaticCode(BigInteger start, @NotNull CodeEntry codeEntry) {
        if (codeEntry == null) {
            CodeMap.$$$reportNull$$$0(2);
        }
        this.ensureString(codeEntry);
        this.myStatics.put(start, codeEntry);
    }

    private <T extends CodeEntry> T findInTree(TreeMap<BigInteger, T> map, BigInteger addr) {
        if (map.isEmpty()) {
            return null;
        }
        Map.Entry<BigInteger, T> entry = map.floorEntry(addr);
        if (entry == null) {
            return null;
        }
        BigInteger key = entry.getKey();
        return (T)(key.compareTo(addr) <= 0 && addr.compareTo(key.add(BigInteger.valueOf(((CodeEntry)entry.getValue()).getSize()))) < 0 ? (CodeEntry)entry.getValue() : null);
    }

    public CodeEntry findEntry(BigInteger addr) {
        BigInteger pageAddr = this.pageAlignmentShift(addr);
        if (this.myPages.containsKey(pageAddr)) {
            CodeEntry entry = this.findInTree(this.myStatics, addr);
            if (entry != null) {
                return entry;
            }
            return this.findInTree(this.myLibraries, addr);
        }
        if (this.myDynamics.isEmpty()) {
            return null;
        }
        BigInteger min = this.myDynamics.firstKey();
        Map.Entry<BigInteger, DynamicCodeEntry> last = this.myDynamics.lastEntry();
        if (min.compareTo(addr) <= 0 && addr.compareTo(last.getKey().add(BigInteger.valueOf(last.getValue().getSize()))) < 0) {
            DynamicCodeEntry entry = this.findInTree(this.myDynamics, addr);
            if (entry == null) {
                return null;
            }
            if (entry.getName().isEmpty()) {
                Counter counter = this.myNameGeneratorMap.get(entry.getName());
                if (counter == null) {
                    this.myNameGeneratorMap.put(entry.getName(), new Counter());
                } else {
                    entry.updateName(entry.getName() + " {" + counter.incrementAndGet() + "}");
                }
            }
            return entry;
        }
        return null;
    }

    private BigInteger pageAlignmentShift(BigInteger addr) {
        return BigInteger.valueOf(addr.divide(BigInteger.valueOf(2L)).longValue() >>> 11);
    }

    public DynamicCodeEntry findDynamicByStart(BigInteger addr) {
        return this.myDynamics.get(addr);
    }

    private void markPages(BigInteger start, BigInteger end) {
        BigInteger addr = start;
        while (addr.compareTo(end) <= 0) {
            this.myPages.put(this.pageAlignmentShift(addr), 1);
            addr = addr.add(BigInteger.valueOf(4096L));
        }
    }

    private void deleteFromDynamics(BigInteger start, BigInteger end) {
        if (this.myDynamics.isEmpty()) {
            return;
        }
        NavigableMap head = (NavigableMap)this.myDynamics.headMap(end);
        NavigableMap desc = head.descendingMap();
        Iterator iterator = desc.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((BigInteger)entry.getKey()).compareTo(start) < 0) {
                return;
            }
            iterator.remove();
        }
    }

    public void editName(CodeEntry codeEntry, String newName) {
        codeEntry.setName(newName);
        this.ensureString(codeEntry);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/CodeMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStaticCode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FunctionEntry
    extends DynamicCodeEntry {
        public FunctionEntry(int size, String name) {
            super(size, name, "");
        }

        @Override
        public String getName() {
            if (this.myName.length() == 0) {
                return "<anonymous>";
            }
            if (this.myName.charAt(0) == ' ') {
                return "<anonymous>" + this.myName;
            }
            return super.getName();
        }
    }

    public static class DynamicCodeEntry
    extends CodeEntry {
        private final String myType;

        public DynamicCodeEntry(int size, String name, String type) {
            super(size, name);
            this.myType = type;
        }

        public String getType() {
            return this.myType;
        }

        @Override
        public String getName() {
            return StringUtil.isEmptyOrSpaces((String)this.myType) ? this.myName : this.myType + ": " + this.myName;
        }
    }

    public static class DynamicFuncCodeEntry
    extends DynamicCodeEntry {
        private CodeState myState;
        private final CodeEntry myFunctionCodeEntry;

        public DynamicFuncCodeEntry(int size, String name, String type, CodeState state, CodeEntry functionEntry) {
            super(size, name, type);
            this.myState = state;
            this.myFunctionCodeEntry = functionEntry;
        }

        public void setState(CodeState state) {
            this.myState = state;
        }

        @Override
        public String getName() {
            return this.getType() + ": " + this.myState.getPrefix() + this.myFunctionCodeEntry.getName();
        }

        @Override
        public String getRawName() {
            return this.myFunctionCodeEntry.getName();
        }

        public CodeEntry getFunctionCodeEntry() {
            return this.myFunctionCodeEntry;
        }
    }

    public static class DynamicProfileCodeEntry
    extends DynamicCodeEntry {
        public DynamicProfileCodeEntry(int size, String name, String type) {
            super(size, name, type);
        }

        @Override
        public String getName() {
            return this.getType() + ": " + super.getName();
        }

        @Override
        public String getRawName() {
            return super.getName();
        }
    }

    public static class CodeEntry {
        private final int mySize;
        protected String myName;
        private boolean myNameUpdated;

        public CodeEntry(int size, String name) {
            this.mySize = size;
            this.myName = name;
        }

        public int getSize() {
            return this.mySize;
        }

        public String getName() {
            return this.myName;
        }

        public String getRawName() {
            return this.myName;
        }

        public boolean isNameUpdated() {
            return this.myNameUpdated;
        }

        public void updateName(String newName) {
            if (this.myNameUpdated) {
                return;
            }
            this.myNameUpdated = true;
            this.myName = newName;
        }

        private void setName(String name) {
            this.myName = name;
        }
    }
}

