/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.coverage.MochaCoveragePackageNotFoundException;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MochaCoverageRunState {
    private static final String ISTANBUL_PACKAGE_NAME = "istanbul";
    @NlsSafe
    public static final String NYC_PACKAGE_NAME = "nyc";
    private final Project myProject;
    private final ExecutionEnvironment myEnv;
    private final NodePackage myMochaPackage;
    private final MochaRunSettings myRunSettings;
    private File myCoverageTempDir;

    private MochaCoverageRunState(@NotNull ExecutionEnvironment env, @NotNull NodePackage mochaPackage, @NotNull MochaRunSettings runSettings) {
        if (env == null) {
            MochaCoverageRunState.$$$reportNull$$$0(0);
        }
        if (mochaPackage == null) {
            MochaCoverageRunState.$$$reportNull$$$0(1);
        }
        if (runSettings == null) {
            MochaCoverageRunState.$$$reportNull$$$0(2);
        }
        this.myProject = env.getProject();
        this.myEnv = env;
        this.myMochaPackage = mochaPackage;
        this.myRunSettings = runSettings;
    }

    @Nullable
    public static MochaCoverageRunState create(@NotNull ExecutionEnvironment env, @NotNull NodePackage mochaPackage, @NotNull MochaRunSettings runSettings) {
        if (env == null) {
            MochaCoverageRunState.$$$reportNull$$$0(3);
        }
        if (mochaPackage == null) {
            MochaCoverageRunState.$$$reportNull$$$0(4);
        }
        if (runSettings == null) {
            MochaCoverageRunState.$$$reportNull$$$0(5);
        }
        if (env.getExecutor().getId().equals("Coverage")) {
            return new MochaCoverageRunState(env, mochaPackage, runSettings);
        }
        return null;
    }

    @Nullable
    private VirtualFile getWorkingDirectory() {
        return LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getWorkingDir());
    }

    @NotNull
    private NodePackage findPackage(@NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        VirtualFile workingDirectory;
        NodePackage pkg;
        if (interpreter == null) {
            MochaCoverageRunState.$$$reportNull$$$0(6);
        }
        if ((pkg = this.findPackage(NYC_PACKAGE_NAME, workingDirectory = this.getWorkingDirectory(), interpreter)) == null || !pkg.isValid()) {
            pkg = this.findPackage(ISTANBUL_PACKAGE_NAME, workingDirectory, interpreter);
        }
        if (pkg != null && pkg.isValid()) {
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                MochaCoverageRunState.$$$reportNull$$$0(7);
            }
            return nodePackage;
        }
        throw MochaCoveragePackageNotFoundException.create(this.myProject, this.myMochaPackage, this.myEnv, interpreter, this.myRunSettings.getWorkingDir());
    }

    @Nullable
    private NodePackage findPackage(@NotNull String packageName, @Nullable VirtualFile workingDirectory, @NotNull NodeJsInterpreter interpreter) {
        File pkgDir;
        ResolvedModuleInfo info;
        if (packageName == null) {
            MochaCoverageRunState.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            MochaCoverageRunState.$$$reportNull$$$0(9);
        }
        if (workingDirectory != null && (info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir((VirtualFile)workingDirectory, (String)packageName, (NodeModuleDirectorySearchProcessor)NodeModuleDirectorySearchProcessor.PROCESSOR)) != null && info.getModuleSourceRoot().isDirectory()) {
            return new NodePackage(info.getModuleSourceRoot().getPath());
        }
        File mochaNodeModulesDir = new File(this.myMochaPackage.getSystemDependentPath()).getParentFile();
        if (mochaNodeModulesDir != null && mochaNodeModulesDir.getName().equals("node_modules") && (pkgDir = new File(mochaNodeModulesDir, packageName)).isDirectory()) {
            return new NodePackage(pkgDir.getAbsolutePath());
        }
        return NodePackage.findDefaultPackage((Project)this.myProject, (String)packageName, (NodeJsInterpreter)interpreter);
    }

    public boolean configure(@NotNull NodeTargetRun targetRun) throws ExecutionException {
        NodePackage pkg;
        if (targetRun == null) {
            MochaCoverageRunState.$$$reportNull$$$0(10);
        }
        if ((pkg = this.findPackage(targetRun.getInterpreter())).getName().equals(ISTANBUL_PACKAGE_NAME)) {
            this.configureIstanbul(targetRun, pkg);
            return true;
        }
        this.configureNyc(targetRun, pkg);
        return false;
    }

    private static void throwFileNotFound(@NotNull File file, @NotNull String packageName) throws ExecutionException {
        if (file == null) {
            MochaCoverageRunState.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            MochaCoverageRunState.$$$reportNull$$$0(12);
        }
        throw new ExecutionException(NodeJSBundle.message("mocha.coverage.invalid_package.file_not_found.message", packageName, file.getAbsolutePath()));
    }

    private void configureNyc(@NotNull NodeTargetRun targetRun, @NotNull NodePackage nycPackage) throws ExecutionException {
        File nycBinFile;
        if (targetRun == null) {
            MochaCoverageRunState.$$$reportNull$$$0(13);
        }
        if (nycPackage == null) {
            MochaCoverageRunState.$$$reportNull$$$0(14);
        }
        if (!(nycBinFile = new File(nycPackage.getSystemDependentPath(), "bin/nyc.js")).isFile()) {
            MochaCoverageRunState.throwFileNotFound(nycBinFile, NYC_PACKAGE_NAME);
        }
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.addParameter(targetRun.path(nycBinFile.getAbsolutePath()));
        commandLine.addParameter("--reporter=lcovonly");
        SemVer version = nycPackage.getVersion(this.myProject);
        if (version == null || !version.isGreaterOrEqualThan(15, 0, 0)) {
            this.addExtensionsIfNoConfigurationFound(commandLine);
        }
        commandLine.addParameter("--report-dir");
        commandLine.addParameter(targetRun.path(this.createCoverageTempDir().getAbsolutePath()));
    }

    private void addExtensionsIfNoConfigurationFound(@NotNull TargetedCommandLineBuilder commandLine) {
        VirtualFile packageJson;
        VirtualFile workingDirectory;
        boolean nycConfigurationFound;
        if (commandLine == null) {
            MochaCoverageRunState.$$$reportNull$$$0(15);
        }
        boolean bl = nycConfigurationFound = this.findConfig(".nycrc") != null;
        if (!nycConfigurationFound && (workingDirectory = this.getWorkingDirectory()) != null && (packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)workingDirectory)) != null) {
            PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            nycConfigurationFound = data.getTopLevelProperties().contains(NYC_PACKAGE_NAME);
        }
        if (!nycConfigurationFound) {
            String[] extensions;
            for (String ext : extensions = new String[]{".js", ".cjs", ".mjs", ".ts", ".tsx", ".jsx"}) {
                commandLine.addParameter("--extension=" + ext);
            }
        }
    }

    private void configureIstanbul(@NotNull NodeTargetRun targetRun, @NotNull NodePackage istanbulPackage) throws ExecutionException {
        File istanbulBinFile;
        if (targetRun == null) {
            MochaCoverageRunState.$$$reportNull$$$0(16);
        }
        if (istanbulPackage == null) {
            MochaCoverageRunState.$$$reportNull$$$0(17);
        }
        if (!(istanbulBinFile = new File(istanbulPackage.getSystemDependentPath(), "lib/cli.js")).isFile()) {
            MochaCoverageRunState.throwFileNotFound(istanbulBinFile, ISTANBUL_PACKAGE_NAME);
        }
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.addParameter(targetRun.path(istanbulBinFile.getAbsolutePath()));
        commandLine.addParameter("cover");
        commandLine.addParameter("--report=lcovonly");
        VirtualFile istanbulConfig = this.findConfig(".istanbul.yml");
        if (istanbulConfig == null) {
            String[] extensions;
            for (String ext : extensions = new String[]{".ts", ".js"}) {
                commandLine.addParameter("--extension=" + ext);
            }
            List<String> testPatterns = this.getTestFilesPatterns();
            for (String testPattern : testPatterns) {
                commandLine.addParameters(new String[]{"-x", FileUtil.toSystemIndependentName((String)testPattern)});
            }
        }
        commandLine.addParameter("--dir");
        commandLine.addParameter(targetRun.path(this.createCoverageTempDir().getAbsolutePath()));
    }

    @NotNull
    private File createCoverageTempDir() throws ExecutionException {
        File file;
        try {
            File dir;
            this.myCoverageTempDir = dir = FileUtil.createTempDirectory((String)"mocha-intellij-coverage-", null);
            file = dir;
        }
        catch (IOException e) {
            throw new ExecutionException(NodeJSBundle.message("mocha.coverage.cannot_create_temporary_directory.message", new Object[0]), (Throwable)e);
        }
        if (file == null) {
            MochaCoverageRunState.$$$reportNull$$$0(18);
        }
        return file;
    }

    @Nullable
    public File getCoverageDir() {
        return this.myCoverageTempDir;
    }

    @Nullable
    private VirtualFile findConfig(@NotNull String configName) {
        if (configName == null) {
            MochaCoverageRunState.$$$reportNull$$$0(19);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        for (VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(this.myRunSettings.getWorkingDir()); dir != null && dir.isValid() && fileIndex.getContentRootForFile(dir, false) != null; dir = dir.getParent()) {
            VirtualFile config = dir.findChild(configName);
            if (config == null) continue;
            return config;
        }
        return null;
    }

    @NotNull
    private List<String> getTestFilesPatterns() {
        if (this.myRunSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            String basePattern = this.getPathRelativeToWorkingDir(this.myRunSettings.getTestDirPath());
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{basePattern + "/**/*.spec.*", basePattern + "/**/*.test.*"});
            if (arrayList == null) {
                MochaCoverageRunState.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        if (this.myRunSettings.getTestKind() == MochaTestKind.TEST_FILE || this.myRunSettings.getTestKind() == MochaTestKind.SUITE || this.myRunSettings.getTestKind() == MochaTestKind.TEST) {
            List<String> list = Collections.singletonList(this.getPathRelativeToWorkingDir(this.myRunSettings.getTestFilePath()));
            if (list == null) {
                MochaCoverageRunState.$$$reportNull$$$0(21);
            }
            return list;
        }
        if (this.myRunSettings.getTestKind() == MochaTestKind.PATTERN) {
            List list = ParametersListUtil.parse((String)this.myRunSettings.getTestFilePattern());
            if (list == null) {
                MochaCoverageRunState.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            MochaCoverageRunState.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private String getPathRelativeToWorkingDir(@NotNull String path) {
        String relative;
        if (path == null) {
            MochaCoverageRunState.$$$reportNull$$$0(24);
        }
        String result = path;
        if (!this.myRunSettings.getWorkingDir().isEmpty() && path.startsWith(this.myRunSettings.getWorkingDir()) && (relative = path.substring(this.myRunSettings.getWorkingDir().length())).length() > 1) {
            result = StringUtil.trimStart((String)StringUtil.trimStart((String)relative, (String)"\\"), (String)"/");
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)result, (String)"\\"), (String)"/");
        if (string == null) {
            MochaCoverageRunState.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/coverage/MochaCoverageRunState";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nycPackage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "istanbulPackage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/coverage/MochaCoverageRunState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageTempDir";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFilesPatterns";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelativeToWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "throwFileNotFound";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "configureNyc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionsIfNoConfigurationFound";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "configureIstanbul";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findConfig";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToWorkingDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

