package com.intellij.psi.css.descriptor;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

/**
 * Css media types. 
 * Relationship between media groups and media types can be found at http://www.w3.org/TR/CSS21/media.html
 */
public enum CssMediaType {
  ALL(CssMediaGroup.values()),
  
  BRAILLE(CssMediaGroup.CONTINUOUS, CssMediaGroup.TACTILE, CssMediaGroup.GRID, CssMediaGroup.INTERACTIVE, CssMediaGroup.STATIC),
  EMBOSSED(CssMediaGroup.PAGED, CssMediaGroup.TACTILE, CssMediaGroup.GRID, CssMediaGroup.STATIC),
  HANDHELD(CssMediaGroup.CONTINUOUS, CssMediaGroup.PAGED, CssMediaGroup.VISUAL, CssMediaGroup.AUDIO, CssMediaGroup.SPEECH,
           CssMediaGroup.GRID, CssMediaGroup.BITMAP, CssMediaGroup.INTERACTIVE, CssMediaGroup.STATIC),
  PRINT(CssMediaGroup.PAGED, CssMediaGroup.VISUAL, CssMediaGroup.BITMAP, CssMediaGroup.STATIC),
  PROJECTION(CssMediaGroup.PAGED, CssMediaGroup.VISUAL, CssMediaGroup.AUDIO, CssMediaGroup.BITMAP, CssMediaGroup.INTERACTIVE),
  SCREEN(CssMediaGroup.CONTINUOUS, CssMediaGroup.VISUAL, CssMediaGroup.AUDIO, CssMediaGroup.BITMAP, CssMediaGroup.INTERACTIVE,
         CssMediaGroup.STATIC),
  SPEECH(CssMediaGroup.CONTINUOUS, CssMediaGroup.SPEECH, CssMediaGroup.INTERACTIVE, CssMediaGroup.STATIC, CssMediaGroup.AURAL),
  AURAL(SPEECH.mySupportedGroups),
  TTY(CssMediaGroup.CONTINUOUS, CssMediaGroup.VISUAL, CssMediaGroup.GRID, CssMediaGroup.INTERACTIVE, CssMediaGroup.STATIC),
  TV(CssMediaGroup.CONTINUOUS, CssMediaGroup.PAGED, CssMediaGroup.VISUAL, CssMediaGroup.AUDIO, CssMediaGroup.BITMAP,
     CssMediaGroup.INTERACTIVE, CssMediaGroup.STATIC),
  UNKNOWN;

  private final CssMediaGroup[] mySupportedGroups;

  CssMediaType(CssMediaGroup... supportedGroups) {
    mySupportedGroups = supportedGroups;
  }

  public static CssMediaType fromString(@NotNull String s) {
    try {
      return valueOf(StringUtil.toUpperCase(s));
    }
    catch (IllegalArgumentException ignored) {
    }
    return UNKNOWN;
  }

  public CssMediaGroup[] getSupportedGroups() {
    return mySupportedGroups;
  }
}
