/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import org.jetbrains.annotations.NotNull;

public final class Specificity implements Comparable {
  public static final Specificity UNLIMITED = new Specificity(Integer.MAX_VALUE,Integer.MAX_VALUE, Integer.MAX_VALUE);
  public static final Specificity EMPTY = new Specificity(0, 0, 0);

  private final int myAttributesNumber;
  private final int myElementNamesNumber;
  private final int myIdAttributesNumber;

  public Specificity(int idAttributesNumber, int attributesNumber, int elementNamesNumber) {
    myIdAttributesNumber = idAttributesNumber;
    myAttributesNumber = attributesNumber;
    myElementNamesNumber = elementNamesNumber;
  }

  public int getIdAttributesNumber() {
    return myIdAttributesNumber;
  }

  public int getAttributesNumber() {
    return myAttributesNumber;
  }

  public int getElementNamesNumber() {
    return myElementNamesNumber;
  }

  @Override
  public int compareTo(@NotNull Object o) {
    Specificity specificity = (Specificity) o;
    int d = myIdAttributesNumber - specificity.myIdAttributesNumber;
    if (d != 0) {
      return d;
    }
    d = myAttributesNumber - specificity.myAttributesNumber;
    if (d != 0) {
      return d;
    }
    return myElementNamesNumber - specificity.myElementNamesNumber;
  }

}
