package com.intellij.psi.css;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssPropertyDescriptor extends CssValueOwnerDescriptor, CssMediaGroupAwareDescriptor {
  boolean isValidValue(@NotNull PsiElement element);

  boolean isShorthandValue();

  String @NotNull [] expand(@NotNull CssDeclaration declaration);

  PsiElement @Nullable [] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName);

  boolean is4ValueProperty();

  CssPropertyValue getReferencedPropertyValue(@NotNull String name);

  CssPropertyInfo @NotNull [] getInfos();

  boolean isInherited();

  @Nullable
  String getInitialValue();

  @Nullable
  String getAppliesToValue();

  @Nullable
  String getPercentageValue();

  @NotNull
  String getPropertyName();

  Object[] getAllVariants();

  String @Nullable [] getRefNames();

  Object @NotNull [] getVariants(@NotNull PsiElement contextElement);

  /**
   * @deprecated use this#isInherited
   */
  @Deprecated
  boolean getInherited();

  @NotNull @NlsSafe String toCanonicalName(@NotNull String propertyName);

  CssPropertyValue getValue();

  PsiElement @NotNull [] getDeclarations(PsiElement context);

  boolean allowsIntegerWithoutSuffix();
}
