/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class CssElementVisitor extends PsiElementVisitor {
  public void visitCssBlock(final CssBlock block) {
    visitCssElement(block);
  }

  public void visitCssElement(final CssElement element) {
    visitElement(element);
  }

  public void visitStylesheetFile(final StylesheetFile file) {
    if (file instanceof CssFile) {
      visitCssFile((CssFile)file);
    }
    else {
      visitFile(file);
    }
  }

  public void visitCssFile(final CssFile file) {
    visitFile(file);
  }

  public void visitCssRuleset(final CssRuleset ruleset) {
    visitCssElement(ruleset);
  }

  public void visitCssDeclaration(final CssDeclaration declaration) {
    visitCssElement(declaration);
  }

  public void visitCssStylesheet(final CssStylesheet stylesheet) {
    visitCssElement(stylesheet);
  }

  public void visitCssSelector(final CssSelector selector) {
    visitCssElement(selector);
  }

  public void visitCssSimpleSelector(final CssSimpleSelector selector) {
    visitCssElement(selector);
  }

  public void visitCssSelectorList(final CssSelectorList selectorList) {
    visitCssElement(selectorList);
  }

  public void visitCssRulesetList(final CssRulesetList rulesetList) {
    visitCssElement(rulesetList);
  }

  public void visitCssImport(final CssImport _import) {
    visitCssElement(_import);
  }

  public void visitCssString(final CssString _string) {
    visitCssElement(_string);
  }

  public void visitCssTerm(final CssTerm _term) {
    visitCssElement(_term);
  }

  public void visitCssFunction(final CssFunction _function) {
    visitCssElement(_function);
  }

  public void visitCssCharset(final CssCharset charset) {
    visitCssElement(charset);
  }

  public void visitCssTermList(final CssTermList cssTermList) {
    visitCssElement(cssTermList);
  }

  public void visitCssUri(final CssUri uri) {
    visitCssElement(uri);
  }

  public void visitAtRule(final CssAtRule atRule) {
    visitCssElement(atRule);
  }

  public void visitPseudoSelector(final CssPseudoSelector pseudoSelector) {
    visitCssElement(pseudoSelector);
  }

  public void visitCssImportList(CssImportList importList) {
    visitCssElement(importList);
  }

  public void visitNamespaceList(CssNamespaceList namespaceList) {
    visitCssElement(namespaceList);
  }

  public void visitNamespace(CssNamespace namespace) {
    visitCssElement(namespace);
  }

  public void visitCssOperation(@NotNull CssOperation operation) {
    visitCssElement(operation);
  }

  public void visitMediaExpression(@NotNull CssMediaExpression mediaExpression) {
    visitCssElement(mediaExpression);
  }

  public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
    visitCssElement(mediaFeature);
  }

  /**
   * @deprecated {@link CssLineNames} class has been morphed into more general {@link CssBracketedList} class, use it instead.
   */
  @Deprecated
  public void visitLineNames(@NotNull CssLineNames lineNames) {
    visitBracketedList((CssBracketedList)lineNames);
  }

  public void visitBracketedList(@NotNull CssBracketedList bracketedList) {
    visitCssElement(bracketedList);
  }

  public void visitCustomMixin(@NotNull CssCustomMixin customMixin) {
    visitCssElement(customMixin);
  }

  public void visitValueImportedAlias(CssValueImportedAlias valueImportedAlias) {
    visitCssElement(valueImportedAlias);
  }

  public void visitValueDeclaration(CssValueDeclaration declaration) {
    visitCssElement(declaration);
  }
}
