package com.intellij.css.util;

import com.intellij.psi.css.descriptor.CssMediaGroup;
import org.jetbrains.annotations.NonNls;

import java.util.Set;

import static com.intellij.util.containers.ContainerUtil.newHashSet;

public final class CssConstants {
  @NonNls public static final String AND = "and";
  @NonNls public static final String NOT = "not";
  @NonNls public static final String ANY = "any";
  @NonNls public static final String UNUSED = "unused";
  @NonNls public static final String ONLY = "only";
  @NonNls public static final String OR = "or";

  @NonNls public static final String SUPPORTS = "supports";

  @NonNls public static final String SEMICOLON = ";";

  @NonNls public static final String INHERIT_VALUE = "inherit";

  public static final CssMediaGroup[] DEFAULT_MEDIA_GROUPS = new CssMediaGroup[]{CssMediaGroup.ALL};

  @NonNls public static final String ATTR_FUNCTION_NAME = "attr";
  @NonNls public static final String CALC_FUNCTION_NAME = "calc";
  @NonNls public static final String MAX_FUNCTION_NAME = "max";
  @NonNls public static final String MIN_FUNCTION_NAME = "min";
  @NonNls public static final String CLAMP_FUNCTION_NAME = "clamp";
  @NonNls public static final String TOGGLE_FUNCTION_NAME = "toggle";
  @NonNls public static final String VAR_FUNCTION_NAME = "var";
  @NonNls public static final String IMAGE_FUNCTION_NAME = "image";
  @NonNls public static final String RECT_FUNCTION_NAME = "rect";
  @NonNls public static final String COUNTER_FUNCTION_NAME = "counter";

  @NonNls public static final String LOCAL = "local";
  @NonNls public static final String GLOBAL = "global";
  @NonNls public static final String COMPOSES = "composes";

  public static final Set<String> COLOR_FUNCTIONS = newHashSet("rgb", "rgba", "hsl", "hsla", "gray", "hwb", "color");
  public static final Set<String> FUNCTIONS_OVER_COLOR = newHashSet("color", "blend", "blenda");

  private CssConstants() {
  }
}
