/*
 * Copyright 2000-2019 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.toolWindow;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ResourceBundle;

/**
 * Provides content tab for Spring toolwindow.
 *
 * @author Yann C&eacute;bron
 */
public final class SpringToolWindowContent extends BaseKeyedLazyInstance<SpringToolWindowContentProvider> {
  private static final Logger LOG = Logger.getInstance(SpringToolWindowContent.class);

  public static final String TOOLWINDOW_ID = "Spring";
  public static final DataKey<SpringToolWindowContentUpdater> CONTENT_UPDATER = DataKey.create("springToolWindowContentUpdater");

  @Attribute("displayName")
  @NlsContexts.TabTitle
  public String displayName;

  @Attribute("icon")
  public String icon;

  @Attribute("bundle")
  public String bundle;

  @Attribute("implementation")
  public String implementation;

  public @NlsContexts.TabTitle @NotNull String getDisplayName() {
    String baseName = bundle != null ? bundle : getPluginDescriptor().getResourceBundleBaseName();
    if (baseName == null) {
      LOG.error("No resource bundle specified for " + getPluginDescriptor());
      return displayName;
    }

    ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, getLoaderForClass());
    return AbstractBundle.message(bundle, displayName);
  }

  @Override
  protected @Nullable String getImplementationClassName() {
    return implementation;
  }
}
