/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.references.property;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.ReferenceSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Reference to bean property path ({@code property.nestedProperty}).
 * <p/>
 * Override {@link #isSoft()} to build non-soft references.
 *
 * @author Yann C&eacute;bron
 */
public class BindingPropertyReferenceSet extends ReferenceSetBase<BindingPropertyReference> {

  @Nullable
  private final PsiClass myModelClass;

  public BindingPropertyReferenceSet(PsiElement element,
                                     @Nullable PsiClass modelClass) {
    super(element);

    myModelClass = modelClass;
  }

  @Nullable
  @Override
  protected BindingPropertyReference createReference(TextRange range, int index) {
    return new BindingPropertyReference(this, range, index);
  }

  @Override
  public PsiReference @NotNull [] getPsiReferences() {
    return getReferences().toArray(new BindingPropertyReference[0]);
  }

  @Nullable
  protected PsiClass getModelClass() {
    return myModelClass;
  }
}
