/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/beans

package com.intellij.spring.model.xml.beans;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.converters.BeanPropertyConverter;
import com.intellij.util.xml.*;

import java.util.List;

import static com.intellij.spring.constants.SpringCorePresentationConstants.SPRING_PROPERTY;

/**
 * http://www.springframework.org/schema/beans:propertyType interface.
 */
@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
@Presentation(typeName = SPRING_PROPERTY, icon = "SpringApiIcons.SpringProperty")
public interface SpringProperty extends SpringInjection, SpringPropertyDefinition {

  /**
   * Returns the value of the name child.
   * <pre>
   * <h3>Attribute null:name documentation</h3>
   * 	The name of the property, following JavaBean naming conventions.
   * <p/>
   * </pre>
   *
   * @return the value of the name child.
   */
  @Required
  @Convert(BeanPropertyConverter.class)
  @NameValue(referencable = false)
  @Stubbed
  GenericAttributeValue<List<BeanProperty>> getName();
}
