// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.xml.beans;

import com.intellij.util.xml.NamedEnum;
import org.jetbrains.annotations.NonNls;

public enum DefaultableBoolean implements NamedEnum {
  DEFAULT("default"),
  FALSE("false"),
  TRUE("true");

  private final String value;

  DefaultableBoolean(@NonNls String value) {
    this.value = value;
  }

  @Override
  public String getValue() {
    return value;
  }

  public Boolean getBooleanValue() {
    return Boolean.parseBoolean(value);
  }
}
